/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterExecutionSuppressor;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 :2\u00020\u0001:\u0001:B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u001a\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u001c\u0010#\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0017\u0010&\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b'2\u0006\u0010(\u001a\u00020\u0003H\u0002J+\u0010)\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b*2\u0006\u0010(\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0017\u0010+\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b*2\u0006\u0010(\u001a\u00020\u0003H\u0007J\u000e\u0010,\u001a\u00020-2\u0006\u0010(\u001a\u00020\u0003J\u0012\u0010.\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010/\u001a\u00020\u000f2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0003H\u0016J\n\u00104\u001a\u0004\u0018\u000105H\u0007J\u001c\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u00010\u0003H\u0007J*\u00108\u001a\u0004\u0018\u00010\u00062\u0006\u00106\u001a\u00020\u00032\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u0019\u0010!\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\nR\u0011\u0010#\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0010R\u0014\u00109\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0010\u00a8\u0006;"}, d2={"Lcom/intellij/javascript/nodejs/util/NodePackage;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "systemDependentPath", "getSystemDependentPath", "()Ljava/lang/String;", "cachedDir", "systemIndependentPath", "getSystemIndependentPath", "isEmptyPath", "", "()Z", "name", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "version", "Lcom/intellij/util/text/SemVer;", "getVersion", "()Lcom/intellij/util/text/SemVer;", "project", "Lcom/intellij/openapi/project/Project;", "getVersionPromise", "Lorg/jetbrains/concurrency/Promise;", "dir", "getDir", "()Ljava/nio/file/Path;", "dir$delegate", "Lkotlin/Lazy;", "presentablePath", "getPresentablePath", "isValid", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "validateLocalPackageDirectory", "Lorg/jetbrains/annotations/Nls;", "packageName", "validateAndGetErrorMessage", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "getErrorMessage", "validateForRunConfiguration", "", "getAbsolutePackagePathToRequire", "equals", "o", "hashCode", "", "toString", "findBinFile", "Ljava/io/File;", "executableName", "failoverBinRelativePath", "findBinFilePath", "isBundled", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nNodePackage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodePackage.kt\ncom/intellij/javascript/nodejs/util/NodePackage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,252:1\n13#2:253\n*S KotlinDebug\n*F\n+ 1 NodePackage.kt\ncom/intellij/javascript/nodejs/util/NodePackage\n*L\n199#1:253\n*E\n"})
public class NodePackage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String systemDependentPath;
    @Nullable
    private Path cachedDir;
    @NotNull
    private final Lazy dir$delegate;
    @NotNull
    private static final Logger LOG;

    public NodePackage(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (!(this instanceof YarnPnpNodePackage) && StringsKt.startsWith$default((String)path2, (String)"yarn:", (boolean)false, (int)2, null)) {
            LOG.warn(new Throwable("Unexpected " + this.getClass() + " is created for " + path2));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Created " + this.getClass() + " for " + path2);
        }
        String string = FileUtil.toSystemIndependentName((String)path2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String string2 = FileUtil.toSystemDependentName((String)StringsKt.removeSuffix((String)string, (CharSequence)"/"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        this.systemDependentPath = string2;
        this.dir$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> NodePackage.dir_delegate$lambda$0(this));
    }

    @NotNull
    public final String getSystemDependentPath() {
        return this.systemDependentPath;
    }

    public NodePackage(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this(LocalFilePath.Companion.asLocalFilePath(path2));
        this.cachedDir = path2;
    }

    @NotNull
    public final String getSystemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.systemDependentPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    public final boolean isEmptyPath() {
        return ((CharSequence)this.systemDependentPath).length() == 0;
    }

    @NotNull
    public String getName() {
        int ind = StringsKt.lastIndexOf$default((CharSequence)this.systemDependentPath, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null);
        if (ind >= 0) {
            int prev = StringsKt.lastIndexOf$default((CharSequence)this.systemDependentPath, (char)File.separatorChar, (int)(ind - 1), (boolean)false, (int)4, null);
            if (prev >= 0 && this.systemDependentPath.charAt(prev + 1) == '@') {
                String string = this.systemDependentPath.substring(prev + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = FileUtil.toSystemIndependentName((String)string);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
                return string2;
            }
            String string = this.systemDependentPath.substring(ind + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return this.systemDependentPath;
    }

    @Nullable
    public SemVer getVersion() {
        Path path2 = this.getDir();
        if (path2 == null) {
            return null;
        }
        Path packageDir = path2;
        return NodePackageVersionUtil.getPackageVersion(packageDir);
    }

    @Nullable
    public SemVer getVersion(@Nullable Project project) {
        return this.getVersion();
    }

    @NotNull
    public Promise<SemVer> getVersionPromise(@Nullable Project project) {
        return Promises.resolvedPromise((Object)this.getVersion(project));
    }

    private final Path getDir() {
        Lazy lazy = this.dir$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public String getPresentablePath() {
        String string = FileUtil.toSystemDependentName((String)SystemProperties.getUserHome());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        String userHome = StringsKt.removeSuffix((String)string, (CharSequence)string2);
        if (StringsKt.isBlank((CharSequence)userHome)) {
            return this.systemDependentPath;
        }
        if (StringsKt.startsWith$default((String)this.systemDependentPath, (String)(userHome + File.separatorChar), (boolean)false, (int)2, null)) {
            String string3 = this.systemDependentPath.substring(userHome.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return "~" + string3;
        }
        return this.systemDependentPath;
    }

    @Deprecated(message="use {@link #isValid(Project, NodeJsInterpreter)} instead")
    public final boolean isValid() {
        return this.isValid(null, null);
    }

    @Deprecated(message="use {@link #isValid(Project, NodeJsInterpreter)} instead")
    public final boolean isValid(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.isValid(project, null);
    }

    public boolean isValid(@Nullable Project project, @Nullable NodeJsInterpreter interpreter2) {
        Path d;
        if (StringsKt.isBlank((CharSequence)this.systemDependentPath)) {
            return false;
        }
        if (project != null) {
            for (JSLinterExecutionSuppressor factory : JSLinterExecutionSuppressor.EP_NAME.getExtensionList()) {
                boolean shouldSuppress = factory.shouldSuppress(this.systemDependentPath);
                if (!shouldSuppress) continue;
                return false;
            }
        }
        return (d = this.getDir()) != null && d.isAbsolute() && Files.isDirectory(d, new LinkOption[0]);
    }

    private final String validateLocalPackageDirectory(String packageName) {
        Path d = this.getDir();
        if (d == null || !d.isAbsolute() || !Files.isDirectory(d, new LinkOption[0])) {
            if (d != null && Files.isRegularFile(d, new LinkOption[0])) {
                Object[] objectArray = new Object[]{packageName};
                return JavaScriptBundle.message((String)"dialog.message.invalid.package.file.specified.but.directory.with.package.json.expected", (Object[])objectArray);
            }
            Object[] objectArray = new Object[]{packageName};
            return JavaScriptBundle.message((String)"dialog.message.invalid.package.no.such.directory", (Object[])objectArray);
        }
        return null;
    }

    @Nullable
    public String validateAndGetErrorMessage(@NotNull String packageName, @Nullable Project project, @Nullable NodeJsInterpreter interpreter2) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (StringsKt.isBlank((CharSequence)this.systemDependentPath)) {
            Object[] objectArray = new Object[]{packageName};
            return JavaScriptBundle.message((String)"dialog.message.unspecified.package", (Object[])objectArray);
        }
        return this.validateLocalPackageDirectory(packageName);
    }

    @Deprecated(message="use {@link #validateAndGetErrorMessage(String, Project, NodeJsInterpreter)} instead")
    @Nullable
    public final String getErrorMessage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.validateAndGetErrorMessage(packageName, null, null);
    }

    public final void validateForRunConfiguration(@NotNull String packageName) throws RuntimeConfigurationError {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String message = this.validateAndGetErrorMessage(packageName, null, null);
        if (message != null) {
            throw new RuntimeConfigurationError(message);
        }
    }

    @Nullable
    public String getAbsolutePackagePathToRequire(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.systemDependentPath;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Intrinsics.areEqual(this.getClass(), o.getClass())) {
            return false;
        }
        NodePackage aPackage = (NodePackage)o;
        return Intrinsics.areEqual((Object)this.systemDependentPath, (Object)aPackage.systemDependentPath);
    }

    public int hashCode() {
        return this.systemDependentPath.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getPresentablePath();
    }

    @Deprecated(message="use {@link #findBinFile(String, String)} instead")
    @Nullable
    public final File findBinFile() {
        return this.findBinFile(this.getName(), null);
    }

    @Deprecated(message="use {@link #findBinFile(String, String)} returning java.nio.Path instead")
    @Nullable
    public final File findBinFile(@NotNull String executableName, @Nullable String failoverBinRelativePath) {
        Intrinsics.checkNotNullParameter((Object)executableName, (String)"executableName");
        Path path2 = this.findBinFilePath(executableName, failoverBinRelativePath, null);
        return path2 != null ? path2.toFile() : null;
    }

    @JvmOverloads
    @Nullable
    public final Path findBinFilePath(@NotNull String executableName, @Nullable String failoverBinRelativePath, @Nullable NodeJsInterpreter interpreter2) {
        Intrinsics.checkNotNullParameter((Object)executableName, (String)"executableName");
        Path path2 = this.getDir();
        if (path2 == null) {
            return null;
        }
        Path packageDir = path2;
        return NodePackage.Companion.findBinFile(packageDir, executableName, failoverBinRelativePath, interpreter2);
    }

    public static /* synthetic */ Path findBinFilePath$default(NodePackage nodePackage, String string, String string2, NodeJsInterpreter nodeJsInterpreter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findBinFilePath");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            nodeJsInterpreter = null;
        }
        return nodePackage.findBinFilePath(string, string2, nodeJsInterpreter);
    }

    public boolean isBundled() {
        return false;
    }

    @JvmOverloads
    @Nullable
    public final Path findBinFilePath(@NotNull String executableName, @Nullable String failoverBinRelativePath) {
        Intrinsics.checkNotNullParameter((Object)executableName, (String)"executableName");
        return NodePackage.findBinFilePath$default(this, executableName, failoverBinRelativePath, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final Path findBinFilePath(@NotNull String executableName) {
        Intrinsics.checkNotNullParameter((Object)executableName, (String)"executableName");
        return NodePackage.findBinFilePath$default(this, executableName, null, null, 6, null);
    }

    private static final Path dir_delegate$lambda$0(NodePackage this$0) {
        Path path2;
        if (StringsKt.isBlank((CharSequence)this$0.systemDependentPath)) {
            path2 = null;
        } else {
            Path path3;
            try {
                path3 = Path.of(this$0.systemDependentPath, new String[0]);
            }
            catch (InvalidPathException invalidPathException) {
                path3 = null;
            }
            path2 = path3;
        }
        return path2;
    }

    @JvmStatic
    @Nullable
    public static final NodePackage findDefaultPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter2) {
        return Companion.findDefaultPackage(project, packageName, interpreter2);
    }

    @JvmStatic
    @NotNull
    public static final NodePackage findPreferredPackage(@NotNull Project project, @NotNull List<String> packageNames, @Nullable NodeJsInterpreter interpreter2) {
        return Companion.findPreferredPackage(project, packageNames, interpreter2);
    }

    @JvmStatic
    @NotNull
    public static final NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter2) {
        return Companion.findPreferredPackage(project, packageName, interpreter2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NodePackage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\"\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J.\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/nodejs/util/NodePackage$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "findDefaultPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "project", "Lcom/intellij/openapi/project/Project;", "packageName", "", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "findPreferredPackage", "packageNames", "", "findBinFile", "Ljava/nio/file/Path;", "packageDir", "executableName", "failoverBinRelativePath", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final NodePackage findDefaultPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            List<NodePackage> list = new NodePackageDescriptor(packageName).listAvailable(project, interpreter2, null);
            Intrinsics.checkNotNullExpressionValue(list, (String)"listAvailable(...)");
            List<NodePackage> packages = list;
            return (NodePackage)CollectionsKt.firstOrNull(packages);
        }

        @JvmStatic
        @NotNull
        public final NodePackage findPreferredPackage(@NotNull Project project, @NotNull List<String> packageNames, @Nullable NodeJsInterpreter interpreter2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(packageNames, (String)"packageNames");
            NodePackage nodePackage = new NodePackageDescriptor(packageNames).findFirstDirectDependencyPackage(project, interpreter2, null);
            Intrinsics.checkNotNullExpressionValue((Object)nodePackage, (String)"findFirstDirectDependencyPackage(...)");
            return nodePackage;
        }

        @JvmStatic
        @NotNull
        public final NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            NodePackage nodePackage = new NodePackageDescriptor(packageName).findFirstDirectDependencyPackage(project, interpreter2, null);
            Intrinsics.checkNotNullExpressionValue((Object)nodePackage, (String)"findFirstDirectDependencyPackage(...)");
            return nodePackage;
        }

        private final Path findBinFile(Path packageDir, String executableName, String failoverBinRelativePath, NodeJsInterpreter interpreter2) {
            Path packageJsonFile = packageDir.resolve("package.json");
            Path binFile = null;
            if (Files.isRegularFile(packageJsonFile, new LinkOption[0])) {
                String binPath;
                VirtualFile vf;
                VirtualFile virtualFile = vf = LocalFileSystem.getInstance().findFileByNioFile(packageJsonFile);
                String string = binPath = virtualFile != null ? PackageJsonData.getOrCreate(virtualFile).getBinPath(executableName) : null;
                Path path2 = binFile = string != null ? packageDir.resolve(string) : null;
                if (binFile != null) {
                    binFile = binFile.normalize();
                }
            }
            if (!(binFile != null && Files.isRegularFile(binFile, new LinkOption[0]) || failoverBinRelativePath == null)) {
                binFile = packageDir.resolve(failoverBinRelativePath).normalize();
            }
            return binFile != null && (interpreter2 instanceof NodeJsRemoteInterpreter || Files.isRegularFile(binFile, new LinkOption[0])) ? binFile : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

