/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.config.webXml;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.Servlet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.SpringAutodetectedFilesetsSearcher;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringAutodetectedFileSet;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.config.ServletFileSet;
import com.intellij.spring.mvc.config.webXml.AnnotationServletFileSet;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WebXmlSpringWebModelContributor
implements SpringAutodetectedFilesetsSearcher {
    @NonNls
    private static final String APPLICATION_CONTEXT_FILESET = "web application context";

    WebXmlSpringWebModelContributor() {
    }

    @NotNull
    public List<? extends SpringAutodetectedFileSet> getFilesets(@NotNull SpringFacet springFacet) {
        Module module;
        if (springFacet == null) {
            WebXmlSpringWebModelContributor.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)(module = springFacet.getModule()).getProject()) || !SpringMvcLibraryUtil.hasSpringMvcLibrary(module)) {
            List list = Collections.emptyList();
            if (list == null) {
                WebXmlSpringWebModelContributor.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<SpringAutodetectedFileSet> result = new ArrayList<SpringAutodetectedFileSet>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            VirtualFile webInf;
            WebApp webApp = webFacet.getRoot();
            if (webApp == null || (webInf = WebXmlSpringWebModelContributor.getWebInf(webFacet)) == null) continue;
            SmartList servletFileSets = new SmartList();
            for (Servlet servlet : webApp.getServlets()) {
                SpringAutodetectedFileSet servletContextFileSet;
                String servletClass = servlet.getServletClass().getStringValue();
                String servletName = (String)servlet.getServletName().getValue();
                if (servletClass == null || servletName == null || !InheritanceUtil.isInheritor((PsiClass)((PsiClass)servlet.getServletClass().getValue()), (String)"org.springframework.web.servlet.DispatcherServlet")) continue;
                ParamValue param = (ParamValue)DomUtil.findByName((Collection)servlet.getInitParams(), (String)"contextConfigLocation");
                String id = "web " + servletName + " servlet context";
                String name = SpringMvcBundle.message("mvc.servlet.context.autodetected", servletName);
                if (param != null) {
                    servletContextFileSet = WebXmlSpringWebModelContributor.createFileSet(param, id, name, springFacet, servlet, WebXmlSpringWebModelContributor.isAnnotationConfig(servlet.getInitParams()));
                } else {
                    servletContextFileSet = WebXmlSpringWebModelContributor.createServletFileSet(id, name, springFacet, (CommonServlet)servlet, false);
                    servletContextFileSet.addFile(webInf.getUrl() + "/" + WebXmlSpringWebModelContributor.getServletContextFileName(servletName));
                }
                servletFileSets.add(servletContextFileSet);
            }
            if (servletFileSets.isEmpty()) continue;
            SpringAutodetectedFileSet appContext = null;
            String filesetName = SpringMvcBundle.message("mvc.application.context.autodetected", new Object[0]);
            ParamValue param = (ParamValue)DomUtil.findByName((Collection)webApp.getContextParams(), (String)"contextConfigLocation");
            if (param != null) {
                boolean isAnnotationConfig = WebXmlSpringWebModelContributor.isAnnotationConfig(webApp.getContextParams());
                appContext = WebXmlSpringWebModelContributor.createFileSet(param, APPLICATION_CONTEXT_FILESET, filesetName, springFacet, null, isAnnotationConfig);
            } else {
                VirtualFile file = webInf.findChild("applicationContext.xml");
                if (file != null) {
                    appContext = WebXmlSpringWebModelContributor.createServletFileSet(APPLICATION_CONTEXT_FILESET, filesetName, springFacet, null, false);
                    appContext.addFile(file);
                }
            }
            if (appContext != null) {
                result.add(appContext);
                for (SpringFileSet springFileSet : servletFileSets) {
                    springFileSet.addDependency((SpringFileSet)appContext);
                }
            }
            result.addAll((Collection<SpringAutodetectedFileSet>)servletFileSets);
        }
        ArrayList<SpringAutodetectedFileSet> arrayList = result;
        if (arrayList == null) {
            WebXmlSpringWebModelContributor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NonNls
    private static String getServletContextFileName(String servletName) {
        return servletName + "-servlet.xml";
    }

    @Nullable
    private static VirtualFile getWebInf(WebFacet facet) {
        if (facet.isDisposed()) {
            return null;
        }
        WebDirectoryElement webInf = WebUtil.getWebUtil().findWebDirectoryElement("/WEB-INF/", facet);
        return webInf == null ? null : webInf.getVirtualFile();
    }

    private static boolean isAnnotationConfig(List<? extends ParamValue> paramValues) {
        ParamValue param = (ParamValue)DomUtil.findByName(paramValues, (String)"contextClass");
        if (param != null) {
            return "org.springframework.web.context.support.AnnotationConfigWebApplicationContext".equals(param.getParamValue().getStringValue());
        }
        return false;
    }

    @NotNull
    private static SpringAutodetectedFileSet createFileSet(ParamValue param, String id, String name, @NotNull SpringFacet springFacet, @Nullable Servlet servlet, boolean isAnnotationConfig) {
        if (springFacet == null) {
            WebXmlSpringWebModelContributor.$$$reportNull$$$0(3);
        }
        SpringAutodetectedFileSet fileSet = WebXmlSpringWebModelContributor.createServletFileSet(id, name, springFacet, (CommonServlet)servlet, isAnnotationConfig);
        if (isAnnotationConfig) {
            String paramValue = param.getParamValue().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)paramValue)) {
                SpringAutodetectedFileSet springAutodetectedFileSet = fileSet;
                if (springAutodetectedFileSet == null) {
                    WebXmlSpringWebModelContributor.$$$reportNull$$$0(4);
                }
                return springAutodetectedFileSet;
            }
            Module module = springFacet.getModule();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            GlobalSearchScope moduleScope = SpringGlobalSearchScopes.runtime((Module)module, (boolean)false);
            StringTokenizer tokenizer = new StringTokenizer(paramValue, " ,;");
            while (tokenizer.hasMoreElements()) {
                String configText = tokenizer.nextElement().trim();
                if (StringUtil.isEmptyOrSpaces((String)configText)) continue;
                PsiPackage psiPackage = javaPsiFacade.findPackage(configText);
                if (psiPackage != null) {
                    GlobalSearchScope searchScope = moduleScope.intersectWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
                    List springConfigurations = SpringJamModel.getModel((Project)module.getProject()).getConfigurations(searchScope, module);
                    for (SpringConfiguration springConfiguration : springConfigurations) {
                        ServletFileSet.addInFileset((SpringFileSet)fileSet, springConfiguration.getContainingFile());
                    }
                    ((AnnotationServletFileSet)fileSet).addComponentScanPackage(psiPackage.getQualifiedName());
                    continue;
                }
                PsiClass psiClass = javaPsiFacade.findClass(configText, moduleScope);
                if (psiClass == null) continue;
                ServletFileSet.addInFileset((SpringFileSet)fileSet, psiClass.getContainingFile());
            }
        } else {
            XmlElement tag = param.getParamValue().getXmlElement();
            if (tag != null) {
                PsiReference[] references = (PsiReference[])Arrays.stream(tag.getReferences()).filter(FileReference.class::isInstance).toArray(PsiReference[]::new);
                Collection files = SpringResourcesUtil.getInstance().getResourceItems(references, SpringDomUtils.SPRING_XML_CONDITION);
                for (PsiFileSystemItem file : files) {
                    fileSet.addFile(file.getVirtualFile());
                }
            }
        }
        SpringAutodetectedFileSet springAutodetectedFileSet = fileSet;
        if (springAutodetectedFileSet == null) {
            WebXmlSpringWebModelContributor.$$$reportNull$$$0(5);
        }
        return springAutodetectedFileSet;
    }

    private static SpringAutodetectedFileSet createServletFileSet(@NonNls String id, String name, @NotNull SpringFacet springFacet, @Nullable CommonServlet servlet, boolean isAnnotated) {
        if (springFacet == null) {
            WebXmlSpringWebModelContributor.$$$reportNull$$$0(6);
        }
        return isAnnotated ? new AnnotationServletFileSet(id, name, servlet, springFacet) : new ServletFileSet(id, name, servlet, springFacet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springFacet";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/config/webXml/WebXmlSpringWebModelContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/config/webXml/WebXmlSpringWebModelContributor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesets";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesets";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFileSet";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createServletFileSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

