/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanBasedOnPsi;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.UCallExpressionSearchParams;
import com.intellij.spring.mvc.functional.SpringFunctionalRoutingUrlMapping;
import com.intellij.spring.mvc.functional.references.SpringMvcRouterPredicates;
import com.intellij.spring.mvc.functional.references.WebfluxReferenceContributorKt;
import com.intellij.spring.mvc.functional.utils.FunctionalMvcProcessingContext;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalPatterns;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalRequestPredicateMethods;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalSearchers;
import com.intellij.spring.mvc.functional.utils.SpringWebfluxKotlinDslUtil;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

public final class SpringMvcFunctionalUtil {
    private static final Collection<String> PATH_METHOD_NAME_AS_COLLECTION = List.of("path");
    private static final Collection<String> PATH_METHOD_COLLECTION = List.of("nest", "andNest", "path");

    public static Set<SpringBeanPointer<?>> getRouterFunctions(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(0);
        }
        return SpringMvcFunctionalUtil.getRouterFunctions(module, SpringManager.getInstance((Project)module.getProject()).getAllModels(module));
    }

    private static Set<SpringBeanPointer<?>> getRouterFunctions(@NotNull Module module, @NotNull Collection<SpringModel> models) {
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(1);
        }
        if (models == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(2);
        }
        return SpringMvcFunctionalUtil.getRouterFunctionBeans(module, models, "org.springframework.web.servlet.function.RouterFunction", "org.springframework.web.reactive.function.server.RouterFunction");
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> getRouterFunctionBeans(@NotNull Module module, @NotNull Collection<SpringModel> models, String ... routerFunctionClasses) {
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(3);
        }
        if (models == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(4);
        }
        HashSet pointers = new HashSet();
        for (String routerFunctionClass : routerFunctionClasses) {
            PsiClass routerFunction = SpringCommonUtils.findLibraryClass((Module)module, (String)routerFunctionClass);
            if (routerFunction == null) continue;
            for (SpringModel model : models) {
                pointers.addAll(SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)routerFunction).withInheritors()));
            }
        }
        HashSet hashSet = pointers;
        if (hashSet == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public static boolean processRouterFunctionUrlMappingsWithoutSpringModel(@NotNull Processor<UrlMappingElement> requestMappings, @NotNull Module module) {
        if (requestMappings == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(6);
        }
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(7);
        }
        if (!SpringMvcFunctionalUtil.processRouterFunctionalUrlMappingsClass(requestMappings, module, "org.springframework.web.servlet.function.RequestPredicates", false)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processRouterFunctionalUrlMappingsClass(requestMappings, module, "org.springframework.web.reactive.function.server.RequestPredicates", true);
    }

    private static boolean processRouterFunctionalUrlMappingsClass(Processor<UrlMappingElement> requestMappings, @NotNull Module module, @NotNull String requestPredicates, boolean isReactive) {
        PsiClass requestPredicatesClass;
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(8);
        }
        if (requestPredicates == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(9);
        }
        if ((requestPredicatesClass = SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, requestPredicates)) == null) {
            return true;
        }
        FunctionalMvcProcessingContext processingContext = FunctionalMvcProcessingContext.create(module).reactive(isReactive);
        if (!SpringMvcFunctionalUtil.processConfigurationClassRouterPredicates(requestMappings, processingContext)) {
            return false;
        }
        return SpringWebfluxKotlinDslUtil.processKotlinDsl(requestMappings, processingContext);
    }

    public static boolean processRouterFunctionUrlMappings(@NotNull Processor<UrlMappingElement> requestMappings, @NotNull Module module, @NotNull Collection<SpringModel> models) {
        if (requestMappings == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(10);
        }
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(11);
        }
        if (models == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(12);
        }
        if (!SpringMvcFunctionalUtil.processRouterFunctionUrlMappingsBeans(requestMappings, module, models, "org.springframework.web.reactive.function.server.RequestPredicates", true)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processRouterFunctionUrlMappingsBeans(requestMappings, module, models, "org.springframework.web.servlet.function.RequestPredicates", false);
    }

    private static boolean processRouterFunctionUrlMappingsBeans(@NotNull Processor<UrlMappingElement> requestMappings, @NotNull Module module, @NotNull Collection<SpringModel> models, @NotNull String requestPredicates, boolean isReactive) {
        PsiClass requestPredicatesClass;
        if (requestMappings == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(13);
        }
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(14);
        }
        if (models == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(15);
        }
        if (requestPredicates == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(16);
        }
        if ((requestPredicatesClass = SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, requestPredicates)) == null) {
            return true;
        }
        Set<SpringBeanPointer<?>> routerFunctions = SpringMvcFunctionalUtil.getRouterFunctionBeans(module, models, isReactive ? "org.springframework.web.reactive.function.server.RouterFunction" : "org.springframework.web.servlet.function.RouterFunction");
        for (SpringBeanPointer<?> routerFunction : routerFunctions) {
            if (SpringMvcFunctionalUtil.processRouterFunctionUrlMappings(routerFunction.getSpringBean(), isReactive, module, requestMappings)) continue;
            return false;
        }
        return true;
    }

    public static boolean processRouterFunctionUrlMappings(@NotNull CommonSpringBean bean, boolean isReactive, @NotNull Module module, @NotNull Processor<UrlMappingElement> requestMappings) {
        PsiElement definitionScope;
        if (bean == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(17);
        }
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(18);
        }
        if (requestMappings == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(19);
        }
        if ((definitionScope = SpringMvcFunctionalUtil.getIdentifyingElement(bean)) == null) {
            return true;
        }
        FunctionalMvcProcessingContext processingContext = FunctionalMvcProcessingContext.create(module).reactive(isReactive).withControllerDefinitionScope(definitionScope).withLocalSearchScope(new LocalSearchScope(definitionScope));
        if (!SpringMvcFunctionalUtil.processConfigurationClass(requestMappings, definitionScope, processingContext)) {
            return false;
        }
        return SpringWebfluxKotlinDslUtil.processKotlinDsl(requestMappings, processingContext);
    }

    public static PsiElement getIdentifyingElement(CommonSpringBean bean) {
        if (bean instanceof SpringBeanBasedOnPsi) {
            Object e;
            UCallExpression uCallExpression;
            SpringBeanBasedOnPsi springBeanBasedOnPsi = (SpringBeanBasedOnPsi)bean;
            PsiElement psiElement = springBeanBasedOnPsi.getPsiElement();
            UElement uElement = UastContextKt.toUElement((PsiElement)psiElement);
            if (uElement instanceof UCallExpression && "registerBean".equals((uCallExpression = (UCallExpression)uElement).getMethodName()) && uCallExpression.getValueArgumentCount() >= 1 && (e = uCallExpression.getValueArguments().getFirst()) instanceof UCallableReferenceExpression) {
                UCallableReferenceExpression uCallableReferenceExpression = (UCallableReferenceExpression)e;
                return uCallableReferenceExpression.resolve();
            }
            return psiElement;
        }
        return bean.getIdentifyingPsiElement();
    }

    private static boolean hasRouterInvocationsInScope(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(20);
        }
        return SpringMvcFunctionalUtil.hasMethodCalls(context, "org.springframework.web.servlet.function.RouterFunctions", "nest") || SpringMvcFunctionalUtil.hasMethodCalls(context, "org.springframework.web.reactive.function.server.RouterFunctions", "nest") || SpringMvcFunctionalUtil.hasMethodCalls(context, "org.springdoc.webflux.core.fn.SpringdocRouteBuilder", "nest") || SpringMvcFunctionalUtil.hasMethodCalls(context, "org.springframework.web.reactive.function.server.RouterFunctions", "route") || SpringMvcFunctionalUtil.hasMethodCalls(context, "org.springframework.web.servlet.function.RouterFunctions", "route") || SpringMvcFunctionalUtil.hasMethodCalls(context, "org.springdoc.webflux.core.fn.SpringdocRouteBuilder", "route");
    }

    private static boolean hasMethodCalls(@NotNull FunctionalMvcProcessingContext context, @NotNull String classname, @NotNull String methodName) {
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(21);
        }
        if (classname == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(22);
        }
        if (methodName == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(23);
        }
        return !SpringMvcFunctionalUtil.getMethodCalls(classname, methodName, context).isEmpty();
    }

    @NotNull
    public static Set<UCallExpression> getMethodCalls(@Nullable String className, @NotNull String methodName, @NotNull FunctionalMvcProcessingContext context) {
        if (methodName == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(24);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(25);
        }
        return SpringMvcFunctionalUtil.getMethodCalls(UCallExpressionSearchParams.create((Module)context.module, (String)className, (String)methodName), context);
    }

    @NotNull
    private static Set<UCallExpression> getMethodCalls(@NotNull UCallExpressionSearchParams params, @NotNull FunctionalMvcProcessingContext context) {
        LocalSearchScope localSearchScope;
        if (params == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(26);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(27);
        }
        Set set = (localSearchScope = context.localSearchScope) == null ? SpringFunctionalSearchersUtils.findMethodCallsInModuleSearchScope((UCallExpressionSearchParams)params) : SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)params, (LocalSearchScope)localSearchScope);
        if (set == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(28);
        }
        return set;
    }

    private static boolean processConfigurationClass(@NotNull Processor<UrlMappingElement> processor, @NotNull PsiElement definitionScope, @NotNull FunctionalMvcProcessingContext context) {
        Boolean preventingRecursion;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(29);
        }
        if (definitionScope == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(30);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(31);
        }
        return (preventingRecursion = (Boolean)RecursionManager.doPreventingRecursion((Object)definitionScope, (boolean)true, () -> {
            if (SpringMvcFunctionalUtil.hasRouterInvocationsInScope(context)) {
                return SpringMvcFunctionalUtil.processConfigurationClassRouterPredicates(processor, context);
            }
            for (PsiElement extendedElementScope : SpringMvcFunctionalSearchers.getExtendedDefinitionScope(definitionScope)) {
                if (SpringMvcFunctionalUtil.processConfigurationClass(processor, extendedElementScope, context.getCopyWithScope(new LocalSearchScope(extendedElementScope)))) continue;
                return false;
            }
            return true;
        })) == null || preventingRecursion != false;
    }

    private static boolean processConfigurationClassRouterPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(32);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(33);
        }
        if (!SpringMvcFunctionalUtil.processRouterPredicates(processor, context)) {
            return false;
        }
        if (!SpringMvcFunctionalUtil.processRouterFunctionsBuilderPredicates(processor, context)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processSpringdocBuilderRouterPredicates(processor, context);
    }

    private static boolean processRouterPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        PsiClass requestPredicatesClass;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(34);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(35);
        }
        if ((requestPredicatesClass = SpringMvcFunctionalSearchers.findRequestPredicatesClass(context.module, context.reactive)) == null) {
            return true;
        }
        return SpringMvcFunctionalUtil.processRouterPredicates(processor, context, requestPredicatesClass, SpringMvcFunctionalUtil.filterNestedExpressions(SpringMvcFunctionalSearchers.findRouterFunctionsNestExpressions(context)));
    }

    private static boolean processRouterFunctionsBuilderPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(36);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(37);
        }
        return SpringMvcFunctionalUtil.processRouterBuilderPredicates(processor, context, SpringMvcFunctionalSearchers.findRouterFunctionsBuilderClass(context.module, context.reactive));
    }

    private static boolean processRouterBuilderPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @Nullable PsiClass routerBuilderClass) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(38);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(39);
        }
        if (routerBuilderClass == null) {
            return true;
        }
        HashSet<UCallExpression> pathsContainerExpressions = new HashSet<UCallExpression>();
        pathsContainerExpressions.addAll(SpringMvcFunctionalUtil.filterNestedExpressions(SpringMvcFunctionalSearchers.findRouterFunctionsBuilderNestExpressions(context)));
        pathsContainerExpressions.addAll(SpringMvcFunctionalUtil.filterPathExpressions(SpringMvcFunctionalSearchers.findRouterFunctionsBuilderPathExpressions(context)));
        pathsContainerExpressions.addAll(SpringMvcFunctionalUtil.filterPathExpressions(SpringMvcFunctionalSearchers.findRouterFunctionsBuilderPathExpressions(context)));
        return SpringMvcFunctionalUtil.processRouterPredicates(processor, context, routerBuilderClass, pathsContainerExpressions);
    }

    private static boolean processSpringdocBuilderRouterPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        PsiClass routerBuilderClass;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(40);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(41);
        }
        if ((routerBuilderClass = SpringMvcFunctionalSearchers.findSpringdocRouterBuilderClass(context.module)) == null) {
            return true;
        }
        HashSet<UCallExpression> pathsContainerExpressions = new HashSet<UCallExpression>();
        pathsContainerExpressions.addAll(SpringMvcFunctionalUtil.filterNestedExpressions(SpringMvcFunctionalSearchers.findSpringdocRouterBuilderNestExpressions(context)));
        pathsContainerExpressions.addAll(SpringMvcFunctionalUtil.filterPathExpressions(SpringMvcFunctionalSearchers.findSpringdocRouterBuilderPathExpressions(context)));
        return SpringMvcFunctionalUtil.processRouterPredicates(processor, context, routerBuilderClass, pathsContainerExpressions);
    }

    public static boolean processRouterPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @Nullable PsiClass requestPredicatesClass, @NotNull Set<UCallExpression> pathsContainerExpressions) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(42);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(43);
        }
        if (pathsContainerExpressions == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(44);
        }
        if (requestPredicatesClass == null) {
            return true;
        }
        if (!SpringMvcFunctionalUtil.processPathsContainerExpressions(processor, context, pathsContainerExpressions, requestPredicatesClass)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processRequestPredicatesMethods(processor, pathsContainerExpressions.isEmpty() ? context : FunctionalMvcProcessingContext.createFrom(context).withExcludedScopes(SpringMvcFunctionalUtil.getExcludedScopesForPathsContainerExpressions(pathsContainerExpressions)), requestPredicatesClass);
    }

    private static LocalSearchScope[] getExcludedScopesForPathsContainerExpressions(@NotNull Set<UCallExpression> nestDefinitions) {
        if (nestDefinitions == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(45);
        }
        return (LocalSearchScope[])nestDefinitions.stream().flatMap(ex -> ex.getValueArguments().stream()).map(expr -> expr.getSourcePsi()).filter(Objects::nonNull).map(psi -> new LocalSearchScope(psi)).toArray(LocalSearchScope[]::new);
    }

    private static boolean processRequestPredicatesMethods(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(46);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(47);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(48);
        }
        for (SpringMvcFunctionalRequestPredicateMethods method : SpringMvcFunctionalRequestPredicateMethods.values()) {
            if (SpringMvcFunctionalUtil.processPredicateMethodsForClass(processor, context, method, requestPredicatesClass, new String[0])) continue;
            return false;
        }
        return SpringMvcFunctionalUtil.processRouterAddMethod(processor, context, requestPredicatesClass);
    }

    private static boolean processRouterAddMethod(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(49);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(50);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(51);
        }
        Set<UCallExpression> calls = SpringMvcFunctionalUtil.getMethodCalls(requestPredicatesClass.getQualifiedName(), "add", context);
        for (UExpression uExpression : SpringCommonUtils.findParameterExpressionInMethodCalls(calls, (int)0)) {
            PsiElement resolveAddExpression = SpringMvcFunctionalUtil.resolveAddExpression(uExpression);
            if (resolveAddExpression == null || SpringMvcFunctionalUtil.processConfigurationClassRouterPredicates(processor, context.getCopyWithScope(new LocalSearchScope(resolveAddExpression)))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiElement resolveAddExpression(UExpression uExpression) {
        if (uExpression instanceof UReferenceExpression) {
            UReferenceExpression referenceExpression = (UReferenceExpression)uExpression;
            UElement uElement = UResolvableKt.resolveToUElement((UResolvable)referenceExpression);
            if (uElement instanceof UMethod) {
                return uElement.getSourcePsi();
            }
        } else if (uExpression instanceof UCallExpression) {
            return ((UCallExpression)uExpression).resolve();
        }
        return null;
    }

    private static Set<UCallExpression> filterNestedExpressions(@NotNull Set<UCallExpression> nestDefinitions) {
        if (nestDefinitions == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(52);
        }
        return nestDefinitions.stream().filter(expression -> !SpringMvcFunctionalUtil.isNestedExpression(expression)).collect(Collectors.toSet());
    }

    private static Set<UCallExpression> filterPathExpressions(@NotNull Set<UCallExpression> nestDefinitions) {
        if (nestDefinitions == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(53);
        }
        return nestDefinitions.stream().filter(expression -> SpringMvcFunctionalPatterns.ROUTER_AGGREGATED_PATH_METHOD_PATTERN.accepts(expression) && !SpringMvcFunctionalUtil.isNestedExpression(expression)).collect(Collectors.toSet());
    }

    private static boolean processPathsContainerExpressions(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull Set<UCallExpression> nestDefinitions, @NotNull PsiClass requestPredicatesClass) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(54);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(55);
        }
        if (nestDefinitions == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(56);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(57);
        }
        for (UCallExpression nestCallExpression : nestDefinitions) {
            if (!SpringMvcFunctionalUtil.processPathsContainerMethodCallExpressions(processor, context, requestPredicatesClass, nestCallExpression, new String[0])) {
                return false;
            }
            if (SpringMvcFunctionalUtil.processNestMethodLambdaExpression(processor, context, requestPredicatesClass, nestCallExpression)) continue;
            return false;
        }
        return true;
    }

    private static boolean processNestMethodLambdaExpression(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, @NotNull UCallExpression nestCallExpression) {
        UExpression receiver;
        List arguments;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(58);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(59);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(60);
        }
        if (nestCallExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(61);
        }
        if ((arguments = nestCallExpression.getValueArguments()).size() == 1 && (receiver = nestCallExpression.getReceiver()) != null) {
            PsiElement sourcePsi;
            String rootPath = SpringMvcFunctionalUtil.getParentPathForNestExpression(receiver);
            UExpression expression = (UExpression)arguments.get(0);
            if (expression instanceof ULambdaExpression && (sourcePsi = expression.getSourcePsi()) != null) {
                for (SpringMvcFunctionalRequestPredicateMethods method : SpringMvcFunctionalRequestPredicateMethods.values()) {
                    String[] stringArray;
                    FunctionalMvcProcessingContext functionalMvcProcessingContext = context.getCopyWithScope(new LocalSearchScope(sourcePsi));
                    if (rootPath == null) {
                        stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = rootPath;
                    }
                    if (SpringMvcFunctionalUtil.processPredicateMethodsForClass(processor, functionalMvcProcessingContext, method, requestPredicatesClass, stringArray)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static String getParentPathForNestExpression(UExpression receiver) {
        List valueArguments;
        UCallExpression uCallExpression;
        String rootPath = SpringFunctionalSearchersUtils.getUExpressionText((UExpression)receiver);
        if (rootPath == null && (uCallExpression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)receiver.getSourcePsi(), UCallExpression.class)) != null && uCallExpression.isMethodNameOneOf(PATH_METHOD_NAME_AS_COLLECTION) && (valueArguments = uCallExpression.getValueArguments()).size() == 1) {
            return SpringFunctionalSearchersUtils.getUExpressionText((UExpression)((UExpression)valueArguments.get(0)));
        }
        return rootPath;
    }

    private static boolean processPathsContainerMethodCallExpressions(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, @NotNull UCallExpression pathsContainerExpression, String ... parentPaths) {
        String rootPath;
        List arguments;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(62);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(63);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(64);
        }
        if (pathsContainerExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(65);
        }
        if ((arguments = pathsContainerExpression.getValueArguments()).size() > 1 && (rootPath = SpringMvcFunctionalUtil.findPathsContainerRootPath(pathsContainerExpression, context)) != null) {
            PsiElement sourcePsi;
            UExpression predicateExpression;
            String[] allParentPaths = rootPath.isEmpty() ? parentPaths : (String[])ArrayUtil.append((Object[])parentPaths, (Object)rootPath);
            if (!SpringMvcFunctionalUtil.processCallExpressionsChain(processor, context, requestPredicatesClass, allParentPaths, predicateExpression = (UExpression)arguments.get(1))) {
                return false;
            }
            if (!SpringMvcFunctionalUtil.processExpressionResolvedToMembers(processor, context, requestPredicatesClass, predicateExpression, allParentPaths)) {
                return false;
            }
            if (predicateExpression instanceof ULambdaExpression && (sourcePsi = predicateExpression.getSourcePsi()) != null) {
                for (SpringMvcFunctionalRequestPredicateMethods method : SpringMvcFunctionalRequestPredicateMethods.values()) {
                    if (SpringMvcFunctionalUtil.processPredicateMethodsForClass(processor, context.getCopyWithScope(new LocalSearchScope(sourcePsi)), method, requestPredicatesClass, allParentPaths)) continue;
                    return false;
                }
                UExpression body = ((ULambdaExpression)predicateExpression).getBody();
                if (body instanceof UBlockExpression) {
                    for (UExpression expression : ((UBlockExpression)body).getExpressions()) {
                        if (!(expression instanceof UReturnExpression)) continue;
                        UReturnExpression returnExpression = (UReturnExpression)expression;
                        UExpression uExpression = returnExpression.getReturnExpression();
                        if (!SpringMvcFunctionalUtil.processCallExpressionsChain(processor, context, requestPredicatesClass, allParentPaths, uExpression)) {
                            return false;
                        }
                        if (SpringMvcFunctionalUtil.processExpressionResolvedToMembers(processor, context, requestPredicatesClass, uExpression, allParentPaths)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Nullable
    private static String findPathsContainerRootPath(@NotNull UCallExpression pathsContainerExpression, @NotNull FunctionalMvcProcessingContext context) {
        List arguments;
        if (pathsContainerExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(66);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(67);
        }
        if ((arguments = pathsContainerExpression.getValueArguments()).size() > 1 && pathsContainerExpression.isMethodNameOneOf(PATH_METHOD_COLLECTION)) {
            UExpression pathExpression;
            String methodName = pathsContainerExpression.getMethodName();
            if (("nest".equals(methodName) || "andNest".equals(methodName)) && (pathExpression = SpringMvcFunctionalSearchers.findPathExpression((UExpression)arguments.get(0), context.module, context.reactive)) != null) {
                return SpringFunctionalSearchersUtils.getUExpressionText((UExpression)pathExpression);
            }
            if ("path".equals(methodName)) {
                return SpringFunctionalSearchersUtils.getUExpressionText((UExpression)((UExpression)arguments.get(0)));
            }
        }
        return null;
    }

    private static boolean processExpressionResolvedToMembers(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, @Nullable UExpression predicateExpression, String ... allParentPaths) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(68);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(69);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(70);
        }
        return !(predicateExpression instanceof UReferenceExpression ? !SpringMvcFunctionalUtil.processResolvedMembers(processor, context, requestPredicatesClass, allParentPaths, ((UReferenceExpression)predicateExpression).resolve()) : predicateExpression instanceof UCallExpression && !SpringMvcFunctionalUtil.processResolvedMembers(processor, context, requestPredicatesClass, allParentPaths, (PsiElement)((UCallExpression)predicateExpression).resolve()));
    }

    private static boolean processResolvedMembers(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, String[] allParentPaths, @Nullable PsiElement resolve2) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(71);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(72);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(73);
        }
        if (resolve2 == null) {
            return true;
        }
        FunctionalMvcProcessingContext withScope = context.getCopyWithScope(new LocalSearchScope(resolve2));
        if (resolve2 instanceof PsiMember && !SpringMvcFunctionalPatterns.ROUTER_CLASSES_PATTERN.accepts((Object)((PsiMember)resolve2).getContainingClass())) {
            if (!SpringMvcFunctionalUtil.processPredicateMethods(processor, requestPredicatesClass, allParentPaths, withScope)) {
                return false;
            }
            return SpringMvcFunctionalUtil.processSpringdocRouterBuilderPredicates(processor, context, allParentPaths, withScope);
        }
        if (resolve2 instanceof PsiVariable) {
            PsiClassType routerFunctionClass = PsiType.getTypeByName((String)(context.reactive ? "org.springframework.web.reactive.function.server.RouterFunction" : "org.springframework.web.servlet.function.RouterFunction"), (Project)context.module.getProject(), (GlobalSearchScope)SpringGlobalSearchScopes.runtime((Module)context.module));
            if (((PsiVariable)resolve2).getType().isAssignableFrom((PsiType)routerFunctionClass) && !SpringMvcFunctionalUtil.processPredicateMethods(processor, requestPredicatesClass, allParentPaths, withScope)) {
                return false;
            }
            return SpringMvcFunctionalUtil.processSpringdocRouterBuilderPredicates(processor, context, allParentPaths, withScope);
        }
        return true;
    }

    private static boolean processSpringdocRouterBuilderPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, String[] allParentPaths, FunctionalMvcProcessingContext withScope) {
        PsiClass springdocRouterBuilderClass;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(74);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(75);
        }
        return (springdocRouterBuilderClass = SpringCommonUtils.findLibraryClass((Module)context.module, (String)"org.springdoc.webflux.core.fn.SpringdocRouteBuilder")) == null || SpringMvcFunctionalUtil.processPredicateMethods(processor, springdocRouterBuilderClass, allParentPaths, withScope);
    }

    private static boolean processPsiVariableInitializerExpression(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, String[] allParentPaths, PsiVariable resolve2) {
        UExpression uExpression;
        UExpression fieldInitializer;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(76);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(77);
        }
        return !((fieldInitializer = (UExpression)UastContextKt.toUElement((PsiElement)resolve2.getInitializer(), UExpression.class)) instanceof ULambdaExpression) || SpringMvcFunctionalUtil.processPredicateMethodsInChain(processor, context, allParentPaths, uExpression = ((ULambdaExpression)fieldInitializer).getBody());
    }

    private static boolean processCallExpressionsChain(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, String[] allParentPaths, UExpression predicateExpression) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(78);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(79);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(80);
        }
        for (UCallExpression uCallExpression : SpringMvcFunctionalUtil.collectPathsContainerCallExpressions(predicateExpression)) {
            LocalSearchScope searchScope = SpringMvcFunctionalUtil.getPathsContainerFunctionSearchScope((UExpression)uCallExpression);
            if (searchScope == null || SpringMvcFunctionalUtil.processPathsContainerMethodCallExpressions(processor, context.getCopyWithScope(searchScope), requestPredicatesClass, uCallExpression, allParentPaths)) continue;
            return false;
        }
        for (UCallExpression routeCallExpression : SpringMvcFunctionalUtil.collectRouteCallExpressions(predicateExpression)) {
            LocalSearchScope routerFunctionSearchScope = SpringMvcFunctionalUtil.getRouterFunctionSearchScope((UExpression)routeCallExpression);
            if (routerFunctionSearchScope == null || SpringMvcFunctionalUtil.processPredicateMethods(processor, requestPredicatesClass, allParentPaths, context.getCopyWithScope(routerFunctionSearchScope))) continue;
            return false;
        }
        if (!SpringMvcFunctionalUtil.processPredicateMethodsInChain(processor, context, allParentPaths, predicateExpression)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processAndExpressionPredicateInChain(processor, context, allParentPaths, predicateExpression);
    }

    private static boolean processAndExpressionPredicateInChain(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, String[] allParentPaths, UExpression predicateExpression) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(81);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(82);
        }
        for (UCallExpression andPredicateCallExpression : SpringMvcFunctionalUtil.collectAndPredicateCallExpressions(predicateExpression)) {
            UExpression expressionArgumentForParameter = andPredicateCallExpression.getArgumentForParameter(0);
            PsiElement andCallExpression = andPredicateCallExpression.getSourcePsi();
            if (andCallExpression == null || SpringMvcFunctionalUtil.processPredicateMethodsInChain(processor, context.getCopyWithScope(new LocalSearchScope(andCallExpression)), allParentPaths, expressionArgumentForParameter)) continue;
            return false;
        }
        return true;
    }

    private static boolean processPredicateMethodsInChain(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, String[] allParentPaths, UExpression predicateExpression) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(83);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(84);
        }
        for (SpringMvcFunctionalRequestPredicateMethods method : SpringMvcFunctionalRequestPredicateMethods.values()) {
            UCallExpressionPattern pattern = UastPatterns.callExpression().withResolvedMethod((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(method.getMethodName())).definedInClass((ElementPattern)SpringMvcFunctionalPatterns.ROUTER_FUNCTIONS_CLASS_PATTERN), false);
            for (UCallExpression uCallExpression : SpringFunctionalSearchersUtils.collectCallExpressionsInChain((UExpression)predicateExpression, (UCallExpressionPattern[])new UCallExpressionPattern[]{pattern})) {
                String valueIfKnown;
                UExpression forParameter = uCallExpression.getArgumentForParameter(0);
                if (forParameter == null || SpringMvcFunctionalUtil.isInExcludedScopes(forParameter, context.excludeSearchScopes) || (valueIfKnown = SpringCommonUtils.evaluateStringExpression((UExpression)forParameter)) == null || SpringMvcFunctionalUtil.processRequestPredicate(processor, context.controllerDefinitionScope, method, valueIfKnown, forParameter.getSourcePsi(), allParentPaths)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static Collection<UCallExpression> collectPathsContainerCallExpressions(UExpression uExpression) {
        UExpression body;
        Collection uCallExpressions = SpringFunctionalSearchersUtils.collectCallExpressionsInChain((UExpression)uExpression, (UCallExpressionPattern[])new UCallExpressionPattern[]{SpringMvcFunctionalPatterns.NEST_METHOD_PATTERN, SpringMvcFunctionalPatterns.NEST_BUILDER_METHOD_PATTERN, SpringMvcFunctionalPatterns.AND_NEST_METHOD_PATTERN, SpringMvcFunctionalPatterns.ROUTER_AGGREGATED_PATH_METHOD_PATTERN});
        if (uExpression instanceof ULambdaExpression && (body = ((ULambdaExpression)uExpression).getBody()) instanceof UBlockExpression) {
            for (UExpression expression : ((UBlockExpression)body).getExpressions()) {
                if (!(expression instanceof UReturnExpression)) continue;
                UExpression returnExpression = ((UReturnExpression)expression).getReturnExpression();
                uCallExpressions.addAll(SpringFunctionalSearchersUtils.collectCallExpressionsInChain((UExpression)returnExpression, (UCallExpressionPattern[])new UCallExpressionPattern[]{SpringMvcFunctionalPatterns.NEST_METHOD_PATTERN, SpringMvcFunctionalPatterns.NEST_BUILDER_METHOD_PATTERN, SpringMvcFunctionalPatterns.AND_NEST_METHOD_PATTERN, SpringMvcFunctionalPatterns.ROUTER_AGGREGATED_PATH_METHOD_PATTERN}));
            }
        }
        Collection collection = uCallExpressions;
        if (collection == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(85);
        }
        return collection;
    }

    @NotNull
    private static Collection<UCallExpression> collectAndPredicateCallExpressions(UExpression uExpression) {
        Collection collection = SpringFunctionalSearchersUtils.collectCallExpressionsInChain((UExpression)uExpression, (UCallExpressionPattern[])new UCallExpressionPattern[]{SpringMvcFunctionalPatterns.AND_METHOD_PATTERN});
        if (collection == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(86);
        }
        return collection;
    }

    @NotNull
    private static Collection<UCallExpression> collectRouteCallExpressions(UExpression chain) {
        Collection collection = SpringFunctionalSearchersUtils.collectCallExpressionsInChain((UExpression)chain, (UCallExpressionPattern[])new UCallExpressionPattern[]{SpringMvcFunctionalPatterns.ROUTE_METHOD_PATTERN, SpringMvcFunctionalPatterns.AND_ROUTE_METHOD_PATTERN});
        if (collection == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(87);
        }
        return collection;
    }

    private static boolean processPredicateMethods(@NotNull Processor<UrlMappingElement> processor, @NotNull PsiClass requestPredicatesClass, String[] allParentPaths, FunctionalMvcProcessingContext processingContext) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(88);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(89);
        }
        for (SpringMvcFunctionalRequestPredicateMethods method : SpringMvcFunctionalRequestPredicateMethods.values()) {
            if (SpringMvcFunctionalUtil.processPredicateMethodsForClass(processor, processingContext, method, requestPredicatesClass, allParentPaths)) continue;
            return false;
        }
        return SpringMvcFunctionalUtil.processRequestPredicateMethods(processor, processingContext, allParentPaths);
    }

    private static boolean isNestExpression(UElement expression) {
        return SpringMvcFunctionalPatterns.NEST_METHOD_PATTERN.accepts((Object)expression) || SpringMvcFunctionalPatterns.AND_NEST_METHOD_PATTERN.accepts((Object)expression) || SpringMvcFunctionalPatterns.NEST_BUILDER_METHOD_PATTERN.accepts((Object)expression);
    }

    private static boolean isPathExpression(UElement expression) {
        return SpringMvcFunctionalPatterns.ROUTER_AGGREGATED_PATH_METHOD_PATTERN.accepts((Object)expression);
    }

    private static boolean isNestedExpression(UCallExpression expression) {
        UElement parent = UastUtils.getParentOfType((UElement)expression, UCallExpression.class);
        if (parent == null) {
            return false;
        }
        if (SpringMvcFunctionalUtil.isNestExpression(parent) || SpringMvcFunctionalUtil.isPathExpression(parent)) {
            return true;
        }
        if (parent instanceof UQualifiedReferenceExpression) {
            UCallExpression firstCallExpressionInChain = SpringFunctionalSearchersUtils.findFirstCallExpressionInChain((UExpression)((UQualifiedReferenceExpression)parent));
            return SpringMvcFunctionalUtil.isNestExpression((UElement)firstCallExpressionInChain) || SpringMvcFunctionalUtil.isPathExpression((UElement)firstCallExpressionInChain);
        }
        return false;
    }

    private static boolean processPredicateMethodsForClass(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull SpringMvcFunctionalRequestPredicateMethods method, @Nullable PsiClass requestPredicatesClass, String ... parentPaths) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(90);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(91);
        }
        if (method == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(92);
        }
        if (requestPredicatesClass == null) {
            return true;
        }
        Set<UCallExpression> calls = SpringMvcFunctionalUtil.getMethodCalls(requestPredicatesClass.getQualifiedName(), method.getMethodName(), context);
        for (UExpression uExpression : SpringCommonUtils.findParameterExpressionInMethodCalls(calls, (int)0)) {
            String valueIfKnown;
            if (SpringMvcFunctionalUtil.isInExcludedScopes(uExpression, context.excludeSearchScopes) || !((valueIfKnown = SpringCommonUtils.evaluateStringExpression((UExpression)uExpression)) != null ? !SpringMvcFunctionalUtil.processRequestPredicate(processor, context.controllerDefinitionScope, method, valueIfKnown, uExpression.getSourcePsi(), parentPaths) : parentPaths.length > 0 && WebfluxReferenceContributorKt.webfluxMethodCallPattern.accepts((Object)uExpression) && !SpringMvcFunctionalUtil.processRequestPredicate(processor, context.controllerDefinitionScope, method, null, uExpression.getSourcePsi(), parentPaths))) continue;
            return false;
        }
        return true;
    }

    private static boolean isInExcludedScopes(@NotNull UExpression uExpression, LocalSearchScope[] excludeScopes) {
        if (uExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(93);
        }
        for (LocalSearchScope scope : excludeScopes) {
            for (PsiElement element : scope.getScope()) {
                PsiElement sourcePsi = uExpression.getSourcePsi();
                if (sourcePsi == null || !element.getTextRange().contains(sourcePsi.getTextRange())) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] getParentPaths(String[] nestedPaths, @Nullable String directParentPath) {
        String[] stringArray;
        if (StringUtil.isEmptyOrSpaces((String)directParentPath)) {
            return nestedPaths;
        }
        if (nestedPaths.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = directParentPath;
        } else {
            stringArray = (String[])ArrayUtil.append((Object[])nestedPaths, (Object)directParentPath);
        }
        return stringArray;
    }

    private static String getAggregatedRouterPath(@Nullable UExpression uCallExpression) {
        List valueArguments;
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression uPathExpression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)uCallExpression.getSourcePsi(), UCallExpression.class);
        if (uPathExpression != null && "path".equals(uPathExpression.getMethodName()) && (valueArguments = uPathExpression.getValueArguments()).size() == 2) {
            return SpringFunctionalSearchersUtils.getUExpressionText((UExpression)((UExpression)valueArguments.get(0)));
        }
        return null;
    }

    private static boolean processRequestPredicateMethods(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, String ... rootPath) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(94);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(95);
        }
        Set<UCallExpression> calls = context.reactive ? SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.reactive.function.server.RequestPredicates", "method", context) : SpringMvcFunctionalUtil.getMethodCalls("org.springframework.web.servlet.function.RequestPredicates", "method", context);
        for (UCallExpression uCallExpression : calls) {
            PsiElement sourcePsi;
            UExpression enumExpression = uCallExpression.getArgumentForParameter(0);
            if (enumExpression == null || (sourcePsi = enumExpression.getSourcePsi()) == null || SpringMvcFunctionalUtil.processRequestPredicate(processor, context.controllerDefinitionScope, SpringMvcFunctionalUtil.getWebfluxPredicateMethodType(enumExpression), null, sourcePsi, rootPath)) continue;
            return false;
        }
        return true;
    }

    private static boolean processRequestPredicate(@NotNull Processor<UrlMappingElement> processor, @Nullable PsiElement controllerDefinition, @NotNull SpringMvcFunctionalRequestPredicateMethods method, @Nullable String url, @Nullable PsiElement sourcePsi, String ... rootPath) {
        UrlMappingElement mapping;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(96);
        }
        if (method == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(97);
        }
        return sourcePsi == null || SpringMvcFunctionalUtil.isAlreadyProcessed(processor, sourcePsi) || (mapping = SpringMvcFunctionalUtil.createUrlMapping(url, sourcePsi, rootPath, controllerDefinition, method.getType())) == null || processor.process((Object)mapping);
    }

    private static boolean isAlreadyProcessed(@NotNull Processor<UrlMappingElement> processor, @NotNull PsiElement sourcePsi) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(98);
        }
        if (sourcePsi == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(99);
        }
        if (processor instanceof CommonProcessors.CollectProcessor) {
            for (UrlMappingElement result : ((CommonProcessors.CollectProcessor)processor).getResults()) {
                if (!sourcePsi.equals((Object)result.getNavigationTarget())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static UrlMappingElement createUrlMapping(@Nullable String path, @NotNull PsiElement definition, String[] rootPaths, @Nullable PsiElement controllerDefinition, RequestMethod ... requestMethods) {
        String url;
        if (definition == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(100);
        }
        if ((url = SpringMvcFunctionalUtil.concatenatePaths(path, rootPaths)) == null) {
            return null;
        }
        UExpression handlerDefinition = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)definition, (Class[])new Class[]{UExpression.class});
        if (handlerDefinition == null) {
            return null;
        }
        return new SpringFunctionalRoutingUrlMapping(url, definition, controllerDefinition, requestMethods);
    }

    @Nullable
    private static String concatenatePaths(@Nullable String path, String ... rootPaths) {
        if (path == null && rootPaths == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String rootPath : rootPaths) {
            if (!rootPath.startsWith("/") && !sb.toString().endsWith("/")) {
                sb.append("/");
            }
            sb.append(rootPath);
        }
        if (StringUtil.isNotEmpty((String)path)) {
            if (sb.toString().endsWith("/")) {
                sb.append(StringsKt.removePrefix((String)path, (CharSequence)"/"));
            } else {
                if (!path.startsWith("/")) {
                    sb.append("/");
                }
                sb.append(path);
            }
        }
        return sb.toString();
    }

    @Nullable
    public static String getParentUrlPath(@NotNull PsiElement host) {
        List arguments;
        Module module;
        if (host == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(101);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host)) == null) {
            return null;
        }
        UMethod definedInMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)host, UMethod.class);
        if (definedInMethod == null) {
            return null;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)definedInMethod.getPsi());
        Iterable nestMethodCalls = ContainerUtil.concat((Iterable)SpringCommonUtils.findMethodCallsByPattern((Project)module.getProject(), (String)"nest", (SearchScope)localSearchScope, (UCallExpressionPattern[])new UCallExpressionPattern[]{SpringMvcFunctionalPatterns.NEST_METHOD_PATTERN, SpringMvcFunctionalPatterns.NEST_METHOD_IN_BUILDER_PATTERN}), (Iterable)SpringCommonUtils.findMethodCallsByPattern((Project)module.getProject(), (String)"andNest", (SearchScope)localSearchScope, (UCallExpressionPattern[])new UCallExpressionPattern[]{SpringMvcFunctionalPatterns.AND_NEST_METHOD_PATTERN}));
        for (UCallExpression nestCallExpression : nestMethodCalls) {
            arguments = nestCallExpression.getValueArguments();
            if (arguments.size() != 2) continue;
            UExpression reactivePathExpression = SpringMvcFunctionalSearchers.findPathExpression((UExpression)arguments.get(0), module, true);
            if (reactivePathExpression != null) {
                return SpringFunctionalSearchersUtils.getUExpressionText((UExpression)reactivePathExpression);
            }
            UExpression pathExpression = SpringMvcFunctionalSearchers.findPathExpression((UExpression)arguments.get(0), module, false);
            if (pathExpression == null) continue;
            return SpringFunctionalSearchersUtils.getUExpressionText((UExpression)pathExpression);
        }
        for (UCallExpression dslNestCallExpression : SpringWebfluxKotlinDslUtil.getKotlinDslNestCallExpressions(FunctionalMvcProcessingContext.create(module).withLocalSearchScope(localSearchScope))) {
            UExpression receiver;
            arguments = dslNestCallExpression.getValueArguments();
            if (arguments.size() != 1 || (receiver = dslNestCallExpression.getReceiver()) == null) continue;
            return SpringMvcFunctionalUtil.getParentPathForNestExpression(receiver);
        }
        return null;
    }

    @NotNull
    public static SpringMvcFunctionalRequestPredicateMethods getWebfluxPredicateMethodType(@NotNull UExpression uExpression) {
        if (uExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(102);
        }
        SpringMvcFunctionalRequestPredicateMethods predicateMethod = null;
        if (uExpression instanceof UReferenceExpression) {
            UReferenceExpression uReference = (UReferenceExpression)uExpression;
            predicateMethod = SpringCommonUtils.evaluateStringExpression((UExpression)uExpression) != null ? SpringMvcFunctionalUtil.getWebfluxPredicateMethodTypeForPathStringArgument((UExpression)uReference) : SpringMvcFunctionalUtil.getWebfluxPredicateMethodTypeForEnum(uReference);
        } else if (uExpression instanceof UInjectionHost) {
            predicateMethod = SpringMvcFunctionalUtil.getWebfluxPredicateMethodTypeForPathStringArgument(uExpression);
        }
        if (predicateMethod != null) {
            SpringMvcFunctionalRequestPredicateMethods springMvcFunctionalRequestPredicateMethods = predicateMethod;
            if (springMvcFunctionalRequestPredicateMethods == null) {
                SpringMvcFunctionalUtil.$$$reportNull$$$0(103);
            }
            return springMvcFunctionalRequestPredicateMethods;
        }
        SpringMvcFunctionalRequestPredicateMethods springMvcFunctionalRequestPredicateMethods = SpringMvcFunctionalRequestPredicateMethods.GET;
        if (springMvcFunctionalRequestPredicateMethods == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(104);
        }
        return springMvcFunctionalRequestPredicateMethods;
    }

    @Nullable
    private static SpringMvcFunctionalRequestPredicateMethods getWebfluxPredicateMethodTypeForEnum(@NotNull UReferenceExpression enumExpression) {
        String resolvedName;
        if (enumExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(105);
        }
        if ((resolvedName = enumExpression.getResolvedName()) != null) {
            for (SpringMvcFunctionalRequestPredicateMethods predicateMethod : SpringMvcFunctionalRequestPredicateMethods.values()) {
                if (!resolvedName.equals(predicateMethod.getMethodName())) continue;
                return predicateMethod;
            }
        }
        return null;
    }

    @Nullable
    private static SpringMvcFunctionalRequestPredicateMethods getWebfluxPredicateMethodTypeForPathStringArgument(@NotNull UExpression pathArgumentExpression) {
        PsiElement methodParent;
        UCallExpression uCallExpression;
        PsiMethod resolvedMethod;
        UElement parentOfPathExpression;
        if (pathArgumentExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(106);
        }
        if ((parentOfPathExpression = pathArgumentExpression.getUastParent()) instanceof UCallExpression && (resolvedMethod = (uCallExpression = (UCallExpression)parentOfPathExpression).resolve()) != null && (methodParent = resolvedMethod.getParent()) instanceof PsiClass) {
            PsiClass parentClass = (PsiClass)methodParent;
            if (ContainerUtil.exists(SpringMvcRouterPredicates.INSTANCE.getPredicateClasses(), predicateClassName -> predicateClassName.equals(parentClass.getQualifiedName()))) {
                for (SpringMvcFunctionalRequestPredicateMethods predicateMethod : SpringMvcFunctionalRequestPredicateMethods.values()) {
                    if (!resolvedMethod.getName().equals(predicateMethod.getMethodName())) continue;
                    return predicateMethod;
                }
            }
        }
        return null;
    }

    @Nullable
    public static LocalSearchScope getRouterFunctionSearchScope(@NotNull UExpression expression) {
        UExpression parameter;
        if (expression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(107);
        }
        if (expression instanceof UCallExpression && (SpringMvcFunctionalPatterns.ROUTE_METHOD_PATTERN.accepts((Object)expression) || SpringMvcFunctionalPatterns.AND_ROUTE_METHOD_PATTERN.accepts((Object)expression)) && (parameter = ((UCallExpression)expression).getArgumentForParameter(0)) != null) {
            PsiElement sourcePsi = parameter.getSourcePsi();
            return sourcePsi == null ? null : new LocalSearchScope(sourcePsi);
        }
        return null;
    }

    @Nullable
    public static LocalSearchScope getPathsContainerFunctionSearchScope(@NotNull UExpression expression) {
        PsiElement[] arguments;
        if (expression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(108);
        }
        if (expression instanceof UCallExpression && (SpringMvcFunctionalPatterns.NEST_METHOD_PATTERN.accepts((Object)expression) || SpringMvcFunctionalPatterns.AND_NEST_METHOD_PATTERN.accepts((Object)expression) || SpringMvcFunctionalPatterns.NEST_BUILDER_METHOD_PATTERN.accepts((Object)expression) || SpringMvcFunctionalPatterns.ROUTER_AGGREGATED_PATH_METHOD_PATTERN.accepts((Object)expression)) && (arguments = (PsiElement[])((UCallExpression)expression).getValueArguments().stream().map(uExpr -> uExpr.getSourcePsi()).filter(Objects::nonNull).toArray(PsiElement[]::new)).length > 0) {
            return new LocalSearchScope(arguments);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 28, 85, 86, 87, 103, 104 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 5: 
            case 28: 
            case 85: 
            case 86: 
            case 87: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/functional/utils/SpringMvcFunctionalUtil";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMappings";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPredicates";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 47: 
            case 50: 
            case 55: 
            case 59: 
            case 63: 
            case 67: 
            case 69: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 82: 
            case 84: 
            case 91: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classname";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 46: 
            case 49: 
            case 54: 
            case 58: 
            case 62: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 83: 
            case 88: 
            case 90: 
            case 94: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionScope";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsContainerExpressions";
                break;
            }
            case 45: 
            case 52: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestDefinitions";
                break;
            }
            case 48: 
            case 51: 
            case 57: 
            case 60: 
            case 64: 
            case 70: 
            case 73: 
            case 80: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPredicatesClass";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestCallExpression";
                break;
            }
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsContainerExpression";
                break;
            }
            case 92: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 93: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uExpression";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePsi";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumExpression";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathArgumentExpression";
                break;
            }
            case 107: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/functional/utils/SpringMvcFunctionalUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRouterFunctionBeans";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodCalls";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPathsContainerCallExpressions";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAndPredicateCallExpressions";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRouteCallExpressions";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebfluxPredicateMethodType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRouterFunctions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRouterFunctionBeans";
                break;
            }
            case 5: 
            case 28: 
            case 85: 
            case 86: 
            case 87: 
            case 103: 
            case 104: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionUrlMappingsWithoutSpringModel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionalUrlMappingsClass";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionUrlMappings";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionUrlMappingsBeans";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasRouterInvocationsInScope";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasMethodCalls";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCalls";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurationClass";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurationClassRouterPredicates";
                break;
            }
            case 34: 
            case 35: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processRouterPredicates";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionsBuilderPredicates";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processRouterBuilderPredicates";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processSpringdocBuilderRouterPredicates";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedScopesForPathsContainerExpressions";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processRequestPredicatesMethods";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processRouterAddMethod";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "filterNestedExpressions";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "filterPathExpressions";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processPathsContainerExpressions";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processNestMethodLambdaExpression";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "processPathsContainerMethodCallExpressions";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findPathsContainerRootPath";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "processExpressionResolvedToMembers";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedMembers";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "processSpringdocRouterBuilderPredicates";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "processPsiVariableInitializerExpression";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpressionsChain";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "processAndExpressionPredicateInChain";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "processPredicateMethodsInChain";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "processPredicateMethods";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "processPredicateMethodsForClass";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isInExcludedScopes";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "processRequestPredicateMethods";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "processRequestPredicate";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyProcessed";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createUrlMapping";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getParentUrlPath";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getWebfluxPredicateMethodType";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getWebfluxPredicateMethodTypeForEnum";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getWebfluxPredicateMethodTypeForPathStringArgument";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getRouterFunctionSearchScope";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getPathsContainerFunctionSearchScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 28, 85, 86, 87, 103, 104 -> new IllegalStateException(string);
        };
    }
}

