/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.UastReferenceByUsageAdapterKt;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.views.SpringMVCViewReferenceProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;

public final class SpringMVCViewUastReferenceProvider
extends UastInjectionHostReferenceProvider {
    @NonNls
    static String REACTOR_MONO = "reactor.core.publisher.Mono";
    private static final UCallExpressionPattern MONO_RETURN_PATTERN = UastPatterns.callExpression().withResolvedMethod((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"thenReturn", "defaultIfEmpty"}))).definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName(REACTOR_MONO)), false);
    private static final UCallExpressionPattern LAMBDA_IN_MONO_MAP_PATTERN = UastPatterns.callExpression().withResolvedMethod((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("map")).definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName(REACTOR_MONO)), false);
    private static final PatternCondition<PsiMethod> MVC_REQUEST_HANDLER_PATTERN = new PatternCondition<PsiMethod>("mvcRequestHandler"){

        public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
            if (method == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!SpringControllerUtils.isRequestHandlerCandidate(method)) {
                return false;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.web.bind.annotation.ResponseBody", (int)0)) {
                return false;
            }
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            if (!SpringControllerUtils.isRequestHandler(method)) {
                return false;
            }
            if (!SpringControllerUtils.isJamRequestHandler(method)) {
                return true;
            }
            return !SpringControllerUtils.hasClassLevelResponseBody(psiClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/mvc/views/SpringMVCViewUastReferenceProvider$1", "accepts"));
        }
    };
    public static final UExpressionPattern<UExpression, UExpressionPattern.Capture<UExpression>> VIEW_PATTERN = (UExpressionPattern)((UExpressionPattern.Capture)UastPatterns.injectionHostOrReferenceExpression().withSourcePsiCondition(SpringMvcLibraryUtil.IS_SPRING_MVC_PROJECT)).andOr(new ElementPattern[]{UastPatterns.uExpression().setterParameter((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("setViewName")).inClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"org.springframework.web.servlet.ModelAndView", "org.springframework.web.servlet.config.annotation.ViewControllerRegistration"})))), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("view")).inClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName("org.springframework.web.reactive.result.view.Rendering"))), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("render")).inClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName("org.springframework.web.reactive.function.server.ServerResponse.BodyBuilder"))), UastPatterns.uExpression().constructorParameter(0, "org.springframework.web.servlet.ModelAndView"), UastPatterns.uExpression().filterWithContext((uLiteral, ctx) -> {
        UReturnExpression parent = ((StreamEx)((StreamEx)StreamEx.iterate((Object)uLiteral, Objects::nonNull, e -> e.getUastParent()).limit(5L)).takeWhile(ex -> !(ex instanceof UCallExpression) || SpringMVCViewUastReferenceProvider.isReactiveCall((UCallExpression)ex))).select(UReturnExpression.class).findFirst().orElse(null);
        return SpringMVCViewUastReferenceProvider.isReturnStatement(parent, ctx);
    })});
    private final SpringMVCViewReferenceProvider myProvider;

    @NotNull
    private static Boolean isReturnStatement(UReturnExpression returnExpression, ProcessingContext ctx) {
        if (returnExpression != null) {
            UCallExpression uastParent;
            UElement jumpTarget = returnExpression.getJumpTarget();
            if (jumpTarget instanceof UMethod) {
                Boolean bl = MVC_REQUEST_HANDLER_PATTERN.accepts((Object)((UMethod)jumpTarget).getJavaPsi(), ctx);
                if (bl == null) {
                    SpringMVCViewUastReferenceProvider.$$$reportNull$$$0(0);
                }
                return bl;
            }
            if (jumpTarget instanceof ULambdaExpression && (uastParent = (UCallExpression)ObjectUtils.tryCast((Object)jumpTarget.getUastParent(), UCallExpression.class)) != null && LAMBDA_IN_MONO_MAP_PATTERN.accepts((Object)uastParent)) {
                return SpringMVCViewUastReferenceProvider.isReturnStatement((UReturnExpression)UastUtils.getParentOfType((UElement)uastParent, UReturnExpression.class), ctx);
            }
        }
        Boolean bl = false;
        if (bl == null) {
            SpringMVCViewUastReferenceProvider.$$$reportNull$$$0(1);
        }
        return bl;
    }

    private SpringMVCViewUastReferenceProvider(boolean soft) {
        this.myProvider = new SpringMVCViewReferenceProvider(soft);
    }

    public static void register(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringMVCViewUastReferenceProvider.$$$reportNull$$$0(2);
        }
        UastReferenceRegistrar.registerReferenceProviderByUsage((PsiReferenceRegistrar)registrar, (ElementPattern)UastReferenceByUsageAdapterKt.uInjectionHostInVariable(), VIEW_PATTERN, (UastReferenceProvider)new SpringMVCViewUastReferenceProvider(false), (double)100.0);
    }

    public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
        if (uExpression == null) {
            SpringMVCViewUastReferenceProvider.$$$reportNull$$$0(3);
        }
        if (host == null) {
            SpringMVCViewUastReferenceProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SpringMVCViewUastReferenceProvider.$$$reportNull$$$0(5);
        }
        PsiReference[] psiReferenceArray = this.myProvider.getReferencesByElement((PsiElement)host, context);
        if (psiReferenceArray == null) {
            SpringMVCViewUastReferenceProvider.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    public static boolean isReactiveCall(@NotNull UCallExpression e) {
        if (e == null) {
            SpringMVCViewUastReferenceProvider.$$$reportNull$$$0(7);
        }
        return MONO_RETURN_PATTERN.accepts((Object)e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/SpringMVCViewUastReferenceProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "isReturnStatement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/SpringMVCViewUastReferenceProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesForInjectionHost";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesForInjectionHost";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReactiveCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 7 -> new IllegalArgumentException(string);
        };
    }
}

