/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.jpa;

import com.intellij.jpa.facet.JpaFacet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.persistence.integration.jpa.SpringAnnoJpaPersistenceUnit;
import com.intellij.spring.persistence.integration.jpa.SpringXmlJpaPersistenceUnit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class SpringJpaPersistencePackageProvider
implements PersistencePackagesProvider {
    private static final Key<CachedValue<List<PersistencePackage>>> SPRING_ENTITY_MANAGER_FACTORIES_KEY = Key.create((String)"SPRING_ENTITY_MANAGER_FACTORIES_KEY");

    SpringJpaPersistencePackageProvider() {
    }

    @NotNull
    public List<PersistencePackage> getPersistencePackages(PersistenceFacet facet) {
        Module module = facet.getModule();
        if (!(facet instanceof JpaFacet) || !module.isLoaded() || DumbService.isDumb((Project)module.getProject())) {
            List<PersistencePackage> list = Collections.emptyList();
            if (list == null) {
                SpringJpaPersistencePackageProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<PersistencePackage> persistencePackages = (List<PersistencePackage>)RecursionManager.doPreventingRecursion((Object)facet, (boolean)false, () -> this.getCachedPackages(module));
        List<PersistencePackage> list = persistencePackages != null ? persistencePackages : Collections.emptyList();
        if (list == null) {
            SpringJpaPersistencePackageProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private List<PersistencePackage> getCachedPackages(Module module) {
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, SPRING_ENTITY_MANAGER_FACTORIES_KEY, () -> {
            HashSet<SpringXmlJpaPersistenceUnit> result = new HashSet<SpringXmlJpaPersistenceUnit>();
            SpringManager springManager = SpringManager.getInstance((Project)module.getProject());
            SpringModel springModel = this.getModelInReadAction(module);
            PsiClass psiClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.orm.jpa.AbstractEntityManagerFactoryBean");
            if (psiClass != null) {
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)psiClass).withInheritors();
                for (SpringBeanPointer bean : SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters)) {
                    if (bean.isAbstract()) continue;
                    Object persistencePackage = bean instanceof DomSpringBeanPointer ? new SpringXmlJpaPersistenceUnit((DomSpringBeanPointer)bean, module) : new SpringAnnoJpaPersistenceUnit(bean, module);
                    result.add((SpringXmlJpaPersistenceUnit)((Object)((Object)persistencePackage)));
                }
            }
            ArrayList factories = new ArrayList(result);
            HashSet<PsiFile> configFiles = new HashSet<PsiFile>(SpringModelVisitorUtils.getConfigFiles((CommonSpringModel)springModel));
            GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)module.getProject());
            configFiles.removeIf(file -> librariesScope.contains(file.getVirtualFile()));
            HashSet<Object> dependencies = new HashSet<Object>(configFiles);
            SpringJpaPersistencePackageProvider.addComponentScanDependencies(springModel, dependencies, module.getProject());
            return CachedValueProvider.Result.create(factories, (Object[])springManager.getModelsDependencies(module, ArrayUtil.toObjectArray(dependencies)));
        }, false);
        if (list == null) {
            SpringJpaPersistencePackageProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static void addComponentScanDependencies(@NotNull SpringModel springModel, @NotNull Set<Object> dependencies, @NotNull Project project) {
        if (springModel == null) {
            SpringJpaPersistencePackageProvider.$$$reportNull$$$0(3);
        }
        if (dependencies == null) {
            SpringJpaPersistencePackageProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            SpringJpaPersistencePackageProvider.$$$reportNull$$$0(5);
        }
        if (SpringModelVisitorUtils.hasComponentScans((CommonSpringModel)springModel)) {
            ContainerUtil.addAll(dependencies, (Object[])SpringModificationTrackersManager.getInstance((Project)project).getOuterModelsDependencies());
        }
    }

    @NotNull
    public SpringModel getModelInReadAction(@NotNull Module module) {
        if (module == null) {
            SpringJpaPersistencePackageProvider.$$$reportNull$$$0(6);
        }
        Processor processor = model -> false;
        CommonSpringModelVisitorContext context = CommonSpringModelVisitorContext.context((Processor)processor, (CommonSpringModelVisitorContext.Exec)new CommonSpringModelVisitorContext.Exec<CommonSpringModel>(this){

            public boolean run(@NotNull CommonSpringModel model, @NotNull Processor<? super CommonSpringModel> params) {
                if (model == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (params == null) {
                    1.$$$reportNull$$$0(1);
                }
                return params.process((Object)model);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "params";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/persistence/integration/jpa/SpringJpaPersistencePackageProvider$1";
                objectArray[2] = "run";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        SpringModel springModel = (SpringModel)ReadAction.compute(() -> SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module));
        if (springModel == null) {
            SpringJpaPersistencePackageProvider.$$$reportNull$$$0(7);
        }
        return springModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/persistence/integration/jpa/SpringJpaPersistencePackageProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistencePackages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPackages";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/persistence/integration/jpa/SpringJpaPersistencePackageProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelInReadAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addComponentScanDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModelInReadAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

