/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.liveTemplates.contextTypes;

import com.intellij.codeInsight.template.LiveTemplateContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.database.Dbms;
import com.intellij.database.liveTemplates.SqlTemplateContextTypeCommon;
import com.intellij.lang.Language;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.liveTemplates.LiveTemplateContextWrapper;
import com.intellij.sql.liveTemplates.contextTypes.SqlAllDialectsCodeContextType;
import com.intellij.sql.liveTemplates.contextTypes.SqlAllDialectsQueryContextType;
import com.intellij.sql.liveTemplates.contextTypes.SqlAllDialectsStatementContextType;
import com.intellij.sql.psi.SqlFile;
import org.jetbrains.annotations.NotNull;

public class SqlDialectContextType
extends TemplateContextType
implements SqlTemplateContextTypeCommon {
    private final Dbms myDbms;

    private SqlDialectContextType(String id, Dbms dbms, @NotNull Class<? extends TemplateContextType> baseContextType, @NlsContexts.Label String familyDisplayName) {
        if (baseContextType == null) {
            SqlDialectContextType.$$$reportNull$$$0(0);
        }
        super(id, familyDisplayName, baseContextType);
        this.myDbms = dbms;
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            SqlDialectContextType.$$$reportNull$$$0(1);
        }
        if (!(file instanceof SqlFile)) {
            return false;
        }
        Language language = file.getLanguage();
        if (!(language instanceof SqlLanguageDialect)) {
            return false;
        }
        if (!((SqlLanguageDialect)language).getDbms().is(this.myDbms)) {
            return false;
        }
        TemplateContextType baseContextType = this.getBaseContextType();
        return baseContextType == null || baseContextType.isInContext(file, offset);
    }

    @NotNull
    public static LiveTemplateContext createCodeContext(@NotNull Dbms dbms, @NlsContexts.Label String familyDisplayName) {
        if (dbms == null) {
            SqlDialectContextType.$$$reportNull$$$0(2);
        }
        String contextId = "SQL_CODE_" + dbms.getName();
        return new LiveTemplateContextWrapper(contextId, "SQL_CODE", (NotNullLazyValue<? extends TemplateContextType>)NotNullLazyValue.atomicLazy(() -> new SqlDialectContextType(contextId, dbms, SqlAllDialectsCodeContextType.class, familyDisplayName)));
    }

    @NotNull
    public static LiveTemplateContext createStatementContext(@NotNull Dbms dbms, @NlsContexts.Label String familyDisplayName) {
        if (dbms == null) {
            SqlDialectContextType.$$$reportNull$$$0(3);
        }
        String contextId = "SQL_STATEMENT_" + dbms.getName();
        return new LiveTemplateContextWrapper(contextId, "SQL_STATEMENT", (NotNullLazyValue<? extends TemplateContextType>)NotNullLazyValue.atomicLazy(() -> new SqlDialectContextType(contextId, dbms, SqlAllDialectsStatementContextType.class, familyDisplayName)));
    }

    @NotNull
    public static LiveTemplateContext createQueryContext(@NotNull Dbms dbms, @NlsContexts.Label String familyDisplayName) {
        if (dbms == null) {
            SqlDialectContextType.$$$reportNull$$$0(4);
        }
        String contextId = "SQL_QUERY_" + dbms.getName();
        return new LiveTemplateContextWrapper(contextId, "SQL_QUERY", (NotNullLazyValue<? extends TemplateContextType>)NotNullLazyValue.atomicLazy(() -> new SqlDialectContextType(contextId, dbms, SqlAllDialectsQueryContextType.class, familyDisplayName)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseContextType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/liveTemplates/contextTypes/SqlDialectContextType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCodeContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createStatementContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createQueryContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

