/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.NoThreadInfoInProfilerData;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BS\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/CollapsedDumpParser;", "FrameItem", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/LineByLineParser;", "dataBuilder", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "threadNameMapper", "Lkotlin/Function1;", "", "Lcom/intellij/profiler/model/ThreadInfo;", "frameItemMapper", "firstFrameIsThreadNameValidator", "", "<init>", "(Lcom/intellij/profiler/DummyCallTreeBuilder;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getDataBuilder", "()Lcom/intellij/profiler/DummyCallTreeBuilder;", "cachedFrames", "Ljava/util/concurrent/ConcurrentHashMap;", "firstFrameIsThread", "Lcom/intellij/util/ThreeState;", "consumeLine", "", "line", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCollapsedDumpParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollapsedDumpParser.kt\ncom/intellij/profiler/CollapsedDumpParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1563#2:50\n1634#2,3:51\n*S KotlinDebug\n*F\n+ 1 CollapsedDumpParser.kt\ncom/intellij/profiler/CollapsedDumpParser\n*L\n43#1:50\n43#1:51,3\n*E\n"})
public final class CollapsedDumpParser<FrameItem extends BaseCallStackElement>
extends LineByLineParser {
    @NotNull
    private final DummyCallTreeBuilder<FrameItem> dataBuilder;
    @NotNull
    private final Function1<String, ThreadInfo> threadNameMapper;
    @NotNull
    private final Function1<String, FrameItem> frameItemMapper;
    @NotNull
    private final Function1<String, Boolean> firstFrameIsThreadNameValidator;
    @NotNull
    private final ConcurrentHashMap<String, FrameItem> cachedFrames;
    @NotNull
    private ThreeState firstFrameIsThread;

    public CollapsedDumpParser(@NotNull DummyCallTreeBuilder<FrameItem> dataBuilder, @NotNull Function1<? super String, ? extends ThreadInfo> threadNameMapper, @NotNull Function1<? super String, ? extends FrameItem> frameItemMapper, @NotNull Function1<? super String, Boolean> firstFrameIsThreadNameValidator) {
        Intrinsics.checkNotNullParameter(dataBuilder, (String)"dataBuilder");
        Intrinsics.checkNotNullParameter(threadNameMapper, (String)"threadNameMapper");
        Intrinsics.checkNotNullParameter(frameItemMapper, (String)"frameItemMapper");
        Intrinsics.checkNotNullParameter(firstFrameIsThreadNameValidator, (String)"firstFrameIsThreadNameValidator");
        this.dataBuilder = dataBuilder;
        this.threadNameMapper = threadNameMapper;
        this.frameItemMapper = frameItemMapper;
        this.firstFrameIsThreadNameValidator = firstFrameIsThreadNameValidator;
        this.cachedFrames = new ConcurrentHashMap();
        this.firstFrameIsThread = ThreeState.UNSURE;
    }

    public /* synthetic */ CollapsedDumpParser(DummyCallTreeBuilder dummyCallTreeBuilder, Function1 function1, Function1 function12, Function1 function13, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function13 = CollapsedDumpParser::_init_$lambda$0;
        }
        this(dummyCallTreeBuilder, (Function1<? super String, ? extends ThreadInfo>)function1, function12, (Function1<? super String, Boolean>)function13);
    }

    @NotNull
    public final DummyCallTreeBuilder<FrameItem> getDataBuilder() {
        return this.dataBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void consumeLine(@NotNull String line) {
        Collection<BaseCallStackElement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String framesString = StringsKt.substringBeforeLast((String)line, (char)' ', (String)"");
        Long count = StringsKt.toLongOrNull((String)StringsKt.substringAfterLast$default((String)line, (char)' ', null, (int)2, null));
        if (count == null || ((CharSequence)framesString).length() == 0) {
            int n = this.getBadLines();
            this.setBadLines(n + 1);
            return;
        }
        char[] cArray = new char[]{';'};
        List parts = StringsKt.split$default((CharSequence)framesString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (this.firstFrameIsThread == ThreeState.UNSURE) {
            this.firstFrameIsThread = ThreeState.Companion.fromBoolean(((Boolean)this.firstFrameIsThreadNameValidator.invoke(CollectionsKt.first((List)parts))).booleanValue());
        }
        if (this.firstFrameIsThread.toBoolean() && parts.size() == 1) {
            int n = this.getBadLines();
            this.setBadLines(n + 1);
            return;
        }
        ThreadInfo thread = null;
        List frames = null;
        if (this.firstFrameIsThread.toBoolean()) {
            thread = (ThreadInfo)this.threadNameMapper.invoke(CollectionsKt.first((List)parts));
            frames = CollectionsKt.drop((Iterable)parts, (int)1);
        } else {
            thread = NoThreadInfoInProfilerData.INSTANCE;
            frames = parts;
        }
        Iterable iterable = frames;
        ThreadInfo threadInfo = thread;
        DummyCallTreeBuilder<FrameItem> dummyCallTreeBuilder = this.dataBuilder;
        boolean $i$f$map = false;
        void var9_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            BaseCallStackElement baseCallStackElement = this.cachedFrames.computeIfAbsent((String)it, arg_0 -> CollapsedDumpParser.consumeLine$lambda$0$0(this.frameItemMapper, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)baseCallStackElement, (String)"computeIfAbsent(...)");
            collection.add(baseCallStackElement);
        }
        collection = (List)destination$iv$iv;
        dummyCallTreeBuilder.addStack(threadInfo, (List<FrameItem>)collection, count);
    }

    private static final boolean _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final BaseCallStackElement consumeLine$lambda$0$0(Function1 $tmp0, Object p0) {
        return (BaseCallStackElement)$tmp0.invoke(p0);
    }
}

