/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlBooleanLiteralExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u001b\u001a\u0015\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u001e\u001a\u0015\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001a\u001a\u00020\u0015\u00a2\u0006\u0002\u0010!\u001a\u0015\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u0015\u00a2\u0006\u0002\u0010$\u001a\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001a\u001a\u00020\u0015\u001a\u0015\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001a\u001a\u00020\u0015\u00a2\u0006\u0002\u0010)\u00a8\u0006*"}, d2={"getRelationByToken", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "type", "Lcom/intellij/psi/tree/IElementType;", "dbms", "Lcom/intellij/database/Dbms;", "getRelationForIsExpression", "expression", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "opElement", "Lcom/intellij/psi/PsiElement;", "fromLiteral", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "expr", "Lcom/intellij/sql/psi/SqlLiteralExpression;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getValue", "", "getNumericValue", "value", "", "dasType", "Lcom/intellij/database/types/DasType;", "parseInt", "", "text", "(Ljava/lang/String;)Ljava/lang/Integer;", "parseBigInt", "", "(Ljava/lang/String;)Ljava/lang/Long;", "parseReal", "", "(Ljava/lang/String;)Ljava/lang/Float;", "parseDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "parseNumeric", "Ljava/math/BigDecimal;", "parseBoolean", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlDfaPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlDfaPsiUtil.kt\ncom/intellij/sql/inspections/dataflow/SqlDfaPsiUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1761#2,3:164\n*S KotlinDebug\n*F\n+ 1 SqlDfaPsiUtil.kt\ncom/intellij/sql/inspections/dataflow/SqlDfaPsiUtilKt\n*L\n44#1:164,3\n*E\n"})
public final class SqlDfaPsiUtilKt {
    @Nullable
    public static final RelationType getRelationByToken(@NotNull IElementType type, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return SqlPsiUtilKt.isEq(type, dbms) ? RelationType.EQ : (SqlPsiUtilKt.isNotEq(type, dbms) ? RelationType.NE : (Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_OP_GT) ? RelationType.GT : (Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_OP_LT) ? RelationType.LT : (Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_OP_LE) ? RelationType.LE : (Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_OP_GE) ? RelationType.GE : (Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_OP_NOT_GT) && dbms.isMicrosoft() ? RelationType.LE : (Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_OP_NOT_LT) && dbms.isMicrosoft() ? RelationType.GE : null)))))));
    }

    @NotNull
    public static final RelationType getRelationForIsExpression(@NotNull SqlBinaryExpression expression, @NotNull PsiElement opElement) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)opElement, (String)"opElement");
        return expression.isNot() ^ SqlDfaPsiUtilKt.getRelationForIsExpression$isDistinctFrom(opElement) ? RelationType.NE : RelationType.EQ;
    }

    @NotNull
    public static final DfType fromLiteral(@NotNull SqlLiteralExpression expr, @NotNull SqlLanguageDialectEx dialect) {
        Object value;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        DasType dasType = expr.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        if (Intrinsics.areEqual((Object)dasType2, (Object)DasTypeSystemBase.UNKNOWN)) {
            DfType dfType = DfType.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"TOP");
            return dfType;
        }
        if (Intrinsics.areEqual((Object)dasType2, (Object)DasTypeSystemBase.NULL)) {
            return SqlDfTypesKt.getNULL();
        }
        if (DasTypeUtilsKt.getCategory((DasType)dasType2) == DasTypeCategory.BOOLEAN && SqlPsiUtilKt.isUnknown((PsiElement)expr)) {
            return SqlDfTypesKt.getNULL();
        }
        Object object = value = SqlDfaPsiUtilKt.getValue(expr, dialect);
        return object == null ? (DfType)SqlDfTypesKt.getNOT_NULL() : SqlDfTypesKt.constant(object);
    }

    private static final Object getValue(SqlLiteralExpression $this$getValue, SqlLanguageDialectEx dialect) {
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        String string = $this$getValue.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String text = string3;
        string2 = PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)$this$getValue));
        if (Intrinsics.areEqual((Object)string2, (Object)SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL)) {
            boolean bl;
            if (!($this$getValue instanceof SqlBooleanLiteralExpression)) {
                return null;
            }
            if (((SqlBooleanLiteralExpression)$this$getValue).isTrue()) {
                bl = true;
            } else if (((SqlBooleanLiteralExpression)$this$getValue).isFalse()) {
                bl = false;
            } else {
                return null;
            }
            boolean value = bl;
            return dbms2.isPostgres() ? (Comparable<Boolean>)Boolean.valueOf(value) : (Comparable<Boolean>)(dbms2.isMysql() ? Integer.valueOf(SqlUtilFun.toInt(value)) : null);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL)) {
            DasType dasType = $this$getValue.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            return SqlDfaPsiUtilKt.getNumericValue(text, dasType, dialect);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL)) {
            SqlStringLiteralExpression sqlStringLiteralExpression = $this$getValue instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)$this$getValue : null;
            return sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
        }
        return null;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object getNumericValue(String value, DasType dasType, SqlLanguageDialectEx dialect) {
        Number number;
        block35: {
            block34: {
                DasTypeSystemBase typeSystem;
                Dbms dbms;
                DataType type;
                block31: {
                    block32: {
                        block33: {
                            block29: {
                                DataType dataType = dasType.toDataType();
                                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
                                type = dataType;
                                Dbms dbms2 = dialect.getDbms();
                                Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"getDbms(...)");
                                dbms = dbms2;
                                DasTypeSystemBase dasTypeSystemBase = dialect.getTypeSystem();
                                Intrinsics.checkNotNullExpressionValue((Object)dasTypeSystemBase, (String)"getTypeSystem(...)");
                                typeSystem = dasTypeSystemBase;
                                if (!dbms.isPostgres()) break block29;
                                String string = type.typeName;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
                                switch (typeSystem.getNormalizedTypeName(string)) {
                                    case "integer": {
                                        Integer n = SqlDfaPsiUtilKt.parseInt(value);
                                        number = n;
                                        if (n != null) return number;
                                        number = SqlDfaPsiUtilKt.parseBigInt(value);
                                        return number;
                                    }
                                    case "bigint": {
                                        number = SqlDfaPsiUtilKt.parseBigInt(value);
                                        return number;
                                    }
                                    case "numeric": {
                                        number = SqlDfaPsiUtilKt.parseNumeric(value);
                                        return number;
                                    }
                                    default: {
                                        return null;
                                    }
                                }
                            }
                            if (!dbms.isMicrosoft()) break block31;
                            String string = type.typeName;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
                            String string2 = typeSystem.getNormalizedTypeName(string);
                            switch (string2.hashCode()) {
                                case -2000413939: {
                                    if (!string2.equals("numeric")) {
                                        return null;
                                    }
                                    break block32;
                                }
                                case 97526364: {
                                    if (!string2.equals("float")) {
                                        return null;
                                    }
                                    break block33;
                                }
                                case -1389167889: {
                                    if (string2.equals("bigint")) break;
                                    return null;
                                }
                                case 104431: {
                                    if (!string2.equals("int")) return null;
                                    number = SqlDfaPsiUtilKt.parseInt(value);
                                    return number;
                                }
                            }
                            number = SqlDfaPsiUtilKt.parseBigInt(value);
                            return number;
                        }
                        number = SqlDfaPsiUtilKt.parseDouble(value);
                        return number;
                    }
                    number = SqlDfaPsiUtilKt.parseNumeric(value);
                    return number;
                    return null;
                }
                if (!dbms.isMysql()) return null;
                String string = type.typeName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
                String string3 = typeSystem.getNormalizedTypeName(string);
                switch (string3.hashCode()) {
                    case -1325958191: {
                        if (!string3.equals("double")) {
                            return null;
                        }
                        break block34;
                    }
                    case 1542263633: {
                        if (!string3.equals("decimal")) {
                            return null;
                        }
                        break block35;
                    }
                    case -1389167889: {
                        if (string3.equals("bigint")) break;
                        return null;
                    }
                    case 104431: {
                        if (!string3.equals("int")) return null;
                        Integer n = SqlDfaPsiUtilKt.parseInt(value);
                        number = n;
                        if (n != null) return number;
                        number = SqlDfaPsiUtilKt.parseBigInt(value);
                        return number;
                    }
                }
                number = SqlDfaPsiUtilKt.parseBigInt(value);
                return number;
            }
            number = SqlDfaPsiUtilKt.parseDouble(value);
            return number;
        }
        number = SqlDfaPsiUtilKt.parseNumeric(value);
        return number;
        return null;
    }

    @Nullable
    public static final Integer parseInt(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Long parseBigInt(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Float parseReal(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            float value = Float.parseFloat(text);
            return Math.abs(value) <= Float.MAX_VALUE ? Float.valueOf(value) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Double parseDouble(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            double value = Double.parseDouble(text);
            return Math.abs(value) <= Double.MAX_VALUE ? Double.valueOf(value) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final BigDecimal parseNumeric(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            return new BigDecimal(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Boolean parseBoolean(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = text;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        return Intrinsics.areEqual((Object)string3, (Object)"true") ? Boolean.valueOf(true) : (Intrinsics.areEqual((Object)string3, (Object)"false") ? Boolean.valueOf(false) : null);
    }

    private static final boolean getRelationForIsExpression$isDistinctFrom(PsiElement $opElement) {
        boolean bl;
        block3: {
            JBIterable jBIterable = SyntaxTraverser.psiApi().children((Object)$opElement);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"children(...)");
            Iterable $this$any$iv = (Iterable)jBIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlCommonKeywords.SQL_DISTINCT)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

