/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram.actions;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ddl.CreateObjectAction;
import com.intellij.database.actions.ddl.CreateObjectActionHelper;
import com.intellij.database.actions.ddl.CreateObjectGroup;
import com.intellij.database.diagram.actions.DbDiagramCreateAction;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JY\u0010\u0004\u001a5\u0012,\u0012*\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b0\u0005\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/diagram/actions/DbDiagramCreateObjectGroup;", "Lcom/intellij/database/actions/ddl/CreateObjectGroup$Public;", "<init>", "()V", "getCreateTargets", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/model/basic/BasicElement;", "kotlin.jvm.PlatformType", "Lcom/intellij/database/actions/ddl/CreateObjectActionHelper$CreateData;", "Lorg/jetbrains/annotations/Nullable;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "dbms", "Lcom/intellij/database/Dbms;", "element", "Lcom/intellij/database/model/basic/BasicObjectNode;", "prioritize", "Lcom/intellij/database/model/meta/BasicMetaObject;", "isTableElement", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "createAction", "Lcom/intellij/database/actions/ddl/CreateObjectAction;", "meta", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "Companion", "intellij.database.diagrams"})
public final class DbDiagramCreateObjectGroup
extends CreateObjectGroup.Public {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<ObjectKind> TABLE_LIKE_KINDS;

    @NotNull
    protected JBIterable<Pair<BasicElement, CreateObjectActionHelper.CreateData>> getCreateTargets(@NotNull Dbms dbms, @NotNull BasicObjectNode element, @Nullable BasicMetaObject<?> prioritize) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JBIterable jBIterable = super.getCreateTargets(dbms, element, prioritize).filter(arg_0 -> DbDiagramCreateObjectGroup.getCreateTargets$lambda$1(arg_0 -> DbDiagramCreateObjectGroup.getCreateTargets$lambda$0(element, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private final boolean isTableElement(ObjectKind kind) {
        return TABLE_LIKE_KINDS.contains(kind);
    }

    @NotNull
    protected CreateObjectAction createAction(@NotNull BasicMetaObject<?> meta, @NotNull ModelHelper.ObjectKindVariant variant) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return new DbDiagramCreateAction(meta, variant);
    }

    private static final boolean getCreateTargets$lambda$0(BasicObjectNode $element, DbDiagramCreateObjectGroup this$0, Pair it) {
        boolean bl;
        if (it == null) {
            return true;
        }
        BasicMetaObject createMeta = ((CreateObjectActionHelper.CreateData)it.second).meta;
        ObjectKind createKind = createMeta.kind;
        ObjectKind contextKind = $element.getMetaObject().kind;
        if (Intrinsics.areEqual((Object)contextKind, (Object)ObjectKind.SCHEMA)) {
            bl = DbImplUtilCore.isDataTable((ObjectKind)createKind);
        } else if (DbImplUtilCore.isDataTable((ObjectKind)contextKind)) {
            Intrinsics.checkNotNull((Object)createKind);
            bl = this$0.isTableElement(createKind);
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean getCreateTargets$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.INDEX, ObjectKind.CHECK};
        TABLE_LIKE_KINDS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/diagram/actions/DbDiagramCreateObjectGroup$Companion;", "", "<init>", "()V", "TABLE_LIKE_KINDS", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "intellij.database.diagrams"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

