/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestPsiUtilsKt;
import com.intellij.httpClient.http.request.completion.HttpSuffixInsertHandler;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableReference;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class HttpVariableSuffixInsertHandler
implements InsertHandler<LookupElement> {
    private final HttpSuffixInsertHandler mySuffixInsertHandler = new HttpSuffixInsertHandler("}}");

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        if (context2 == null) {
            HttpVariableSuffixInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            HttpVariableSuffixInsertHandler.$$$reportNull$$$0(1);
        }
        HttpVariableSuffixInsertHandler.removeNotReplacedAfterDashNamePart(context2, item.getLookupString());
        this.mySuffixInsertHandler.handleInsert(context2, item);
    }

    private static void replaceVariableWithDash(Editor editor2, PsiFile file, String value2) {
        TextRange textRange;
        Document document = editor2.getDocument();
        int elementOffset = StringUtil.skipWhitespaceForward((CharSequence)document.getCharsSequence(), (int)editor2.getCaretModel().getOffset());
        PsiElement element = file.findElementAt(elementOffset);
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof HttpVariable) {
            PsiElement identifier = HttpRequestPsiUtilsKt.retrieveHttpVariableIdentifier((HttpVariable)parent);
            if (identifier == null) {
                return;
            }
            String text2 = identifier.getText();
            if (text2 == null) {
                return;
            }
            if (identifier.getText().equals(value2)) {
                return;
            }
            textRange = identifier.getTextRange();
            if (HttpVariableSuffixInsertHandler.shouldNotBeReplaced(identifier.getText(), value2)) {
                return;
            }
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)value2);
        }
        if (parent instanceof HttpDynamicVariableReference) {
            String variableName;
            String text3 = parent.getText();
            if (HttpVariableSuffixInsertHandler.shouldNotBeReplaced(text3, variableName = value2.substring(value2.indexOf("$") + 1))) {
                return;
            }
            textRange = parent.getTextRange();
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)variableName);
        }
    }

    private static boolean shouldNotBeReplaced(String current, String value2) {
        return current.equals(value2) || current.contains(".");
    }

    private static void removeNotReplacedAfterDashNamePart(InsertionContext context2, String value2) {
        if (context2.getFile().getFileType() == HttpRequestFileType.INSTANCE) {
            HttpVariableSuffixInsertHandler.replaceVariableWithDash(context2.getEditor(), context2.getFile(), value2);
            return;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)context2.getProject());
        PsiFile topLeveFile = manager.getTopLevelFile((PsiElement)context2.getFile());
        if (topLeveFile.getFileType() != HttpRequestFileType.INSTANCE) {
            return;
        }
        HttpVariableSuffixInsertHandler.replaceVariableWithDash(((EditorWindow)context2.getEditor()).getDelegate(), topLeveFile, value2);
    }

    public String getSuffix() {
        return this.mySuffixInsertHandler.getSuffix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpVariableSuffixInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

