/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.editing;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.ide.PbIdeBundle;
import com.intellij.protobuf.ide.settings.PbTextLanguageSettings;
import com.intellij.protobuf.ide.settings.PbTextLanguageSettingsConfigurable;
import com.intellij.protobuf.lang.psi.PbTextFile;
import com.intellij.protobuf.lang.resolve.directive.SchemaDirective;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingSchemaNotificationProvider
implements EditorNotificationProvider {
    private final Collection<VirtualFile> ignoredFiles = new WeakList();

    public static void update(PbTextFile file) {
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        EditorNotifications.getInstance((Project)file.getProject()).updateNotifications(virtualFile);
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MissingSchemaNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MissingSchemaNotificationProvider.$$$reportNull$$$0(1);
        }
        if (this.ignoredFiles.contains(file)) {
            return null;
        }
        PbTextLanguageSettings settings = PbTextLanguageSettings.getInstance(project);
        if (settings == null || !settings.isMissingSchemaWarningEnabled()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof PbTextFile)) {
            return null;
        }
        PbTextFile textFile = (PbTextFile)psiFile;
        SchemaDirective existingDirective = SchemaDirective.find((PsiFile)textFile);
        if (existingDirective != null) {
            return null;
        }
        if (textFile.isBound()) {
            return null;
        }
        return fileEditor -> this.createPanelForTextFormatFile(textFile);
    }

    public EditorNotificationPanel createPanelForTextFormatFile(PbTextFile file) {
        PbTextLanguageSettings settings;
        EditorNotificationPanel panel = new EditorNotificationPanel(EditorNotificationPanel.Status.Warning);
        panel.setText(PbIdeBundle.message("prototext.missing.schema.message", new Object[0]));
        HyperlinkListener closingListener = event -> EditorNotifications.getInstance((Project)file.getProject()).updateNotifications(file.getVirtualFile());
        if (file.isWritable()) {
            panel.createActionLabel(PbIdeBundle.message("prototext.missing.schema.insert.annotation", new Object[0]), "prototext.InsertSchemaDirective").addHyperlinkListener(closingListener);
        }
        if ((settings = PbTextLanguageSettings.getInstance(file.getProject())) != null) {
            panel.createActionLabel(PbIdeBundle.message("prototext.missing.schema.settings", new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(file.getProject(), PbTextLanguageSettingsConfigurable.class)).addHyperlinkListener(closingListener);
        }
        panel.createActionLabel(PbIdeBundle.message("prototext.missing.schema.ignore", new Object[0]), () -> this.ignoredFiles.add(file.getVirtualFile())).addHyperlinkListener(closingListener);
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/protobuf/ide/editing/MissingSchemaNotificationProvider";
        objectArray[2] = "collectNotificationData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

