/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.protobuf.lang.PbFileType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FileResolveProvider {
    public static final ExtensionPointName<FileResolveProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.protobuf.fileResolveProvider");
    public static final VirtualFileFilter PROTO_AND_DIRECTORY_FILTER = file -> file.isDirectory() || file.getFileType() instanceof PbFileType;
    public static final VirtualFileFilter PROTO_FILTER = file -> file.getFileType() instanceof PbFileType;

    @Nullable
    public VirtualFile findFile(@NotNull String var1, @NotNull Project var2);

    @Nullable
    default public VirtualFile findFile(@NotNull String path, @NotNull Module module) {
        if (path == null) {
            FileResolveProvider.$$$reportNull$$$0(0);
        }
        if (module == null) {
            FileResolveProvider.$$$reportNull$$$0(1);
        }
        return this.findFile(path, module.getProject());
    }

    @NotNull
    public Collection<ChildEntry> getChildEntries(@NotNull String var1, @NotNull Project var2);

    @NotNull
    default public Collection<ChildEntry> getChildEntries(@NotNull String path, @NotNull Module module) {
        if (path == null) {
            FileResolveProvider.$$$reportNull$$$0(2);
        }
        if (module == null) {
            FileResolveProvider.$$$reportNull$$$0(3);
        }
        Collection<ChildEntry> collection = this.getChildEntries(path, module.getProject());
        if (collection == null) {
            FileResolveProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Nullable
    public VirtualFile getDescriptorFile(@NotNull Project var1);

    @Nullable
    default public VirtualFile getDescriptorFile(@NotNull Module module) {
        if (module == null) {
            FileResolveProvider.$$$reportNull$$$0(5);
        }
        return this.getDescriptorFile(module.getProject());
    }

    default public boolean canFindFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FileResolveProvider.$$$reportNull$$$0(6);
        }
        if (file == null) {
            FileResolveProvider.$$$reportNull$$$0(7);
        }
        return this.getSearchScope(project).contains(file);
    }

    @NotNull
    public GlobalSearchScope getSearchScope(@NotNull Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/FileResolveProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/FileResolveProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildEntries";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canFindFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    public static class ChildEntry {
        private final boolean isDirectory;
        private final String name;

        public ChildEntry(@NotNull String name, boolean isDirectory) {
            if (name == null) {
                ChildEntry.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.isDirectory = isDirectory;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ChildEntry)) {
                return false;
            }
            ChildEntry other = (ChildEntry)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.isDirectory, other.isDirectory);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.isDirectory);
        }

        public static ChildEntry file(String name) {
            return new ChildEntry(name, false);
        }

        public static ChildEntry directory(String name) {
            return new ChildEntry(name, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/protobuf/lang/resolve/FileResolveProvider$ChildEntry", "<init>"));
        }
    }
}

