/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReferenceBase
implements PsiReference {
    private final XPathElement element;
    private final ASTNode nameNode;

    public ReferenceBase(XPathElement element, ASTNode nameNode) {
        this.element = element;
        this.nameNode = nameNode;
    }

    @NotNull
    public XPathElement getElement() {
        XPathElement xPathElement = this.element;
        if (xPathElement == null) {
            ReferenceBase.$$$reportNull$$$0(0);
        }
        return xPathElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        int outer = this.element.getTextRange().getStartOffset();
        TextRange textRange = TextRange.from((int)(this.nameNode.getTextRange().getStartOffset() - outer), (int)this.nameNode.getTextLength());
        if (textRange == null) {
            ReferenceBase.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.nameNode.getText();
        if (string == null) {
            ReferenceBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ReferenceBase.$$$reportNull$$$0(3);
        }
        throw new IncorrectOperationException("unsupported");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ReferenceBase.$$$reportNull$$$0(4);
        }
        throw new IncorrectOperationException("unsupported");
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ReferenceBase.$$$reportNull$$$0(5);
        }
        return Comparing.equal((Object)this.resolve(), (Object)element);
    }

    public boolean isSoft() {
        return true;
    }

    public ASTNode getNameNode() {
        return this.nameNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/psi/impl/ReferenceBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/psi/impl/ReferenceBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

