/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.jetbrains.plugins.webDeployment.ServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.WebServerTreeBuilder;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class DefaultServerTreeContentListener
implements ServerTreeContentListener {
    private final WebServerTreeBuilder myTreeBuilder;
    private final ServerTree myTree;
    private final Deployable myServer;

    public DefaultServerTreeContentListener(ServerTree tree, WebServerTreeBuilder treeBuilder, Deployable server) {
        this.myTreeBuilder = treeBuilder;
        this.myTree = tree;
        this.myServer = server;
    }

    @Override
    public void refreshSubtree(Deployable s, Collection<WebServerConfig.RemotePath> roots, boolean resync, boolean cleanNodesCache, @Nullable WebServerConfig.RemotePath selectAfterRefresh, @Nullable Object requestor) {
        WebServerTreeBuilder treeBuilder = this.getTreeBuilder();
        if (this.shouldIgnore(s, treeBuilder)) {
            return;
        }
        try {
            treeBuilder.refreshSubtree(roots, resync, cleanNodesCache, this.getTree() == requestor ? selectAfterRefresh : null);
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    @Override
    public void refreshWhenIdle(Deployable server, ServerTreeNode node) {
        WebServerTreeBuilder treeBuilder = this.getTreeBuilder();
        if (this.shouldIgnore(server, treeBuilder)) {
            return;
        }
        try {
            treeBuilder.refreshWhenIdle(node);
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private boolean shouldIgnore(@Nullable Deployable server, @Nullable WebServerTreeBuilder treeBuilder) {
        if (treeBuilder == null || treeBuilder.isDisposed()) {
            return true;
        }
        Deployable properServer = this.getServer();
        return properServer == null || server == null || !properServer.getRootUri().equals(server.getRootUri());
    }

    @Nullable
    protected WebServerTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    @Nullable
    protected ServerTree getTree() {
        return this.myTree;
    }

    @Nullable
    protected Deployable getServer() {
        return this.myServer;
    }
}

