/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJvmModifiersOwner;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.ConditionalEvaluationContextImpl;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.actions.generate.GenerateAutowiredDependenciesUtil;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringConditionalUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.spring.references.SpringBeanResourceReference;
import com.intellij.spring.references.SpringUastQualifierReference;
import com.intellij.uast.UastSmartPointer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

public final class SpringUastInjectionPointsAutowiringChecker {
    public static void checkMethod(@NotNull UMethod uMethod, @NotNull ProblemsHolder holder, @NotNull Map<PsiClass, CommonSpringModel> springModels) {
        PsiElement nameIdentifier;
        PsiElement sourcePsi;
        if (uMethod == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(1);
        }
        if (springModels == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(2);
        }
        if ((sourcePsi = uMethod.getSourcePsi()) == null) {
            return;
        }
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass psiClass = psiMethod.getContainingClass();
        CommonSpringModel model = springModels.get(psiClass);
        if (model == null) {
            return;
        }
        if (psiMethod.getParameterList().getParametersCount() == 0 && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod) && (nameIdentifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) != null) {
            String msg = SpringBundle.message("bean.autowiring.by.type.no.parameter.for.autowired.method", JavaElementKind.fromElement((PsiElement)psiMethod).subject());
            holder.registerProblem(nameIdentifier, msg, new LocalQuickFix[0]);
        }
        if (!SpringUastInjectionPointsAutowiringChecker.passesConditionCheck(psiMethod, model)) {
            return;
        }
        for (PsiModifierListOwner injectionPoint : SpringAutowireUtil.getInjectionPoints(psiMethod)) {
            UDeclaration declaration = (UDeclaration)UastContextKt.toUElement((PsiElement)injectionPoint, UDeclaration.class);
            if (declaration == null) continue;
            if (injectionPoint instanceof PsiMethod) {
                PsiMethod psi = (PsiMethod)injectionPoint;
                PsiType type = PropertyUtilBase.getPropertyType((PsiMember)psi);
                if (type == null) continue;
                SpringUastInjectionPointsAutowiringChecker.checkInjectionPoint(declaration, type, holder, model, SpringAutowireUtil.isRequired((PsiModifierListOwner)psi));
                return;
            }
            if (!(injectionPoint instanceof PsiParameter)) continue;
            PsiParameter parameter = (PsiParameter)injectionPoint;
            boolean required = SpringAutowireUtil.isRequired((PsiModifierListOwner)psiMethod) && SpringAutowireUtil.isRequired((PsiModifierListOwner)parameter) && !SpringUastInjectionPointsAutowiringChecker.isNullableParameter(parameter);
            SpringUastInjectionPointsAutowiringChecker.checkInjectionPoint(declaration, parameter.getType(), holder, model, required);
        }
    }

    private static boolean passesConditionCheck(PsiMethod psiMethod, CommonSpringModel model) {
        PsiType psiType = psiMethod.getReturnType();
        if (!(psiType instanceof PsiClassType) || !SpringAutowireUtil.hasConditional(psiMethod)) {
            return true;
        }
        List pointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byType((PsiType)psiType));
        for (SpringBeanPointer beanPointer : pointers) {
            if (!beanPointer.isValid() || !psiMethod.equals((Object)beanPointer.getPsiElement())) continue;
            return !SpringUastInjectionPointsAutowiringChecker.filterConditionalBeans(model, Set.of(beanPointer)).isEmpty();
        }
        return true;
    }

    public static void checkField(@NotNull UField uField, @NotNull ProblemsHolder holder, @NotNull Map<PsiClass, CommonSpringModel> springModels) {
        PsiField psiField;
        if (uField == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(4);
        }
        if (springModels == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(5);
        }
        if ((psiField = (PsiField)UElementKt.getAsJavaPsiElement((UElement)uField, PsiField.class)) == null) {
            return;
        }
        if (SpringAutowireUtil.isAutowiringRelevantClass(psiField.getContainingClass()) && (SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiField) || SpringAutowireUtil.isAutowiredInNonPhysicalConstructor(psiField))) {
            CommonSpringModel model = springModels.get(psiField.getContainingClass());
            PsiElement sourcePsi = uField.getSourcePsi();
            if (model != null && sourcePsi != null) {
                SpringUastInjectionPointsAutowiringChecker.checkInjectionPoint((UDeclaration)uField, psiField.getType(), holder, model, SpringAutowireUtil.isRequired((PsiModifierListOwner)psiField));
            }
        }
    }

    private static boolean isNullableParameter(@NotNull PsiParameter psi) {
        if (psi == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(6);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psi, (String)"org.springframework.lang.Nullable", (int)0);
    }

    public static void checkInjectionPoint(@NotNull UDeclaration uDeclaration, @NotNull PsiType psiType, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, boolean required) {
        if (uDeclaration == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(7);
        }
        if (psiType == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(9);
        }
        if (springModel == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(10);
        }
        if (!psiType.isValid()) {
            return;
        }
        if (SpringUastInjectionPointsAutowiringChecker.isInitializedConstructorParameter(uDeclaration)) {
            return;
        }
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)UElementKt.getAsJavaPsiElement((UElement)uDeclaration, PsiModifierListOwner.class);
        if (psiModifierListOwner == null) {
            return;
        }
        PsiAnnotation resourceAnnotation = SpringAutowireUtil.getResourceAnnotation(psiModifierListOwner);
        if (resourceAnnotation != null && psiModifierListOwner instanceof PsiMember) {
            SpringUastInjectionPointsAutowiringChecker.checkResourceInjectionPoint(psiType, holder, springModel, resourceAnnotation);
            return;
        }
        UAnnotation annotation = SpringUastInjectionPointsAutowiringChecker.getEffectiveQualifiedUAnnotation(uDeclaration);
        if (annotation != null) {
            SpringUastInjectionPointsAutowiringChecker.checkQualifiedAutowiring(psiType, uDeclaration, annotation, holder, springModel, required);
            return;
        }
        SpringUastInjectionPointsAutowiringChecker.checkByTypeAutowire(uDeclaration, psiType, holder, springModel, required);
    }

    private static boolean isInitializedConstructorParameter(@NotNull UDeclaration uDeclaration) {
        if (uDeclaration == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(11);
        }
        if (uDeclaration instanceof UParameter) {
            UParameter uParameter = (UParameter)uDeclaration;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)uDeclaration, UMethod.class);
            if (uMethod == null) {
                return false;
            }
            return uMethod.getJavaPsi().isConstructor() && uParameter.getUastInitializer() != null;
        }
        return false;
    }

    @Nullable
    private static UAnnotation getEffectiveQualifiedUAnnotation(UDeclaration uDeclaration) {
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)UElementKt.getAsJavaPsiElement((UElement)uDeclaration, PsiModifierListOwner.class);
        if (psiModifierListOwner == null) {
            return null;
        }
        PsiAnnotation annotation = SpringAutowireUtil.getEffectiveQualifiedAnnotation(psiModifierListOwner);
        if (annotation == null) {
            return null;
        }
        UAnnotation qualifiedAnnotation = null;
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName != null) {
            qualifiedAnnotation = uDeclaration.findAnnotation(qualifiedName);
        }
        if (qualifiedAnnotation == null) {
            qualifiedAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)annotation, UAnnotation.class);
        }
        if (qualifiedAnnotation == null) {
            PsiElement sourcePsi = uDeclaration.getSourcePsi();
            Logger.getInstance(SpringUastInjectionPointsAutowiringChecker.class).error("Psi annotation '" + String.valueOf(annotation) + "' from '" + (sourcePsi != null ? sourcePsi.getText() : null) + "' was not converted to UAST");
        }
        return qualifiedAnnotation;
    }

    private static void checkResourceInjectionPoint(@NotNull PsiType psiType, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, @NotNull PsiAnnotation resourceAnnotation) {
        PsiAnnotationMemberValue attributeValue;
        if (psiType == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(13);
        }
        if (springModel == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(14);
        }
        if (resourceAnnotation == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(15);
        }
        if ((attributeValue = resourceAnnotation.findDeclaredAttributeValue("name")) != null) {
            SpringUastInjectionPointsAutowiringChecker.checkByNameAutowiring(attributeValue, holder, springModel, psiType);
        }
    }

    private static void checkByNameAutowiring(@NotNull PsiAnnotationMemberValue annotationMemberValue, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, @NotNull PsiType memberEffectiveType) {
        if (annotationMemberValue == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(16);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(17);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(18);
        }
        if (memberEffectiveType == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(19);
        }
        for (PsiReference reference : annotationMemberValue.getReferences()) {
            PsiConstantEvaluationHelper helper2;
            Object o;
            PsiElement element;
            if (reference instanceof SpringBeanReference) {
                SpringBeanReference sbReference = (SpringBeanReference)reference;
                SpringUastInjectionPointsAutowiringChecker.checkResourceBeanReference(holder, model, memberEffectiveType, reference, sbReference.getValue(), sbReference.isFactoryBeanRef());
                break;
            }
            if (!(reference instanceof PsiReferenceExpression) || !((element = reference.resolve()) instanceof PsiField) || !((o = (helper2 = JavaPsiFacade.getInstance((Project)element.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)((PsiField)element).getInitializer())) instanceof String)) continue;
            SpringUastInjectionPointsAutowiringChecker.checkResourceBeanReference(holder, model, memberEffectiveType, reference, (String)o, false);
        }
    }

    private static void checkResourceBeanReference(@NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, @NotNull PsiType memberEffectiveType, @NotNull PsiReference ref, @Nullable String beanName, boolean isFactoryBeanRef) {
        if (holder == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(20);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(21);
        }
        if (memberEffectiveType == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(22);
        }
        if (ref == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(23);
        }
        if (beanName != null) {
            SpringBeanPointer bean = SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName);
            if (bean != null) {
                Collection<PsiType> beanTypes = SpringUastInjectionPointsAutowiringChecker.getEffectiveBeanTypes(isFactoryBeanRef, bean);
                for (PsiType psiType : beanTypes) {
                    if (!SpringAutowireUtil.canBeAutowiredByType(memberEffectiveType, psiType)) continue;
                    return;
                }
                holder.registerProblem(ref, SpringBundle.message("cannot.autowire.bean.of.type", memberEffectiveType.getCanonicalText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                return;
            }
            if (SpringBeanResourceReference.resolveResourceByFqn((String)beanName, (CommonSpringModel)model, (Project)holder.getProject()) != null) {
                return;
            }
        }
        if (ref instanceof SpringBeanReference) {
            holder.registerProblem(ref);
        } else if (beanName != null) {
            holder.registerProblem(ref.getElement(), SpringApiBundle.message((String)"model.bean.error.message", (Object[])new Object[]{beanName}), new LocalQuickFix[0]);
        }
    }

    private static Collection<PsiType> getEffectiveBeanTypes(boolean factoryBeanRef, SpringBeanPointer<?> bean) {
        PsiClass beanClass;
        if (factoryBeanRef && (beanClass = bean.getBeanClass()) != null) {
            return List.of(PsiTypesUtil.getClassType((PsiClass)beanClass));
        }
        return bean.getEffectiveBeanTypes();
    }

    private static void checkQualifiedAutowiring(PsiType searchType, @NotNull UDeclaration uDeclaration, UAnnotation qualifiedAnnotation, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, boolean required) {
        PsiLanguageInjectionHost host;
        if (uDeclaration == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(24);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(25);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(26);
        }
        UExpression attributeValue = qualifiedAnnotation.findDeclaredAttributeValue("value");
        PsiAnnotation psiAnnotation = (PsiAnnotation)UElementKt.getAsJavaPsiElement((UElement)qualifiedAnnotation, PsiAnnotation.class);
        if (psiAnnotation == null) {
            return;
        }
        String name = SpringAutowireUtil.getQualifiedBeanName(psiAnnotation);
        SpringUastQualifierReference qreference = null;
        if (attributeValue instanceof ULiteralExpression && required && (host = UastLiteralUtils.getPsiLanguageInjectionHost((ULiteralExpression)((ULiteralExpression)attributeValue))) != null) {
            PsiReference[] references;
            for (PsiReference reference : references = host.getReferences()) {
                if (!(reference instanceof SpringUastQualifierReference) || (qreference = (SpringUastQualifierReference)reference).multiResolve(false).length != 0) continue;
                if (((PsiLanguageInjectionHost)qreference.getElement()).isPhysical()) {
                    holder.registerProblem((PsiReference)qreference, SpringBundle.message("bean.class.unknown.qualifier.bean", name), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                }
                return;
            }
        }
        Set<SpringBeanPointer<?>> beanPointers = SpringAutowireUtil.getQualifiedBeanPointers(psiAnnotation, model);
        PsiElement attributeValueSourcePsi = UElementKt.getSourcePsiElement((UElement)attributeValue);
        PsiElement annotationSourcePsi = UElementKt.getSourcePsiElement((UElement)qualifiedAnnotation);
        if (beanPointers.isEmpty() && required && !SpringUastInjectionPointsAutowiringChecker.isOptionalAutowiring(searchType, uDeclaration)) {
            if (attributeValueSourcePsi != null) {
                SpringUastInjectionPointsAutowiringChecker.reportProblem(holder, (PsiReference)qreference, attributeValueSourcePsi, SpringBundle.message("bean.class.unknown.qualifier.bean", name));
            } else {
                String qualifiedName = qualifiedAnnotation.getQualifiedName();
                assert (qualifiedName != null);
                if (annotationSourcePsi != null) {
                    SpringUastInjectionPointsAutowiringChecker.reportProblem(holder, (PsiReference)qreference, annotationSourcePsi, SpringBundle.message("cannot.find.bean.qualified.by", "@" + StringUtil.getShortName((String)qualifiedName)));
                }
            }
            return;
        }
        Set<SpringBeanPointer<?>> autowiredPointers = SpringAutowireUtil.filterPointersByAutowiredType(searchType, beanPointers);
        if (!beanPointers.isEmpty() && autowiredPointers.isEmpty() && SpringAutowireUtil.getIterableBeanPointers(searchType, model).isEmpty()) {
            PsiElement elementToReport;
            String message = SpringBundle.message("bean.class.autowired.incorrect.qualifier.type", searchType.getPresentableText());
            PsiElement psiElement = elementToReport = attributeValueSourcePsi == null ? annotationSourcePsi : attributeValueSourcePsi;
            if (elementToReport != null) {
                SpringUastInjectionPointsAutowiringChecker.reportProblem(holder, (PsiReference)qreference, elementToReport, message);
            }
        }
    }

    private static void reportProblem(@NotNull ProblemsHolder holder, @Nullable PsiReference qreference, @NotNull PsiElement attributeValue, @InspectionMessage String text) {
        if (holder == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(27);
        }
        if (attributeValue == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(28);
        }
        if (qreference == null) {
            holder.registerProblem(attributeValue, text, new LocalQuickFix[0]);
        } else {
            holder.registerProblem(qreference, text, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static void checkByTypeAutowire(UDeclaration psiNameIdentifierOwner, @NotNull PsiType searchType, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, boolean required) {
        UIdentifier uIdentifier;
        if (searchType == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(29);
        }
        if (holder == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(30);
        }
        if (model == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(31);
        }
        if ((uIdentifier = (UIdentifier)psiNameIdentifierOwner.getUastAnchor()) == null) {
            return;
        }
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uIdentifier);
        if (psiElement == null) {
            return;
        }
        if (psiElement.getTextRange().isEmpty()) {
            return;
        }
        String primaryCandidateName = uIdentifier.getName();
        Set<SpringBeanPointer<?>> beanPointers = SpringAutowireUtil.autowireByType(model, searchType, primaryCandidateName);
        if (!ProjectRootsUtil.isInTestSource((PsiFile)holder.getFile())) {
            beanPointers = SpringUastInjectionPointsAutowiringChecker.filterTestBeans(beanPointers);
        }
        Set<SpringBeanPointer<?>> iterableBeanPointers = SpringAutowireUtil.getIterableBeanPointers(searchType, model);
        if (beanPointers.isEmpty() && iterableBeanPointers.isEmpty() && required) {
            if (!(SpringAutowireUtil.isAutowiredByDefault(searchType) || SpringUastInjectionPointsAutowiringChecker.isOptionalAutowiring(searchType, psiNameIdentifierOwner) || InheritanceUtil.isInheritor((PsiType)searchType, (String)"java.util.Collection"))) {
                holder.registerProblem(psiElement, SpringUastInjectionPointsAutowiringChecker.getBeansNotFoundMessage(searchType), new LocalQuickFix[0]);
            }
        } else if (iterableBeanPointers.isEmpty() && beanPointers.size() > 1) {
            PsiJvmModifiersOwner modifierListOwner = (PsiJvmModifiersOwner)psiNameIdentifierOwner.getJavaPsi();
            if (modifierListOwner == null) {
                return;
            }
            Set<SpringBeanPointer<?>> filtered = SpringUastInjectionPointsAutowiringChecker.filterOverridenBeans(beanPointers);
            if ((filtered = SpringUastInjectionPointsAutowiringChecker.filterSelfReferencedBeans((PsiElement)modifierListOwner, filtered)).size() > 1) {
                filtered = SpringUastInjectionPointsAutowiringChecker.filterByUncheckedConversion(searchType, filtered);
            }
            if (filtered.size() > 1) {
                filtered = SpringUastInjectionPointsAutowiringChecker.filterConditionalBeans(model, filtered);
            }
            if (filtered.size() > 1) {
                filtered = SpringUastInjectionPointsAutowiringChecker.filterBeansFromDifferentContexts(filtered);
            }
            if (filtered.size() > 1) {
                if (SpringUastInjectionPointsAutowiringChecker.isNonDefinedActiveProfile(model.getActiveProfiles()) && SpringUastInjectionPointsAutowiringChecker.isAllBeansInDifferentProfiles(filtered)) {
                    return;
                }
                String annotation = SpringUastInjectionPointsAutowiringChecker.getQualifierAnnotation((PsiModifierListOwner)modifierListOwner);
                IntentionAction action2 = SpringUastInjectionPointsAutowiringChecker.createAddAnnotationAction(beanPointers, modifierListOwner, annotation);
                if (action2 != null) {
                    holder.registerProblem(psiElement, SpringUastInjectionPointsAutowiringChecker.getErrorMessage(searchType, filtered), new LocalQuickFix[]{new AddSpringBeanQualifierFix(beanPointers, annotation)});
                } else {
                    holder.registerProblem(psiElement, SpringUastInjectionPointsAutowiringChecker.getErrorMessage(searchType, filtered), new LocalQuickFix[0]);
                }
            }
        }
    }

    private static boolean isOptionalAutowiring(@NotNull PsiType searchType, UDeclaration psiNameIdentifierOwner) {
        if (searchType == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(32);
        }
        return SpringUastInjectionPointsAutowiringChecker.isObjectFactory(searchType) || SpringUastInjectionPointsAutowiringChecker.isInjectionPoint(searchType) || SpringAutowireUtil.isJavaUtilOptional(searchType) || SpringUastInjectionPointsAutowiringChecker.hasNullableAnnotation(psiNameIdentifierOwner);
    }

    private static boolean hasNullableAnnotation(@NotNull UDeclaration psiNameIdentifierOwner) {
        if (psiNameIdentifierOwner == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(33);
        }
        return psiNameIdentifierOwner.findAnnotation("org.springframework.lang.Nullable") != null;
    }

    @Nullable
    private static IntentionAction createAddAnnotationAction(Iterable<SpringBeanPointer<?>> beanPointers, PsiJvmModifiersOwner modifierListOwner, String annotation) {
        String beanQualifierName = ((StreamEx)StreamEx.of(beanPointers.iterator()).map(GenerateAutowiredDependenciesUtil::getQualifierName).nonNull().sorted()).findFirst().orElse("Unknown");
        CreateQualifierRequest annotationRequest = new CreateQualifierRequest((PsiModifierListOwner)modifierListOwner, annotation, beanQualifierName);
        List actions = JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)modifierListOwner, (AnnotationRequest)annotationRequest);
        return (IntentionAction)ContainerUtil.getFirstItem((List)actions);
    }

    @InspectionMessage
    private static String getBeansNotFoundMessage(@NotNull PsiType searchType) {
        PsiType secondarySearchType;
        if (searchType == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(34);
        }
        return (secondarySearchType = SpringAutowireUtil.getIterableSearchType(searchType)) != null ? SpringBundle.message("bean.autowiring.by.type.no.beans", secondarySearchType.getPresentableText(), searchType.getPresentableText()) : SpringBundle.message("bean.autowiring.by.type.none", searchType.getPresentableText());
    }

    private static boolean isObjectFactory(@NotNull PsiType type) {
        if (type == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(35);
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.ObjectFactory");
        }
        return false;
    }

    private static boolean isInjectionPoint(@NotNull PsiType type) {
        if (type == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(36);
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && "org.springframework.beans.factory.InjectionPoint".equals(psiClass.getQualifiedName());
        }
        return false;
    }

    @NotNull
    @InspectionMessage
    private static String getErrorMessage(@NotNull PsiType beanType, @Unmodifiable Set<SpringBeanPointer<?>> autowiredPointers) {
        if (beanType == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(37);
        }
        SortedList sortedByNamePointers = new SortedList(Pair.comparingByFirst());
        for (SpringBeanPointer<?> pointer : autowiredPointers) {
            sortedByNamePointers.add(Pair.create((Object)SpringPresentationProvider.getSpringBeanName(pointer), (Object)SpringPresentationProvider.getSpringBeanLocation(pointer)));
        }
        @NlsSafe StringBuilder sb = new StringBuilder();
        sb.append("<html><table>");
        sb.append("<tr><td>");
        sb.append(SpringBundle.message("bean.class.autowired.by.type", beanType.getPresentableText()));
        sb.append("</td></tr>");
        sb.append("<tr><td>");
        sb.append("<table>");
        sb.append("<tr><td valign='top'>Beans:</td>");
        sb.append("<td>");
        for (Pair pair : sortedByNamePointers) {
            sb.append((String)pair.first);
            sb.append("&nbsp;&nbsp; (");
            sb.append((String)pair.second);
            sb.append(")<br>");
        }
        sb.append("</td></tr>");
        sb.append("</table>");
        sb.append("</td></tr>");
        sb.append("</table></html>");
        String string = sb.toString();
        if (string == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private static @Unmodifiable Set<SpringBeanPointer<?>> filterSelfReferencedBeans(@NotNull PsiElement psiNameIdentifierOwner, @NotNull @Unmodifiable Set<SpringBeanPointer<?>> pointers) {
        PsiMethod psiMethod;
        if (psiNameIdentifierOwner == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(39);
        }
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(40);
        }
        if ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiNameIdentifierOwner, PsiMethod.class)) == null) {
            Set<SpringBeanPointer<?>> set = pointers;
            if (set == null) {
                SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(41);
            }
            return set;
        }
        LinkedHashSet filtered = new LinkedHashSet();
        for (SpringBeanPointer<?> pointer : pointers) {
            if (psiMethod.equals((Object)pointer.getSpringBean().getIdentifyingPsiElement())) continue;
            filtered.add(pointer);
        }
        LinkedHashSet linkedHashSet = filtered;
        if (linkedHashSet == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(42);
        }
        return linkedHashSet;
    }

    private static @Unmodifiable Set<SpringBeanPointer<?>> filterByUncheckedConversion(PsiType searchType, @Unmodifiable Set<SpringBeanPointer<?>> pointers) {
        LinkedHashSet filtered = new LinkedHashSet();
        block0: for (SpringBeanPointer<?> pointer : pointers) {
            for (PsiType psiType : pointer.getEffectiveBeanTypes()) {
                if (!TypeConversionUtil.isAssignable((PsiType)searchType, (PsiType)psiType, (boolean)false)) continue;
                filtered.add(pointer);
                continue block0;
            }
        }
        return filtered.isEmpty() ? pointers : filtered;
    }

    private static @Unmodifiable Set<SpringBeanPointer<?>> filterConditionalBeans(CommonSpringModel model, @Unmodifiable Set<SpringBeanPointer<?>> pointers) {
        if (pointers.isEmpty()) {
            return Collections.emptySet();
        }
        ConditionalEvaluationContextImpl context = new ConditionalEvaluationContextImpl(model);
        LinkedHashSet filtered = new LinkedHashSet();
        for (SpringBeanPointer<?> pointer : pointers) {
            if (pointer != null && !SpringConditionalUtils.isActive(pointer, context)) continue;
            filtered.add(pointer);
        }
        return filtered;
    }

    private static @Unmodifiable Set<SpringBeanPointer<?>> filterBeansFromDifferentContexts(@NotNull @Unmodifiable Set<SpringBeanPointer<?>> pointers) {
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(43);
        }
        Map byDescriptor = FactoryMap.create(descriptor -> new HashSet());
        SpringMultipleContextsManager contextsManager = SpringMultipleContextsManager.getInstance();
        for (Object pointer : pointers) {
            List<SpringContextDescriptor> pointerDescriptors = contextsManager.getAllContextDescriptors(pointer.getContainingFile());
            for (SpringContextDescriptor descriptor2 : pointerDescriptors) {
                ((Set)byDescriptor.get(descriptor2)).add(pointer);
            }
        }
        Collection arranged = byDescriptor.values();
        for (Set descriptorPointers : arranged) {
            if (descriptorPointers.size() <= 1) continue;
            return descriptorPointers;
        }
        Set filtered = (Set)ContainerUtil.getFirstItem(arranged);
        return filtered == null ? pointers : filtered;
    }

    private static boolean isAllBeansInDifferentProfiles(@NotNull Set<SpringBeanPointer<?>> pointers) {
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(44);
        }
        HashSet<String> names2 = new HashSet<String>();
        for (SpringBeanPointer<?> pointer : pointers) {
            CommonSpringBean bean = pointer.getSpringBean();
            for (String profileName : bean.getProfile().getExpressions()) {
                if (names2.contains(profileName)) {
                    return false;
                }
                names2.add(profileName);
            }
        }
        return true;
    }

    private static boolean isNonDefinedActiveProfile(@Nullable Set<String> activeProfiles) {
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            return true;
        }
        boolean isDefaultProfile = activeProfiles.size() <= SpringProfile.DEFAULT_PROFILE_NAMES.size() && SpringProfile.DEFAULT_PROFILE_NAMES.containsAll(activeProfiles);
        return !isDefaultProfile;
    }

    @NotNull
    private static @Unmodifiable Set<SpringBeanPointer<?>> filterOverridenBeans(@NotNull Set<SpringBeanPointer<?>> pointers) {
        if (pointers == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(45);
        }
        MultiMap names2 = new MultiMap();
        Set set = ContainerUtil.map2SetNotNull(pointers, pointer -> {
            boolean isOverriden = false;
            String name = pointer.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                VirtualFile containingFile = pointer.getContainingFile().getVirtualFile();
                if (names2.containsKey((Object)name) && !names2.values().contains(containingFile)) {
                    isOverriden = true;
                }
                names2.putValue((Object)name, (Object)containingFile);
            }
            return isOverriden ? null : pointer;
        });
        if (set == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(46);
        }
        return set;
    }

    @NotNull
    private static String getQualifierAnnotation(@Nullable PsiModifierListOwner psiModifierListOwner) {
        PsiMember psiMember;
        if (psiModifierListOwner != null && (psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiModifierListOwner, PsiMember.class, (boolean)false)) != null) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javax.inject.Inject", (int)1)) {
                return "javax.inject.Named";
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"jakarta.inject.Inject", (int)1)) {
                return "jakarta.inject.Named";
            }
        }
        return "org.springframework.beans.factory.annotation.Qualifier";
    }

    private static Set<SpringBeanPointer<?>> filterTestBeans(Set<SpringBeanPointer<?>> beanPointers) {
        return beanPointers.stream().filter(pointer -> !ProjectRootsUtil.isInTestSource((PsiFile)pointer.getContainingFile())).collect(Collectors.toSet());
    }

    private static Expression getQualifierNamesSuggestNamesExpression(UExpression psiLiteral, PsiLanguageInjectionHost host, @NotNull Collection<SpringBeanPointer<?>> beanPointers) {
        if (beanPointers == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(47);
        }
        PsiClass psiAnnoClass = SpringUastInjectionPointsAutowiringChecker.findAnnoPsiClass(psiLiteral);
        return SpringUastInjectionPointsAutowiringChecker.getQualifierNamesSuggestNamesExpression(host, beanPointers, psiAnnoClass);
    }

    @NotNull
    private static Expression getQualifierNamesSuggestNamesExpression(final PsiLanguageInjectionHost host, final @NotNull Collection<SpringBeanPointer<?>> beanPointers, final @Nullable PsiClass psiAnnoClass) {
        if (beanPointers == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(48);
        }
        return new Expression(){

            public Result calculateResult(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                return new TextResult(ElementManipulators.getValueText((PsiElement)host));
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                LinkedHashSet<LookupElement> items = new LinkedHashSet<LookupElement>();
                for (SpringBeanPointer pointer : beanPointers) {
                    CommonSpringBean bean = pointer.getSpringBean();
                    if (psiAnnoClass == null) continue;
                    for (SpringQualifier qualifier : bean.getSpringQualifiers()) {
                        String value = qualifier.getQualifierValue();
                        if (value == null || !(qualifier instanceof DefaultSpringBeanQualifier) && !Comparing.equal((Object)qualifier.getQualifierType(), (Object)psiAnnoClass)) continue;
                        items.add(SpringConverterUtil.createCompletionVariant((SpringBeanPointer)pointer, (String)value));
                    }
                }
                LookupElement[] elements = items.toArray(LookupElement.EMPTY_ARRAY);
                Arrays.sort(elements, Comparator.comparing(e -> e.getLookupString()));
                return elements;
            }
        };
    }

    @Nullable
    public static PsiClass findAnnoPsiClass(@NotNull UExpression expression) {
        kotlin.Pair annotationEntry;
        if (expression == null) {
            SpringUastInjectionPointsAutowiringChecker.$$$reportNull$$$0(49);
        }
        if ((annotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)expression)) == null) {
            return null;
        }
        return ((UAnnotation)annotationEntry.component1()).resolve();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 38, 41, 42, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModels";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uField";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 7: 
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uDeclaration";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceAnnotation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMemberValue";
                break;
            }
            case 18: 
            case 21: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberEffectiveType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiNameIdentifierOwner";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanType";
                break;
            }
            case 38: 
            case 41: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringChecker";
                break;
            }
            case 40: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointers";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringChecker";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSelfReferencedBeans";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOverridenBeans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNullableParameter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkInjectionPoint";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInitializedConstructorParameter";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceInjectionPoint";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkByNameAutowiring";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceBeanReference";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkQualifiedAutowiring";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkByTypeAutowire";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isOptionalAutowiring";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasNullableAnnotation";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getBeansNotFoundMessage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isObjectFactory";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isInjectionPoint";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 38: 
            case 41: 
            case 42: 
            case 46: {
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "filterSelfReferencedBeans";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "filterBeansFromDifferentContexts";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isAllBeansInDifferentProfiles";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "filterOverridenBeans";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierNamesSuggestNamesExpression";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findAnnoPsiClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 38, 41, 42, 46 -> new IllegalStateException(string);
        };
    }

    private static class AddSpringBeanQualifierFix
    implements LocalQuickFix {
        @FileModifier.SafeFieldForPreview
        private final Collection<SpringBeanPointer<?>> myBeanPointers;
        private final String myQualifierAnno;

        @Nullable
        private static UDeclaration getModifierListOwner(ProblemDescriptor descriptor) {
            PsiElement descriptorPsiElement = descriptor.getPsiElement();
            if (descriptorPsiElement == null) {
                return null;
            }
            UIdentifier uIdentifier = (UIdentifier)UastContextKt.toUElementOfExpectedTypes((PsiElement)descriptorPsiElement, (Class[])new Class[]{UIdentifier.class});
            if (uIdentifier == null) {
                return null;
            }
            UElement identifierUastParent = uIdentifier.getUastParent();
            return (UDeclaration)ObjectUtils.tryCast((Object)identifierUastParent, UDeclaration.class);
        }

        AddSpringBeanQualifierFix(@NotNull Collection<SpringBeanPointer<?>> beanPointers, @NotNull String qualifierAnno) {
            if (beanPointers == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(0);
            }
            if (qualifierAnno == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(1);
            }
            this.myBeanPointers = beanPointers;
            this.myQualifierAnno = qualifierAnno;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("SpringAutowiringInspection.add.qualifier.fix", new Object[0]);
            if (string == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            UDeclaration uDeclaration;
            if (project == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(4);
            }
            if ((uDeclaration = AddSpringBeanQualifierFix.getModifierListOwner(descriptor)) == null) {
                return;
            }
            PsiElement sourcePsi = uDeclaration.getSourcePsi();
            if (sourcePsi == null) {
                return;
            }
            if (!this.myBeanPointers.isEmpty()) {
                UExpression value;
                Editor editor = AddSpringBeanQualifierFix.getEditor(sourcePsi);
                UastSmartPointer myModifierListOwnerPointer = new UastSmartPointer((UElement)uDeclaration, UDeclaration.class);
                IntentionAction addAnnotationAction = SpringUastInjectionPointsAutowiringChecker.createAddAnnotationAction(this.myBeanPointers, (PsiJvmModifiersOwner)uDeclaration.getJavaPsi(), this.myQualifierAnno);
                if (addAnnotationAction == null) {
                    return;
                }
                addAnnotationAction.invoke(project, editor, sourcePsi.getContainingFile());
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                UDeclaration modifiedDeclaration = (UDeclaration)myModifierListOwnerPointer.getElement();
                if (modifiedDeclaration == null) {
                    return;
                }
                UAnnotation annotation = modifiedDeclaration.findAnnotation(this.myQualifierAnno);
                if (annotation != null && !IntentionPreviewUtils.isPreviewElement((PsiElement)sourcePsi) && (value = annotation.findDeclaredAttributeValue("value")) != null && UastLiteralUtils.isInjectionHost((UElement)value)) {
                    TemplateManager manager = TemplateManager.getInstance((Project)project);
                    Template template = this.createQualifierNameTemplate(value);
                    if (template != null) {
                        manager.startTemplate(editor, template);
                    }
                }
            }
        }

        @Nullable
        private Template createQualifierNameTemplate(@NotNull UExpression psiLiteral) {
            PsiElement sourcePsi;
            if (psiLiteral == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(5);
            }
            if ((sourcePsi = psiLiteral.getSourcePsi()) == null) {
                return null;
            }
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)sourcePsi.getContainingFile());
            if (!(psiLiteral instanceof UInjectionHost)) {
                return null;
            }
            UInjectionHost uInjectionHost = (UInjectionHost)psiLiteral;
            PsiLanguageInjectionHost host = uInjectionHost.getPsiLanguageInjectionHost();
            TextRange textRange = host.getTextRange();
            String valueText = ElementManipulators.getValueText((PsiElement)host);
            builder.replaceRange(TextRange.from((int)(textRange.getStartOffset() + 1), (int)valueText.length()), SpringUastInjectionPointsAutowiringChecker.getQualifierNamesSuggestNamesExpression(psiLiteral, host, this.myBeanPointers));
            return builder.buildInlineTemplate();
        }

        public static Editor getEditor(PsiElement modifierListOwner) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return FileEditorManager.getInstance((Project)modifierListOwner.getProject()).getSelectedTextEditor();
            }
            PsiFile psiFile = modifierListOwner.getContainingFile();
            Project project = psiFile.getProject();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            assert (virtualFile != null);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, 0), false);
            assert (editor != null);
            return editor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beanPointers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierAnno";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringChecker$AddSpringBeanQualifierFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiLiteral";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringChecker$AddSpringBeanQualifierFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createQualifierNameTemplate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class CreateQualifierRequest
    implements AnnotationRequest {
        private final String myQualifierAnno;
        private final SmartPsiElementPointer<PsiModifierListOwner> myModifierListOwnerPointer;
        private final List<AnnotationAttributeRequest> myAttributeRequests;

        CreateQualifierRequest(PsiModifierListOwner psiElement, String qualifierAnno, String beanPointerName) {
            this.myQualifierAnno = qualifierAnno;
            this.myModifierListOwnerPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer((PsiElement)psiElement);
            this.myAttributeRequests = Collections.singletonList(AnnotationAttributeValueRequestKt.stringAttribute((String)"value", (String)beanPointerName));
        }

        @NotNull
        public String getQualifiedName() {
            String string = this.myQualifierAnno;
            if (string == null) {
                CreateQualifierRequest.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public List<AnnotationAttributeRequest> getAttributes() {
            List<AnnotationAttributeRequest> list = this.myAttributeRequests;
            if (list == null) {
                CreateQualifierRequest.$$$reportNull$$$0(1);
            }
            return list;
        }

        public boolean isValid() {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)this.myModifierListOwnerPointer.getElement();
            if (modifierListOwner == null || !modifierListOwner.isValid()) {
                return false;
            }
            return modifierListOwner.getModifierList() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastInjectionPointsAutowiringChecker$CreateQualifierRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiedName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

