/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.profile.SpringContextProfile;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class SpringProfileExpressionInspection
extends SpringUastInspectionBase {
    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (uClass == null) {
            SpringProfileExpressionInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringProfileExpressionInspection.$$$reportNull$$$0(1);
        }
        if ((sourcePsi = uClass.getSourcePsi()) == null) {
            return null;
        }
        PsiClass psiClass = uClass.getJavaPsi();
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass)) {
            return null;
        }
        return SpringProfileExpressionInspection.checkProfile((PsiElement)psiClass, sourcePsi, manager, isOnTheFly);
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod uMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (uMethod == null) {
            SpringProfileExpressionInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SpringProfileExpressionInspection.$$$reportNull$$$0(3);
        }
        if ((sourcePsi = uMethod.getSourcePsi()) == null) {
            return null;
        }
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass psiClass = psiMethod.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass)) {
            return null;
        }
        return SpringProfileExpressionInspection.checkProfile((PsiElement)psiMethod, sourcePsi, manager, isOnTheFly);
    }

    private static ProblemDescriptor @Nullable [] checkProfile(PsiElement psiElement, PsiElement sourcePsi, InspectionManager manager, boolean isOnTheFly) {
        SpringContextProfile profile = (SpringContextProfile)JamService.getJamService((Project)sourcePsi.getProject()).getJamElement(SpringContextProfile.CONTEXT_PROFILE_JAM_KEY, psiElement);
        if (profile == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        for (JamStringAttributeElement attributeElement : profile.getValueElements()) {
            SpringProfileExpressionInspection.checkProfileAttribute(holder, (JamStringAttributeElement<String>)attributeElement);
        }
        return holder.getResultsArray();
    }

    private static void checkProfileAttribute(ProblemsHolder holder, JamStringAttributeElement<String> attributeElement) {
        UElement uElement = UastContextKt.toUElement((PsiElement)attributeElement.getPsiElement());
        if (uElement == null) {
            return;
        }
        PsiElement psiElement = uElement.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        try {
            SpringProfilesFactory.getInstance().parseProfileExpressions((Collection)new SmartList((Object)attributeElement.getStringValue()));
        }
        catch (SpringProfilesFactory.MalformedProfileExpressionException e) {
            holder.registerProblem(psiElement, e.getMessage(), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/profiles/SpringProfileExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

