/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trace.consent.runtime.listeners;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.DataSharingLocalSettingsChangeListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.trace.consent.policy.JBTraceConsentManager;
import com.intellij.platform.trace.consent.runtime.listeners.TraceLicenseStorage;
import com.intellij.platform.trace.consent.runtime.listeners.TraceStateEventSubscriberKt;
import com.intellij.platform.trace.consent.services.LicenseAwareTraceDataSharingServiceKt;
import com.intellij.platform.trace.consent.storage.logging.TraceStateFileEventLogger;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/trace/consent/runtime/listeners/TraceStateEventSubscriber;", "", "<init>", "()V", "lastConsentLicenseData", "Lcom/intellij/platform/trace/consent/runtime/listeners/TraceStateEventSubscriber$ConsentLicenseData;", "lastLicenseMetadata", "", "subscribeToTraceConsentAndLicenseChanges", "", "handleTraceConsentChange", "licensingFacade", "Lcom/intellij/ui/LicensingFacade;", "handleLicenseChange", "isTraceEnabled", "", "isTraceConsentChanged", "consentLicenseData", "extractLicenseData", "metadata", "ConsentLicenseData", "Companion", "intellij.platform.trace.consent"})
@SourceDebugExtension(value={"SMAP\nTraceStateEventSubscriber.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceStateEventSubscriber.kt\ncom/intellij/platform/trace/consent/runtime/listeners/TraceStateEventSubscriber\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,152:1\n42#2,3:153\n42#2,3:156\n42#2,3:159\n42#2,3:162\n13#3:165\n*S KotlinDebug\n*F\n+ 1 TraceStateEventSubscriber.kt\ncom/intellij/platform/trace/consent/runtime/listeners/TraceStateEventSubscriber\n*L\n52#1:153,3\n72#1:156,3\n80#1:159,3\n84#1:162,3\n116#1:165\n*E\n"})
public final class TraceStateEventSubscriber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ConsentLicenseData lastConsentLicenseData;
    private String lastLicenseMetadata;
    @NotNull
    private static final Logger LOG;
    private static final int METADATA_LICENSE_TYPE_FLAG_POSITION = 10;

    public TraceStateEventSubscriber() {
        this.subscribeToTraceConsentAndLicenseChanges();
    }

    private final void subscribeToTraceConsentAndLicenseChanges() {
        MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect();
        connection.subscribe(DataSharingLocalSettingsChangeListener.TOPIC, (Object)new DataSharingLocalSettingsChangeListener(this){
            final /* synthetic */ TraceStateEventSubscriber this$0;
            {
                this.this$0 = $receiver;
            }

            public void consentWritten() {
                block0: {
                    LicensingFacade licensingFacade = LicensingFacade.getInstance();
                    if (licensingFacade == null) break block0;
                    LicensingFacade licensingFacade2 = licensingFacade;
                    TraceStateEventSubscriber traceStateEventSubscriber = this.this$0;
                    LicensingFacade it = licensingFacade2;
                    boolean bl = false;
                    TraceStateEventSubscriber.access$handleTraceConsentChange(traceStateEventSubscriber, it);
                }
            }
        });
        Topic topic = LicensingFacade.LicenseStateListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> TraceStateEventSubscriber.subscribeToTraceConsentAndLicenseChanges$lambda$0(this, arg_0));
    }

    private final synchronized void handleTraceConsentChange(LicensingFacade licensingFacade) {
        block6: {
            Object object;
            Object object2 = this;
            try {
                TraceStateEventSubscriber $this$handleTraceConsentChange_u24lambda_u240 = object2;
                boolean bl = false;
                if (!$this$handleTraceConsentChange_u24lambda_u240.isTraceEnabled()) {
                    return;
                }
                ConsentLicenseData consentLicenseData = $this$handleTraceConsentChange_u24lambda_u240.extractLicenseData(licensingFacade.metadata);
                if (consentLicenseData == null) {
                    return;
                }
                ConsentLicenseData licenseData = consentLicenseData;
                Consent traceConsent = licenseData.getTraceConsent();
                if ($this$handleTraceConsentChange_u24lambda_u240.isTraceConsentChanged(licenseData)) {
                    boolean $i$f$service = false;
                    Class<TraceStateFileEventLogger> serviceClass$iv = TraceStateFileEventLogger.class;
                    Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object3 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    ((TraceStateFileEventLogger)object3).consentChanged(licenseData.isNonCommercial(), traceConsent.isAccepted());
                    $this$handleTraceConsentChange_u24lambda_u240.lastConsentLicenseData = licenseData;
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block6;
            Object throwable2 = object = throwable;
            boolean bl = false;
            LOG.warn("TRACE consent sync failed", (Throwable)throwable2);
        }
    }

    private final synchronized void handleLicenseChange(LicensingFacade licensingFacade) {
        block14: {
            Object object;
            Object object2 = this;
            try {
                boolean isLastLicenseMetadataInitialized;
                TraceStateEventSubscriber $this$handleLicenseChange_u24lambda_u240 = object2;
                boolean bl = false;
                if (!$this$handleLicenseChange_u24lambda_u240.isTraceEnabled()) {
                    return;
                }
                String string = licensingFacade.metadata;
                if (string == null) {
                    return;
                }
                String licenseMetadata = string;
                boolean bl2 = isLastLicenseMetadataInitialized = $this$handleLicenseChange_u24lambda_u240.lastLicenseMetadata != null;
                if (isLastLicenseMetadataInitialized) {
                    String string2 = $this$handleLicenseChange_u24lambda_u240.lastLicenseMetadata;
                    if (string2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lastLicenseMetadata");
                        string2 = null;
                    }
                    if (Intrinsics.areEqual((Object)licenseMetadata, (Object)string2)) {
                        return;
                    }
                }
                Character licenseType = StringsKt.getOrNull((CharSequence)licenseMetadata, (int)10);
                if (!isLastLicenseMetadataInitialized && licenseType != null) {
                    boolean $i$f$service = false;
                    Class<TraceLicenseStorage> serviceClass$iv = TraceLicenseStorage.class;
                    Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object3 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    if (Intrinsics.areEqual((Object)licenseType, (Object)((TraceLicenseStorage)object3).getLastUsedLicenseType())) {
                        $this$handleLicenseChange_u24lambda_u240.lastLicenseMetadata = licenseMetadata;
                        return;
                    }
                }
                ConsentLicenseData consentLicenseData = $this$handleLicenseChange_u24lambda_u240.extractLicenseData(licenseMetadata);
                if (consentLicenseData == null) {
                    return;
                }
                ConsentLicenseData licenseData = consentLicenseData;
                boolean $i$f$service = false;
                Class serviceClass$iv = TraceStateFileEventLogger.class;
                Object object4 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object4 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((TraceStateFileEventLogger)object4).licenseChanged(licenseData.isNonCommercial(), licenseData.getTraceConsent().isAccepted());
                $this$handleLicenseChange_u24lambda_u240.lastConsentLicenseData = licenseData;
                $this$handleLicenseChange_u24lambda_u240.lastLicenseMetadata = licenseMetadata;
                if (licenseType != null) {
                    $i$f$service = false;
                    serviceClass$iv = TraceLicenseStorage.class;
                    Object object5 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object5 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    ((TraceLicenseStorage)object5).setLastUsedLicenseType(licenseType);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block14;
            Object throwable2 = object = throwable;
            boolean bl = false;
            LOG.warn("TRACE license update failed", (Throwable)throwable2);
        }
    }

    private final boolean isTraceEnabled() {
        return new JBTraceConsentManager().isTraceConsentEnabled();
    }

    private final boolean isTraceConsentChanged(ConsentLicenseData consentLicenseData) {
        ConsentLicenseData consentLicenseData2 = this.lastConsentLicenseData;
        if (consentLicenseData2 == null) {
            return true;
        }
        ConsentLicenseData last = consentLicenseData2;
        return !Intrinsics.areEqual((Object)last.getTraceConsent().getId(), (Object)consentLicenseData.getTraceConsent().getId()) || last.getPermission() != consentLicenseData.getPermission();
    }

    private final ConsentLicenseData extractLicenseData(String metadata) {
        Object object = metadata;
        if (object == null || (object = StringsKt.getOrNull((CharSequence)((CharSequence)object), (int)10)) == null) {
            return null;
        }
        char licenseTypeFlag = ((Character)object).charValue();
        Pair pair = TraceStateEventSubscriberKt.access$resolveTraceConsent(licenseTypeFlag);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        Consent traceConsent = (Consent)pair2.component1();
        ConsentOptions.Permission permission = (ConsentOptions.Permission)pair2.component2();
        return new ConsentLicenseData(LicenseAwareTraceDataSharingServiceKt.isNonCommercialLicense(licenseTypeFlag), traceConsent, permission);
    }

    private static final void subscribeToTraceConsentAndLicenseChanges$lambda$0(TraceStateEventSubscriber this$0, LicensingFacade newState) {
        block0: {
            LicensingFacade licensingFacade = newState;
            if (licensingFacade == null) break block0;
            LicensingFacade it = licensingFacade;
            boolean bl = false;
            this$0.handleLicenseChange(it);
        }
    }

    public static final /* synthetic */ void access$handleTraceConsentChange(TraceStateEventSubscriber $this, LicensingFacade licensingFacade) {
        $this.handleTraceConsentChange(licensingFacade);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TraceStateEventSubscriber.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/trace/consent/runtime/listeners/TraceStateEventSubscriber$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "METADATA_LICENSE_TYPE_FLAG_POSITION", "", "intellij.platform.trace.consent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/trace/consent/runtime/listeners/TraceStateEventSubscriber$ConsentLicenseData;", "", "isNonCommercial", "", "traceConsent", "Lcom/intellij/ide/gdpr/Consent;", "permission", "Lcom/intellij/ide/gdpr/ConsentOptions$Permission;", "<init>", "(ZLcom/intellij/ide/gdpr/Consent;Lcom/intellij/ide/gdpr/ConsentOptions$Permission;)V", "()Z", "getTraceConsent", "()Lcom/intellij/ide/gdpr/Consent;", "getPermission", "()Lcom/intellij/ide/gdpr/ConsentOptions$Permission;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.trace.consent"})
    private static final class ConsentLicenseData {
        private final boolean isNonCommercial;
        @NotNull
        private final Consent traceConsent;
        @NotNull
        private final ConsentOptions.Permission permission;

        public ConsentLicenseData(boolean isNonCommercial, @NotNull Consent traceConsent, @NotNull ConsentOptions.Permission permission) {
            Intrinsics.checkNotNullParameter((Object)traceConsent, (String)"traceConsent");
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            this.isNonCommercial = isNonCommercial;
            this.traceConsent = traceConsent;
            this.permission = permission;
        }

        public final boolean isNonCommercial() {
            return this.isNonCommercial;
        }

        @NotNull
        public final Consent getTraceConsent() {
            return this.traceConsent;
        }

        @NotNull
        public final ConsentOptions.Permission getPermission() {
            return this.permission;
        }

        public final boolean component1() {
            return this.isNonCommercial;
        }

        @NotNull
        public final Consent component2() {
            return this.traceConsent;
        }

        @NotNull
        public final ConsentOptions.Permission component3() {
            return this.permission;
        }

        @NotNull
        public final ConsentLicenseData copy(boolean isNonCommercial, @NotNull Consent traceConsent, @NotNull ConsentOptions.Permission permission) {
            Intrinsics.checkNotNullParameter((Object)traceConsent, (String)"traceConsent");
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            return new ConsentLicenseData(isNonCommercial, traceConsent, permission);
        }

        public static /* synthetic */ ConsentLicenseData copy$default(ConsentLicenseData consentLicenseData, boolean bl, Consent consent, ConsentOptions.Permission permission, int n, Object object) {
            if ((n & 1) != 0) {
                bl = consentLicenseData.isNonCommercial;
            }
            if ((n & 2) != 0) {
                consent = consentLicenseData.traceConsent;
            }
            if ((n & 4) != 0) {
                permission = consentLicenseData.permission;
            }
            return consentLicenseData.copy(bl, consent, permission);
        }

        @NotNull
        public String toString() {
            return "ConsentLicenseData(isNonCommercial=" + this.isNonCommercial + ", traceConsent=" + this.traceConsent + ", permission=" + this.permission + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isNonCommercial);
            result = result * 31 + this.traceConsent.hashCode();
            result = result * 31 + this.permission.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConsentLicenseData)) {
                return false;
            }
            ConsentLicenseData consentLicenseData = (ConsentLicenseData)other;
            if (this.isNonCommercial != consentLicenseData.isNonCommercial) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.traceConsent, (Object)consentLicenseData.traceConsent)) {
                return false;
            }
            return this.permission == consentLicenseData.permission;
        }
    }
}

