/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.IntBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongPredicate;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.BaseStreamEx;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.EmitterSpliterator;
import one.util.streamex.EntryStream;
import one.util.streamex.IntCollector;
import one.util.streamex.Internals;
import one.util.streamex.LongStreamEx;
import one.util.streamex.PairSpliterator;
import one.util.streamex.PrefixOps;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamContext;
import one.util.streamex.StreamEx;
import one.util.streamex.TakeDrop;
import one.util.streamex.UnknownSizeSpliterator;
import one.util.streamex.VerSpec;

public final class IntStreamEx
extends BaseStreamEx<Integer, IntStream, Spliterator.OfInt, IntStreamEx>
implements IntStream {
    IntStreamEx(IntStream stream, StreamContext context) {
        super(stream, context);
    }

    IntStreamEx(Spliterator.OfInt spliterator, StreamContext context) {
        super(spliterator, context);
    }

    @Override
    IntStream createStream() {
        return StreamSupport.intStream((Spliterator.OfInt)this.spliterator, this.context.parallel);
    }

    private static IntStreamEx seq(IntStream stream) {
        return new IntStreamEx(stream, StreamContext.SEQUENTIAL);
    }

    IntStreamEx delegate(Spliterator.OfInt spliterator) {
        return new IntStreamEx(spliterator, this.context);
    }

    private <A> A collectSized(Supplier<A> supplier, ObjIntConsumer<A> accumulator, BiConsumer<A, A> combiner, IntFunction<A> sizedSupplier, ObjIntConsumer<A> sizedAccumulator) {
        Object intermediate;
        if (this.isParallel()) {
            return this.collect(supplier, accumulator, combiner);
        }
        Spliterator.OfInt spliterator = (Spliterator.OfInt)this.spliterator();
        int size = Internals.intSize(spliterator);
        if (size != -1) {
            intermediate = sizedSupplier.apply(size);
            spliterator.forEachRemaining(i -> sizedAccumulator.accept(intermediate, i));
        } else {
            intermediate = supplier.get();
            spliterator.forEachRemaining(i -> accumulator.accept(intermediate, i));
        }
        return intermediate;
    }

    @Override
    public IntStreamEx unordered() {
        return (IntStreamEx)super.unordered();
    }

    @Override
    public IntStreamEx onClose(Runnable closeHandler) {
        return (IntStreamEx)super.onClose(closeHandler);
    }

    @Override
    public IntStreamEx filter(IntPredicate predicate) {
        return new IntStreamEx(((IntStream)this.stream()).filter(predicate), this.context);
    }

    public IntStreamEx remove(IntPredicate predicate) {
        return this.filter(predicate.negate());
    }

    public boolean has(int value) {
        return this.anyMatch(x -> x == value);
    }

    public IntStreamEx without(int value) {
        return this.filter(val -> val != value);
    }

    public IntStreamEx without(int ... values) {
        if (values.length == 0) {
            return this;
        }
        if (values.length == 1) {
            return this.without(values[0]);
        }
        return this.filter(x -> {
            for (int val : values) {
                if (x != val) continue;
                return false;
            }
            return true;
        });
    }

    public IntStreamEx greater(int value) {
        return this.filter(val -> val > value);
    }

    public IntStreamEx atLeast(int value) {
        return this.filter(val -> val >= value);
    }

    public IntStreamEx less(int value) {
        return this.filter(val -> val < value);
    }

    public IntStreamEx atMost(int value) {
        return this.filter(val -> val <= value);
    }

    @Override
    public IntStreamEx map(IntUnaryOperator mapper) {
        return new IntStreamEx(((IntStream)this.stream()).map(mapper), this.context);
    }

    public <U> StreamEx<U> mapToObj(IntFunction<? extends U> mapper) {
        return new StreamEx<U>(((IntStream)this.stream()).mapToObj(mapper), this.context);
    }

    @Override
    public LongStreamEx mapToLong(IntToLongFunction mapper) {
        return new LongStreamEx(((IntStream)this.stream()).mapToLong(mapper), this.context);
    }

    @Override
    public DoubleStreamEx mapToDouble(IntToDoubleFunction mapper) {
        return new DoubleStreamEx(((IntStream)this.stream()).mapToDouble(mapper), this.context);
    }

    public <K, V> EntryStream<K, V> mapToEntry(IntFunction<? extends K> keyMapper, IntFunction<? extends V> valueMapper) {
        return new EntryStream(((IntStream)this.stream()).mapToObj((int t) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(t), valueMapper.apply(t))), this.context);
    }

    @Override
    public IntStreamEx flatMap(IntFunction<? extends IntStream> mapper) {
        return new IntStreamEx(((IntStream)this.stream()).flatMap(mapper), this.context);
    }

    public LongStreamEx flatMapToLong(IntFunction<? extends LongStream> mapper) {
        return new LongStreamEx(((IntStream)this.stream()).mapToObj(mapper).flatMapToLong(Function.identity()), this.context);
    }

    public DoubleStreamEx flatMapToDouble(IntFunction<? extends DoubleStream> mapper) {
        return new DoubleStreamEx(((IntStream)this.stream()).mapToObj(mapper).flatMapToDouble(Function.identity()), this.context);
    }

    public <R> StreamEx<R> flatMapToObj(IntFunction<? extends Stream<R>> mapper) {
        return new StreamEx(((IntStream)this.stream()).mapToObj(mapper).flatMap(Function.identity()), this.context);
    }

    public IntStreamEx intersperse(int delimiter) {
        return new IntStreamEx(((IntStream)this.stream()).flatMap((int s) -> IntStreamEx.of(delimiter, s)).skip(1L), this.context);
    }

    @Override
    public IntStreamEx distinct() {
        return new IntStreamEx(((IntStream)this.stream()).distinct(), this.context);
    }

    @Override
    public IntStreamEx sorted() {
        return new IntStreamEx(((IntStream)this.stream()).sorted(), this.context);
    }

    public IntStreamEx sorted(Comparator<Integer> comparator) {
        return new IntStreamEx(((IntStream)this.stream()).boxed().sorted(comparator).mapToInt(Integer::intValue), this.context);
    }

    public IntStreamEx reverseSorted() {
        IntUnaryOperator inv = x -> ~x;
        return new IntStreamEx(((IntStream)this.stream()).map(inv).sorted().map(inv), this.context);
    }

    public <V extends Comparable<? super V>> IntStreamEx sortedBy(IntFunction<V> keyExtractor) {
        return this.sorted(Comparator.comparing(keyExtractor::apply));
    }

    public IntStreamEx sortedByInt(IntUnaryOperator keyExtractor) {
        return this.sorted(Comparator.comparingInt(keyExtractor::applyAsInt));
    }

    public IntStreamEx sortedByLong(IntToLongFunction keyExtractor) {
        return this.sorted(Comparator.comparingLong(keyExtractor::applyAsLong));
    }

    public IntStreamEx sortedByDouble(IntToDoubleFunction keyExtractor) {
        return this.sorted(Comparator.comparingDouble(keyExtractor::applyAsDouble));
    }

    @Override
    public IntStreamEx peek(IntConsumer action) {
        return new IntStreamEx(((IntStream)this.stream()).peek(action), this.context);
    }

    public IntStreamEx peekFirst(IntConsumer action) {
        return this.mapFirst(x -> {
            action.accept(x);
            return x;
        });
    }

    public IntStreamEx peekLast(IntConsumer action) {
        return this.mapLast(x -> {
            action.accept(x);
            return x;
        });
    }

    @Override
    public IntStreamEx limit(long maxSize) {
        return new IntStreamEx(((IntStream)this.stream()).limit(maxSize), this.context);
    }

    @Override
    public IntStreamEx skip(long n) {
        return new IntStreamEx(((IntStream)this.stream()).skip(n), this.context);
    }

    @Override
    public void forEach(IntConsumer action) {
        if (this.spliterator != null && !this.isParallel()) {
            ((Spliterator.OfInt)this.spliterator()).forEachRemaining(action);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((IntStream)this.stream()).forEach(action);
                return null;
            });
        } else {
            ((IntStream)this.stream()).forEach(action);
        }
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        if (this.spliterator != null && !this.isParallel()) {
            ((Spliterator.OfInt)this.spliterator()).forEachRemaining(action);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((IntStream)this.stream()).forEachOrdered(action);
                return null;
            });
        } else {
            ((IntStream)this.stream()).forEachOrdered(action);
        }
    }

    @Override
    public int[] toArray() {
        if (this.context.fjp != null) {
            return this.context.terminate(((IntStream)this.stream())::toArray);
        }
        return ((IntStream)this.stream()).toArray();
    }

    public byte[] toByteArray() {
        return this.collectSized(Internals.ByteBuffer::new, Internals.ByteBuffer::add, Internals.ByteBuffer::addAll, Internals.ByteBuffer::new, Internals.ByteBuffer::addUnsafe).toArray();
    }

    public char[] toCharArray() {
        return this.collectSized(Internals.CharBuffer::new, Internals.CharBuffer::add, Internals.CharBuffer::addAll, Internals.CharBuffer::new, Internals.CharBuffer::addUnsafe).toArray();
    }

    public short[] toShortArray() {
        return this.collectSized(Internals.ShortBuffer::new, Internals.ShortBuffer::add, Internals.ShortBuffer::addAll, Internals.ShortBuffer::new, Internals.ShortBuffer::addUnsafe).toArray();
    }

    public BitSet toBitSet() {
        return this.collect(BitSet::new, BitSet::set, BitSet::or);
    }

    public InputStream asByteInputStream() {
        final Spliterator.OfInt spltr = (Spliterator.OfInt)this.spliterator();
        return new InputStream(){
            private int last;

            @Override
            public int read() {
                return spltr.tryAdvance(val -> {
                    this.last = val;
                }) ? this.last & 0xFF : -1;
            }

            @Override
            public void close() {
                IntStreamEx.this.close();
            }
        };
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        if (this.context.fjp != null) {
            return this.context.terminate(() -> ((IntStream)this.stream()).reduce(identity, op));
        }
        return ((IntStream)this.stream()).reduce(identity, op);
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        if (this.context.fjp != null) {
            return this.context.terminate(op, ((IntStream)this.stream())::reduce);
        }
        return ((IntStream)this.stream()).reduce(op);
    }

    public OptionalInt foldLeft(IntBinaryOperator accumulator) {
        Internals.PrimitiveBox b = new Internals.PrimitiveBox();
        this.forEachOrdered(t -> {
            if (b.b) {
                b.i = accumulator.applyAsInt(b.i, t);
            } else {
                b.i = t;
                b.b = true;
            }
        });
        return b.asInt();
    }

    public int foldLeft(int seed, IntBinaryOperator accumulator) {
        int[] box = new int[]{seed};
        this.forEachOrdered(t -> {
            box[0] = accumulator.applyAsInt(box[0], t);
        });
        return box[0];
    }

    public int[] scanLeft(IntBinaryOperator accumulator) {
        Spliterator.OfInt spliterator = (Spliterator.OfInt)this.spliterator();
        int size = Internals.intSize(spliterator);
        Internals.IntBuffer buf = new Internals.IntBuffer(size >= 0 ? size : 128);
        this.delegate(spliterator).forEachOrdered(i -> buf.add(buf.size == 0 ? i : accumulator.applyAsInt(buf.data[buf.size - 1], i)));
        return buf.toArray();
    }

    public int[] scanLeft(int seed, IntBinaryOperator accumulator) {
        return this.prepend(seed).scanLeft(accumulator);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> ((IntStream)this.stream()).collect(supplier, accumulator, combiner));
        }
        return ((IntStream)this.stream()).collect(supplier, accumulator, combiner);
    }

    public <A, R> R collect(IntCollector<A, R> collector) {
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return (R)this.collect(collector.supplier(), collector.intAccumulator(), collector.merger());
        }
        return collector.finisher().apply(this.collect(collector.supplier(), collector.intAccumulator(), collector.merger()));
    }

    @Override
    public int sum() {
        return this.reduce(0, Integer::sum);
    }

    @Override
    public OptionalInt min() {
        return this.reduce(Integer::min);
    }

    public OptionalInt min(Comparator<Integer> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) > 0 ? b : a);
    }

    public <V extends Comparable<? super V>> OptionalInt minBy(IntFunction<V> keyExtractor) {
        Internals.ObjIntBox result = this.collect(() -> new Internals.ObjIntBox<Object>(null, 0), (box, i) -> {
            Comparable val = Objects.requireNonNull((Comparable)keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) > 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) > 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalInt.empty() : OptionalInt.of(result.b);
    }

    public OptionalInt minByInt(IntUnaryOperator keyExtractor) {
        int[] result = this.collect(() -> new int[3], (acc, i) -> {
            int key = keyExtractor.applyAsInt(i);
            if (acc[2] == 0 || acc[1] > key) {
                acc[0] = i;
                acc[1] = key;
                acc[2] = 1;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1 && (acc1[2] == 0 || acc1[1] > acc2[1])) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1 ? OptionalInt.of(result[0]) : OptionalInt.empty();
    }

    public OptionalInt minByLong(IntToLongFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, i) -> {
            long key = keyExtractor.applyAsLong(i);
            if (!box.b || box.l > key) {
                box.b = true;
                box.l = key;
                box.i = i;
            }
        }, Internals.PrimitiveBox.MIN_LONG).asInt();
    }

    public OptionalInt minByDouble(IntToDoubleFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, i) -> {
            double key = keyExtractor.applyAsDouble(i);
            if (!box.b || Double.compare(box.d, key) > 0) {
                box.b = true;
                box.d = key;
                box.i = i;
            }
        }, Internals.PrimitiveBox.MIN_DOUBLE).asInt();
    }

    @Override
    public OptionalInt max() {
        return this.reduce(Integer::max);
    }

    public OptionalInt max(Comparator<Integer> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) >= 0 ? a : b);
    }

    public <V extends Comparable<? super V>> OptionalInt maxBy(IntFunction<V> keyExtractor) {
        Internals.ObjIntBox result = this.collect(() -> new Internals.ObjIntBox<Object>(null, 0), (box, i) -> {
            Comparable val = Objects.requireNonNull((Comparable)keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) < 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) < 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalInt.empty() : OptionalInt.of(result.b);
    }

    public OptionalInt maxByInt(IntUnaryOperator keyExtractor) {
        int[] result = this.collect(() -> new int[3], (acc, i) -> {
            int key = keyExtractor.applyAsInt(i);
            if (acc[2] == 0 || acc[1] < key) {
                acc[0] = i;
                acc[1] = key;
                acc[2] = 1;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1 && (acc1[2] == 0 || acc1[1] < acc2[1])) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1 ? OptionalInt.of(result[0]) : OptionalInt.empty();
    }

    public OptionalInt maxByLong(IntToLongFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, i) -> {
            long key = keyExtractor.applyAsLong(i);
            if (!box.b || box.l < key) {
                box.b = true;
                box.l = key;
                box.i = i;
            }
        }, Internals.PrimitiveBox.MAX_LONG).asInt();
    }

    public OptionalInt maxByDouble(IntToDoubleFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, i) -> {
            double key = keyExtractor.applyAsDouble(i);
            if (!box.b || Double.compare(box.d, key) < 0) {
                box.b = true;
                box.d = key;
                box.i = i;
            }
        }, Internals.PrimitiveBox.MAX_DOUBLE).asInt();
    }

    @Override
    public long count() {
        if (this.context.fjp != null) {
            return this.context.terminate(((IntStream)this.stream())::count);
        }
        return ((IntStream)this.stream()).count();
    }

    public long count(IntPredicate predicate) {
        return this.filter(predicate).count();
    }

    @Override
    public OptionalDouble average() {
        if (this.context.fjp != null) {
            return this.context.terminate(((IntStream)this.stream())::average);
        }
        return ((IntStream)this.stream()).average();
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return this.collect(IntSummaryStatistics::new, IntSummaryStatistics::accept, IntSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((IntStream)this.stream())::anyMatch);
        }
        return ((IntStream)this.stream()).anyMatch(predicate);
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((IntStream)this.stream())::allMatch);
        }
        return ((IntStream)this.stream()).allMatch(predicate);
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalInt findFirst() {
        if (this.context.fjp != null) {
            return this.context.terminate(((IntStream)this.stream())::findFirst);
        }
        return ((IntStream)this.stream()).findFirst();
    }

    public OptionalInt findFirst(IntPredicate predicate) {
        return this.filter(predicate).findFirst();
    }

    @Override
    public OptionalInt findAny() {
        if (this.context.fjp != null) {
            return this.context.terminate(((IntStream)this.stream())::findAny);
        }
        return ((IntStream)this.stream()).findAny();
    }

    public OptionalInt findAny(IntPredicate predicate) {
        return this.filter(predicate).findAny();
    }

    public OptionalLong indexOf(int value) {
        return ((AbstractStreamEx)this.boxed()).indexOf((? super T i) -> i == value);
    }

    public OptionalLong indexOf(IntPredicate predicate) {
        return ((AbstractStreamEx)this.boxed()).indexOf(predicate::test);
    }

    @Override
    public LongStreamEx asLongStream() {
        return new LongStreamEx(((IntStream)this.stream()).asLongStream(), this.context);
    }

    @Override
    public DoubleStreamEx asDoubleStream() {
        return new DoubleStreamEx(((IntStream)this.stream()).asDoubleStream(), this.context);
    }

    public StreamEx<Integer> boxed() {
        return new StreamEx<Integer>(((IntStream)this.stream()).boxed(), this.context);
    }

    @Override
    public IntStreamEx sequential() {
        return (IntStreamEx)super.sequential();
    }

    @Override
    public IntStreamEx parallel() {
        return (IntStreamEx)super.parallel();
    }

    @Override
    public IntStreamEx parallel(ForkJoinPool fjp) {
        return (IntStreamEx)super.parallel(fjp);
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return Spliterators.iterator((Spliterator.OfInt)this.spliterator());
    }

    public IntStreamEx append(int ... values) {
        if (values.length == 0) {
            return this;
        }
        return new IntStreamEx(IntStream.concat((IntStream)this.stream(), IntStream.of(values)), this.context);
    }

    public IntStreamEx append(IntStream other) {
        return new IntStreamEx(IntStream.concat((IntStream)this.stream(), other), this.context.combine(other));
    }

    public IntStreamEx prepend(int ... values) {
        if (values.length == 0) {
            return this;
        }
        return new IntStreamEx(IntStream.concat(IntStream.of(values), (IntStream)this.stream()), this.context);
    }

    public IntStreamEx prepend(IntStream other) {
        return new IntStreamEx(IntStream.concat(other, (IntStream)this.stream()), this.context.combine(other));
    }

    public <U> StreamEx<U> elements(U[] array) {
        return this.mapToObj((int idx) -> array[idx]);
    }

    public <U> StreamEx<U> elements(List<U> list) {
        return this.mapToObj(list::get);
    }

    public IntStreamEx elements(int[] array) {
        return this.map(idx -> array[idx]);
    }

    public LongStreamEx elements(long[] array) {
        return this.mapToLong(idx -> array[idx]);
    }

    public DoubleStreamEx elements(double[] array) {
        return this.mapToDouble(idx -> array[idx]);
    }

    public String charsToString() {
        return this.collect(StringBuilder::new, (sb, c) -> sb.append((char)c), StringBuilder::append).toString();
    }

    public String codePointsToString() {
        return this.collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public IntStreamEx pairMap(IntBinaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfInt(mapper, null, (Spliterator.OfInt)this.spliterator(), 0));
    }

    public String joining(CharSequence delimiter) {
        return this.collect(IntCollector.joining(delimiter));
    }

    public String joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.collect(IntCollector.joining(delimiter, prefix, suffix));
    }

    @Override
    public IntStreamEx takeWhile(IntPredicate predicate) {
        return VerSpec.VER_SPEC.callWhile(this, Objects.requireNonNull(predicate), false);
    }

    public IntStreamEx takeWhileInclusive(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return this.delegate(new TakeDrop.TDOfInt((Spliterator.OfInt)this.spliterator(), false, true, predicate));
    }

    @Override
    public IntStreamEx dropWhile(IntPredicate predicate) {
        return VerSpec.VER_SPEC.callWhile(this, Objects.requireNonNull(predicate), true);
    }

    public IntStreamEx mapFirst(IntUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfInt((a, b) -> b, mapper, (Spliterator.OfInt)this.spliterator(), 1));
    }

    public IntStreamEx mapLast(IntUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfInt((a, b) -> a, mapper, (Spliterator.OfInt)this.spliterator(), 2));
    }

    public IntStreamEx prefix(IntBinaryOperator op) {
        Spliterator.OfInt spltr = (Spliterator.OfInt)this.spliterator();
        return this.delegate(spltr.hasCharacteristics(16) ? new PrefixOps.OfInt(spltr, op) : new PrefixOps.OfUnordInt(spltr, op));
    }

    @Override
    public <U> U chain(Function<? super IntStreamEx, U> mapper) {
        return mapper.apply(this);
    }

    public static IntStreamEx empty() {
        return IntStreamEx.of(Spliterators.emptyIntSpliterator());
    }

    public static IntStreamEx of(int element) {
        return IntStreamEx.of(new ConstSpliterator.OfInt(element, 1L, true));
    }

    public static IntStreamEx of(int ... elements) {
        return IntStreamEx.of(Arrays.spliterator(elements));
    }

    public static IntStreamEx of(int[] array, int startInclusive, int endExclusive) {
        return IntStreamEx.of(Arrays.spliterator(array, startInclusive, endExclusive));
    }

    public static IntStreamEx of(byte ... elements) {
        return IntStreamEx.of(elements, 0, elements.length);
    }

    public static IntStreamEx of(byte[] array, int startInclusive, int endExclusive) {
        Internals.rangeCheck(array.length, startInclusive, endExclusive);
        return IntStreamEx.of(new RangeBasedSpliterator.OfByte(startInclusive, endExclusive, array));
    }

    public static IntStreamEx of(char ... elements) {
        return IntStreamEx.of(elements, 0, elements.length);
    }

    public static IntStreamEx of(char[] array, int startInclusive, int endExclusive) {
        Internals.rangeCheck(array.length, startInclusive, endExclusive);
        return IntStreamEx.of(new RangeBasedSpliterator.OfChar(startInclusive, endExclusive, array));
    }

    public static IntStreamEx of(short ... elements) {
        return IntStreamEx.of(elements, 0, elements.length);
    }

    public static IntStreamEx of(short[] array, int startInclusive, int endExclusive) {
        Internals.rangeCheck(array.length, startInclusive, endExclusive);
        return IntStreamEx.of(new RangeBasedSpliterator.OfShort(startInclusive, endExclusive, array));
    }

    public static IntStreamEx of(final InputStream is) {
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 272){

            @Override
            public boolean tryAdvance(IntConsumer action) {
                try {
                    int next = is.read();
                    if (next == -1) {
                        return false;
                    }
                    action.accept(next);
                    return true;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return IntStreamEx.of(spliterator).onClose(() -> {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static IntStreamEx of(Integer[] array) {
        return IntStreamEx.seq(Arrays.stream(array).mapToInt(Integer::intValue));
    }

    public static IntStreamEx of(IntBuffer buf) {
        return IntStreamEx.range(buf.position(), buf.limit()).map(buf::get);
    }

    public static <T> IntStreamEx ofIndices(List<T> list) {
        return IntStreamEx.range(list.size());
    }

    public static <T> IntStreamEx ofIndices(List<T> list, Predicate<T> predicate) {
        return IntStreamEx.seq(IntStream.range(0, list.size()).filter(i -> predicate.test(list.get(i))));
    }

    public static <T> IntStreamEx ofIndices(T[] array) {
        return IntStreamEx.range(array.length);
    }

    public static <T> IntStreamEx ofIndices(T[] array, Predicate<T> predicate) {
        return IntStreamEx.seq(IntStream.range(0, array.length).filter(i -> predicate.test(array[i])));
    }

    public static IntStreamEx ofIndices(int[] array) {
        return IntStreamEx.range(array.length);
    }

    public static IntStreamEx ofIndices(int[] array, IntPredicate predicate) {
        return IntStreamEx.seq(IntStream.range(0, array.length).filter(i -> predicate.test(array[i])));
    }

    public static IntStreamEx ofIndices(long[] array) {
        return IntStreamEx.range(array.length);
    }

    public static IntStreamEx ofIndices(long[] array, LongPredicate predicate) {
        return IntStreamEx.seq(IntStream.range(0, array.length).filter(i -> predicate.test(array[i])));
    }

    public static IntStreamEx ofIndices(double[] array) {
        return IntStreamEx.range(array.length);
    }

    public static IntStreamEx ofIndices(double[] array, DoublePredicate predicate) {
        return IntStreamEx.seq(IntStream.range(0, array.length).filter(i -> predicate.test(array[i])));
    }

    public static IntStreamEx of(IntStream stream) {
        return stream instanceof IntStreamEx ? (IntStreamEx)stream : new IntStreamEx(stream, StreamContext.of(stream));
    }

    public static IntStreamEx of(Spliterator.OfInt spliterator) {
        return new IntStreamEx(spliterator, StreamContext.SEQUENTIAL);
    }

    public static IntStreamEx of(PrimitiveIterator.OfInt iterator) {
        return IntStreamEx.of(new UnknownSizeSpliterator.USOfInt(iterator));
    }

    public static IntStreamEx of(OptionalInt optional) {
        return optional.isPresent() ? IntStreamEx.of(optional.getAsInt()) : IntStreamEx.empty();
    }

    public static IntStreamEx of(BitSet bitSet) {
        return IntStreamEx.seq(bitSet.stream());
    }

    public static IntStreamEx of(Collection<Integer> collection) {
        return IntStreamEx.seq(collection.stream().mapToInt(Integer::intValue));
    }

    public static IntStreamEx of(Random random) {
        return IntStreamEx.seq(random.ints());
    }

    public static IntStreamEx of(Random random, long streamSize) {
        return IntStreamEx.seq(random.ints(streamSize));
    }

    public static IntStreamEx of(Random random, int randomNumberOrigin, int randomNumberBound) {
        return IntStreamEx.seq(random.ints(randomNumberOrigin, randomNumberBound));
    }

    public static IntStreamEx of(Random random, long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return IntStreamEx.seq(random.ints(streamSize, randomNumberOrigin, randomNumberBound));
    }

    public static IntStreamEx ofChars(CharSequence seq) {
        return IntStreamEx.of(VerSpec.VER_SPEC.ofChars(seq));
    }

    public static IntStreamEx ofCodePoints(CharSequence seq) {
        return IntStreamEx.of(seq.codePoints());
    }

    public static IntStreamEx iterate(int seed, IntUnaryOperator f) {
        return IntStreamEx.iterate(seed, x -> true, f);
    }

    public static IntStreamEx iterate(final int seed, final IntPredicate predicate, final IntUnaryOperator f) {
        Objects.requireNonNull(f);
        Objects.requireNonNull(predicate);
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 1296){
            int prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(IntConsumer action) {
                int t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = f.applyAsInt(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!predicate.test(t)) {
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(IntConsumer action) {
                int t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                int n = t = this.started ? f.applyAsInt(this.prev) : seed;
                while (predicate.test(t)) {
                    action.accept(t);
                    t = f.applyAsInt(t);
                }
            }
        };
        return IntStreamEx.of(spliterator);
    }

    public static IntStreamEx generate(IntSupplier s) {
        return IntStreamEx.seq(IntStream.generate(s));
    }

    public static IntStreamEx produce(Predicate<IntConsumer> producer) {
        Internals.Box box = new Internals.Box();
        box.a = action -> producer.test(action) ? (IntEmitter)box.a : null;
        return box.a.stream();
    }

    public static IntStreamEx ints() {
        return IntStreamEx.seq(IntStream.range(0, Integer.MAX_VALUE));
    }

    public static IntStreamEx range(int endExclusive) {
        return IntStreamEx.seq(IntStream.range(0, endExclusive));
    }

    public static IntStreamEx range(int startInclusive, int endExclusive) {
        return IntStreamEx.seq(IntStream.range(startInclusive, endExclusive));
    }

    public static IntStreamEx range(int startInclusive, int endExclusive, int step) {
        int endInclusive = endExclusive - Integer.signum(step);
        if (endInclusive > endExclusive && step > 0 || endInclusive < endExclusive && step < 0) {
            return IntStreamEx.empty();
        }
        return IntStreamEx.rangeClosed(startInclusive, endInclusive, step);
    }

    public static IntStreamEx rangeClosed(int startInclusive, int endInclusive) {
        return IntStreamEx.seq(IntStream.rangeClosed(startInclusive, endInclusive));
    }

    public static IntStreamEx rangeClosed(int startInclusive, int endInclusive, int step) {
        if (step == 0) {
            throw new IllegalArgumentException("step = 0");
        }
        if (endInclusive == startInclusive) {
            return IntStreamEx.of(startInclusive);
        }
        if (step == 1) {
            return IntStreamEx.seq(IntStream.rangeClosed(startInclusive, endInclusive));
        }
        if (step == -1) {
            int sum = endInclusive + startInclusive;
            return IntStreamEx.seq(IntStream.rangeClosed(endInclusive, startInclusive).map(x -> sum - x));
        }
        if (endInclusive > startInclusive != step > 0) {
            return IntStreamEx.empty();
        }
        int limit = (endInclusive - startInclusive) * Integer.signum(step);
        limit = Integer.divideUnsigned(limit, Math.abs(step));
        return IntStreamEx.seq(IntStream.rangeClosed(0, limit).map(x -> x * step + startInclusive));
    }

    public static IntStreamEx constant(int value, long length) {
        return IntStreamEx.of(new ConstSpliterator.OfInt(value, length, false));
    }

    public static IntStreamEx zip(int[] first, int[] second, IntBinaryOperator mapper) {
        return IntStreamEx.of(new RangeBasedSpliterator.ZipInt(0, Internals.checkLength(first.length, second.length), mapper, first, second));
    }

    @FunctionalInterface
    public static interface IntEmitter {
        public IntEmitter next(IntConsumer var1);

        default public Spliterator.OfInt spliterator() {
            return new EmitterSpliterator.OfInt(this);
        }

        default public IntStreamEx stream() {
            return IntStreamEx.of(this.spliterator());
        }
    }
}

