/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSecurityRoleReferenceAnnotator
implements Annotator {
    public final void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            AbstractSecurityRoleReferenceAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AbstractSecurityRoleReferenceAnnotator.$$$reportNull$$$0(1);
        }
        if (holder.isBatchMode() || !this.isSecurityRoleReferenceOwner(element)) {
            return;
        }
        for (PsiReference reference : element.getReferences()) {
            if (!(reference instanceof SpringSecurityRolePsiReference)) continue;
            TextRange rangeInElement = reference.getRangeInElement();
            if (rangeInElement.isEmpty()) {
                return;
            }
            TextRange range = rangeInElement.shiftRight(element.getTextRange().getStartOffset());
            holder.newSilentAnnotation(HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY).range(range).textAttributes(DefaultLanguageHighlighterColors.HIGHLIGHTED_REFERENCE).create();
        }
    }

    protected abstract boolean isSecurityRoleReferenceOwner(PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/security/highlighting/AbstractSecurityRoleReferenceAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

