/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0003J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR&\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kubernetes/KubernetesCRDSpecProvider;", "", "<init>", "()V", "crdName", "", "getCrdName", "()Ljava/lang/String;", "crdVersion", "getCrdVersion", "crdSpecDirPath", "Ljava/nio/file/Path;", "getCrdSpecDirPath", "()Ljava/nio/file/Path;", "crdCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCrdCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "loadBundledSpec", "getCRDSpecs", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.clouds.kubernetes"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKubernetesCRDSpecProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesCRDSpecProvider.kt\ncom/intellij/kubernetes/KubernetesCRDSpecProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n1740#3,3:84\n*S KotlinDebug\n*F\n+ 1 KubernetesCRDSpecProvider.kt\ncom/intellij/kubernetes/KubernetesCRDSpecProvider\n*L\n71#1:84,3\n*E\n"})
public abstract class KubernetesCRDSpecProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path crdSpecDirPath;
    @NotNull
    private final ConcurrentHashMap<String, List<VirtualFile>> crdCache;
    @NotNull
    private static final ExtensionPointName<KubernetesCRDSpecProvider> EP_NAME = ExtensionPointName.Companion.create("com.intellij.kubernetes.crdSpecProvider");

    /*
     * WARNING - void declaration
     */
    public KubernetesCRDSpecProvider() {
        void specDir;
        String string = PathManager.getSystemPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSystemPath(...)");
        Object object = string;
        Object object2 = new String[]{"kubernetes", "crd-spec"};
        Path path = Paths.get((String)object, Arrays.copyOf(object2, ((String[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        object = path;
        object2 = object;
        KubernetesCRDSpecProvider kubernetesCRDSpecProvider = this;
        boolean bl = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists((Path)specDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectories((Path)specDir, new FileAttribute[0]);
        }
        kubernetesCRDSpecProvider.crdSpecDirPath = object;
        this.crdCache = new ConcurrentHashMap();
    }

    @NotNull
    protected abstract String getCrdName();

    @NotNull
    protected abstract String getCrdVersion();

    @NotNull
    protected final Path getCrdSpecDirPath() {
        return this.crdSpecDirPath;
    }

    @NotNull
    protected final ConcurrentHashMap<String, List<VirtualFile>> getCrdCache() {
        return this.crdCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresReadLockAbsence(generateAssertion=false)
    @RequiresBackgroundThread(generateAssertion=false)
    private final List<VirtualFile> loadBundledSpec() {
        ThreadingAssertions.softAssertBackgroundThread();
        String bundledCrdResourcePath = "com/intellij/kubernetes/crd/" + this.getCrdName() + "/" + this.getCrdVersion() + "/" + this.getCrdName() + ".yaml";
        Object object = ReflectionUtil.getGrandCallerClass();
        if (object == null || (object = ((Class)object).getClassLoader()) == null || (object = ((ClassLoader)object).getResourceAsStream(bundledCrdResourcePath)) == null) {
            return CollectionsKt.emptyList();
        }
        Object crdResourceStream = object;
        Path crdSpecFilePath = NioPathUtil.findOrCreateFile((Path)this.crdSpecDirPath, (String)(this.getCrdName() + ".yaml"));
        Closeable closeable = (Closeable)crdResourceStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Path path = crdSpecFilePath;
            byte[] byArray = it.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            byte[] byArray2 = byArray;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Files.write(path, byArray2, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        VirtualFile vFile = VirtualFileManager.getInstance().findFileByNioPath(crdSpecFilePath);
        if (vFile == null) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)vFile);
    }

    @NotNull
    public List<VirtualFile> getCRDSpecs(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (StringsKt.isBlank((CharSequence)this.getCrdName()) || StringsKt.isBlank((CharSequence)this.getCrdVersion())) {
            return CollectionsKt.emptyList();
        }
        List<VirtualFile> cachedFiles = this.crdCache.get(this.getCrdName());
        Collection collection = cachedFiles;
        if (!(collection == null || collection.isEmpty())) {
            boolean bl;
            block6: {
                Iterable $this$all$iv = cachedFiles;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        if (it.isValid()) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return cachedFiles;
            }
        }
        List<VirtualFile> bundledSpecs = this.loadBundledSpec();
        ((Map)this.crdCache).put(this.getCrdName(), bundledSpecs);
        return bundledSpecs;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/kubernetes/KubernetesCRDSpecProvider$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/kubernetes/KubernetesCRDSpecProvider;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<KubernetesCRDSpecProvider> getEP_NAME() {
            return EP_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

