/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.secret;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.secret.KeyValueEntry;
import com.intellij.kubernetes.view.ui.secret.SecretDataTable;
import com.intellij.kubernetes.view.ui.secret.SecretEntry;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Secret;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/view/ui/secret/KubernetesEditSecretDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "secret", "Lio/kubernetes/client/openapi/models/V1Secret;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "<init>", "(Lio/kubernetes/client/openapi/models/V1Secret;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;)V", "secretDataTable", "Lcom/intellij/kubernetes/view/ui/secret/SecretDataTable;", "secretData", "", "Lcom/intellij/kubernetes/view/ui/secret/SecretEntry;", "getSecretData", "()Ljava/util/List;", "getInitialSize", "Ljava/awt/Dimension;", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesEditSecretDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesEditSecretDialog.kt\ncom/intellij/kubernetes/view/ui/secret/KubernetesEditSecretDialog\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,48:1\n126#2:49\n153#2,3:50\n*S KotlinDebug\n*F\n+ 1 KubernetesEditSecretDialog.kt\ncom/intellij/kubernetes/view/ui/secret/KubernetesEditSecretDialog\n*L\n40#1:49\n40#1:50,3\n*E\n"})
public final class KubernetesEditSecretDialog
extends DialogWrapper {
    @NotNull
    private final V1Secret secret;
    @NotNull
    private final KubernetesApiModelInterface apiModel;
    private SecretDataTable secretDataTable;

    public KubernetesEditSecretDialog(@NotNull V1Secret secret, @NotNull KubernetesApiModelInterface apiModel2) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        super(apiModel2.getProject());
        this.secret = secret;
        this.apiModel = apiModel2;
        this.setTitle(KubernetesBundle.message("KubernetesEditSecretDialog.title", new Object[0]));
        this.setOKButtonText(KubernetesBundle.message("KubernetesEditSecretDialog.dialog.apply", new Object[0]));
        this.init();
        this.pack();
    }

    @NotNull
    public final List<SecretEntry> getSecretData() {
        SecretDataTable secretDataTable = this.secretDataTable;
        if (secretDataTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secretDataTable");
            secretDataTable = null;
        }
        return secretDataTable.getData();
    }

    @NotNull
    public Dimension getInitialSize() {
        return new Dimension(550, 600);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> KubernetesEditSecretDialog.createCenterPanel$lambda$0(this, arg_0));
    }

    private static final Unit createCenterPanel$lambda$0(KubernetesEditSecretDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = KubernetesBundle.message("KubernetesEditSecretDialog.secret.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> KubernetesEditSecretDialog.createCenterPanel$lambda$0$0(this$0, arg_0));
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        String string2 = KubernetesBundle.message("KubernetesEditSecretDialog.secret.stringData", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, KubernetesEditSecretDialog::createCenterPanel$lambda$0$1);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> KubernetesEditSecretDialog.createCenterPanel$lambda$0$2(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(KubernetesEditSecretDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        V1ObjectMeta v1ObjectMeta = this$0.secret.getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        String string = v1ObjectMeta.getName();
        Intrinsics.checkNotNull((Object)string);
        $this$row.label(string).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$0$2(KubernetesEditSecretDialog this$0, Row $this$row) {
        SecretDataTable secretDataTable;
        List secretData;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Map map2 = this$0.secret.getData();
        if (map2 != null) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = map2;
            boolean $i$f$map = false;
            Map map3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                String string = (String)k;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                byte[] byArray = (byte[])v;
                collection.add(new KeyValueEntry(string, new String(byArray, Charsets.UTF_8)));
            }
            v4 = (List)destination$iv$iv;
        } else {
            v4 = secretData = CollectionsKt.emptyList();
        }
        if ((secretDataTable = (this$0.secretDataTable = new SecretDataTable(secretData))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secretDataTable");
            secretDataTable = null;
        }
        $this$row.cell((JComponent)secretDataTable.createDecoratorPanel()).align(Align.FILL);
        return Unit.INSTANCE;
    }
}

