/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public enum ColorDeclarationType {
    RGB,
    RGBA,
    HSL,
    HSLA,
    LCH,
    OKLCH,
    LAB,
    OKLAB,
    GRAY,
    HWB,
    COLOR,
    COLORMIX,
    HEX,
    TEXTUAL;


    public static ColorDeclarationType fromColorTerm(@NotNull PsiElement colorTerm) {
        String colorString;
        if (colorTerm == null) {
            ColorDeclarationType.$$$reportNull$$$0(0);
        }
        if ((colorString = colorTerm.getText()).startsWith("rgba")) {
            return RGBA;
        }
        if (colorString.startsWith("rgb")) {
            return RGB;
        }
        if (colorString.startsWith("hsla")) {
            return HSLA;
        }
        if (colorString.startsWith("hsl")) {
            return HSL;
        }
        if (colorString.startsWith("lch")) {
            return LCH;
        }
        if (colorString.startsWith("oklch")) {
            return OKLCH;
        }
        if (colorString.startsWith("lab")) {
            return LAB;
        }
        if (colorString.startsWith("oklab")) {
            return OKLAB;
        }
        if (colorString.startsWith("gray")) {
            return GRAY;
        }
        if (colorString.startsWith("hwb")) {
            return HWB;
        }
        if (colorString.startsWith("color-mix")) {
            return COLORMIX;
        }
        if (colorString.startsWith("color")) {
            return COLOR;
        }
        if (StringUtil.startsWithChar((CharSequence)colorString, (char)'#')) {
            return HEX;
        }
        return TEXTUAL;
    }

    public boolean withAlphaChannel() {
        return this == RGBA || this == HSLA || this == GRAY || this == HWB || this == COLOR || this == LCH || this == OKLCH || this == COLORMIX;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorTerm", "com/intellij/psi/css/browse/ColorDeclarationType", "fromColorTerm"));
    }
}

