/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.execution.impl.ConsoleTokenUtil;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.jetbrains.nodeJs.NodeChromeDebugProcess;
import com.jetbrains.nodeJs.NodeChromeDebugProcessKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003\u001a\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\u001a;\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00110\u0017H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PROCESS_CONSOLE_ID", "", "JS_LANGUAGE_CONSOLE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/ui/ConsoleView;", "getNewChildProcessDebugPort", "", "stderr", "NODE8_PREFIX", "CHILD_PROCESS_DEBUGGER_LISTENING_PREFIXES", "", "[Ljava/lang/String;", "parseNode8Port", "line", "listenForDebugPortOpening", "", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "port", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nNodeChromeDebugProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeChromeDebugProcess.kt\ncom/jetbrains/nodeJs/NodeChromeDebugProcessKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,278:1\n13#2:279\n*S KotlinDebug\n*F\n+ 1 NodeChromeDebugProcess.kt\ncom/jetbrains/nodeJs/NodeChromeDebugProcessKt\n*L\n53#1:279\n*E\n"})
public final class NodeChromeDebugProcessKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String PROCESS_CONSOLE_ID = "js.console.node.process.id";
    @NotNull
    private static final Key<ConsoleView> JS_LANGUAGE_CONSOLE_KEY;
    @NotNull
    private static final String NODE8_PREFIX = "Debugger listening on ws://";
    @NotNull
    private static final String[] CHILD_PROCESS_DEBUGGER_LISTENING_PREFIXES;

    public static final int getNewChildProcessDebugPort(@NotNull String stderr) {
        Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
        for (String string : CHILD_PROCESS_DEBUGGER_LISTENING_PREFIXES) {
            Intrinsics.checkNotNull((Object)string);
            String prefix = string;
            if (!StringsKt.contains$default((CharSequence)stderr, (CharSequence)prefix, (boolean)false, (int)2, null)) continue;
            if (Intrinsics.areEqual((Object)NODE8_PREFIX, (Object)prefix)) {
                return NodeChromeDebugProcessKt.parseNode8Port(stderr);
            }
            String string2 = stderr.substring(prefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            char[] cArray = new char[]{'\n', '.'};
            Integer n = StringsKt.toIntOrNull((String)StringsKt.trimEnd((String)string2, (char[])cArray));
            return n != null ? n : -1;
        }
        return -1;
    }

    private static final int parseNode8Port(String line) {
        int endIndex = StringsKt.indexOf$default((CharSequence)line, (char)'/', (int)(StringsKt.indexOf$default((CharSequence)line, (String)NODE8_PREFIX, (int)0, (boolean)false, (int)6, null) + 27), (boolean)false, (int)4, null);
        if (endIndex > 0) {
            int startIndex = StringsKt.lastIndexOf$default((CharSequence)line, (char)':', (int)(endIndex - 1), (boolean)false, (int)4, null);
            String string = line.substring(startIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Integer n = StringsKt.toIntOrNull((String)string);
            return n != null ? n : -1;
        }
        return -1;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static final void listenForDebugPortOpening(@NotNull ProcessHandler processHandler, @NotNull Disposable parentDisposable, @NotNull Function1<? super Integer, Unit> handler2) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        processHandler.addProcessListener(new ProcessListener(handler2){
            private final StringBuilder stdOut;
            private final StringBuilder stdErr;
            private final AnsiEscapeDecoder decoder;
            final /* synthetic */ Function1<Integer, Unit> $handler;
            {
                this.$handler = $handler;
                this.stdOut = new StringBuilder();
                this.stdErr = new StringBuilder();
                this.decoder = new AnsiEscapeDecoder();
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (ProcessOutputType.isStderr(outputType)) {
                    stringBuilder = this.stdErr;
                } else if (ProcessOutputType.isStdout(outputType)) {
                    stringBuilder = this.stdOut;
                } else {
                    return;
                }
                StringBuilder buffer = stringBuilder;
                this.decoder.escapeText(event.getText(), outputType, (arg_0, arg_1) -> listenForDebugPortOpening.1.onTextAvailable$lambda$0(buffer, arg_0, arg_1));
                int index = StringsKt.lastIndexOf$default((CharSequence)buffer, (char)'\n', (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    return;
                }
                CharSequence charSequence = buffer.subSequence(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
                Sequence $this$forEach$iv = StringsKt.lineSequence((CharSequence)charSequence);
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    StringBuilder line = new StringBuilder(it);
                    ConsoleTokenUtil.normalizeBackspaceCharacters((StringBuilder)line);
                    String string = line.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    this.readErrLine(string);
                }
                buffer.delete(0, index + 1);
            }

            public final void readErrLine(String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                int newDebugPort = NodeChromeDebugProcessKt.getNewChildProcessDebugPort(line);
                if (newDebugPort != -1) {
                    this.$handler.invoke((Object)newDebugPort);
                }
            }

            private static final void onTextAvailable$lambda$0(StringBuilder $buffer, String text, Key key) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)key, (String)"<unused var>");
                $buffer.append(text);
            }
        }, parentDisposable);
    }

    public static final /* synthetic */ Key access$getJS_LANGUAGE_CONSOLE_KEY$p() {
        return JS_LANGUAGE_CONSOLE_KEY;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NodeChromeDebugProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"js.language.debugger.console.view");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JS_LANGUAGE_CONSOLE_KEY = key;
        String[] stringArray = new String[]{"Debugger listening on port ", "Debugger listening on [::]:", NODE8_PREFIX};
        CHILD_PROCESS_DEBUGGER_LISTENING_PREFIXES = stringArray;
    }
}

