/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl.remoteSdk;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CannotLoadCredentialsException;
import com.intellij.util.ObjectUtils;
import com.intellij.wsl.remoteSdk.WSLBundle;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WSLCredentialsHolder {
    private static final String DISTRIBUTION_ID = "DISTRIBUTION_ID";
    @Nullable
    private String myDistributionId;

    @NotNull
    public static WSLCredentialsHolder create(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(0);
        }
        WSLCredentialsHolder result = new WSLCredentialsHolder();
        result.setDistributionId(distribution.getId());
        WSLCredentialsHolder wSLCredentialsHolder = result;
        if (wSLCredentialsHolder == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(1);
        }
        return wSLCredentialsHolder;
    }

    @NotNull
    String requireNotNullDistributionId() {
        if (this.myDistributionId == null) {
            throw new RuntimeException("Invoked get before initializing");
        }
        String string = this.myDistributionId;
        if (string == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(2);
        }
        return string;
    }

    void setDistributionId(@NotNull String distributionId) {
        if (distributionId == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(3);
        }
        this.myDistributionId = distributionId;
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(4);
        }
        if (this.myDistributionId == null) {
            throw new RuntimeException("Invoked save before initializing");
        }
        rootElement.setAttribute(DISTRIBUTION_ID, this.myDistributionId);
    }

    public void load(@NotNull Element rootElement) throws CannotLoadCredentialsException {
        String value;
        if (rootElement == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(5);
        }
        if ((value = rootElement.getAttributeValue(DISTRIBUTION_ID)) == null) {
            throw new CannotLoadCredentialsException("Broken configuration: no distribution id");
        }
        this.myDistributionId = WSLUtil.getMsId((String)value);
    }

    @NotNull
    public WSLDistribution getDistribution() {
        WSLDistribution wSLDistribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(this.requireNotNullDistributionId());
        if (wSLDistribution == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(6);
        }
        return wSLDistribution;
    }

    @NotNull
    public static WSLCredentialsHolder get(@NotNull RemoteSdkAdditionalData sdkAdditionalData) throws ConfigurationException {
        Object credentials;
        if (sdkAdditionalData == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(7);
        }
        if ((credentials = sdkAdditionalData.connectionCredentials().getCredentials()) instanceof WSLCredentialsHolder) {
            WSLCredentialsHolder wSLCredentialsHolder = (WSLCredentialsHolder)credentials;
            if (wSLCredentialsHolder == null) {
                WSLCredentialsHolder.$$$reportNull$$$0(8);
            }
            return wSLCredentialsHolder;
        }
        throw new ConfigurationException(WSLBundle.message("dialog.message.wsl.credentials.expected", credentials));
    }

    @Nullable
    public static WSLDistribution getDistribution(@Nullable SdkAdditionalData sdkAdditionalData) {
        if (!(sdkAdditionalData instanceof RemoteSdkAdditionalData)) {
            return null;
        }
        WSLCredentialsHolder wslCredentialsHolder = (WSLCredentialsHolder)ObjectUtils.tryCast((Object)((RemoteSdkAdditionalData)sdkAdditionalData).connectionCredentials().getCredentials(), WSLCredentialsHolder.class);
        return wslCredentialsHolder == null ? null : wslCredentialsHolder.getDistribution();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WSLCredentialsHolder)) {
            return false;
        }
        WSLCredentialsHolder holder = (WSLCredentialsHolder)o;
        return Objects.equals(this.myDistributionId, holder.myDistributionId);
    }

    public int hashCode() {
        return Objects.hashCode(this.myDistributionId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/wsl/remoteSdk/WSLCredentialsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/wsl/remoteSdk/WSLCredentialsHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotNullDistributionId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistribution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDistributionId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 8 -> new IllegalStateException(string);
        };
    }
}

