/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagnostic;

import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticMonitorFiles;
import com.intellij.database.diagnostic.DiagnosticMonitorInternals;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0006J \u0010 \u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0013J&\u0010 \u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010!\u001a\u00020\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130$J\"\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u00072\b\b\u0002\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0013H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/database/diagnostic/DiagnosticMonitor;", "", "<init>", "()V", "recorders", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/database/diagnostic/DataSourceDiagnosticRecorder;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "startRecordingDataSource", "", "ds", "Lcom/intellij/database/model/DasDataSource;", "introspectionContext", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "initNewRecorder", "formDataSourceAbbreviation", "", "isRecordingDataSource", "", "dsId", "stopRecordingDataSource", "showMessageThatRecordingIsStarted", "filePath", "Ljava/nio/file/Path;", "showMessageThatRecordingIsStopped", "notifyUserAboutRecording", "eventType", "Lcom/intellij/database/introspection/DBIntrospectionContext$DiagnosticNotificationEventType;", "getRecorder", "record", "withStack", "message", "messageMaker", "Lkotlin/Function0;", "recordTo", "recorder", "intellij.database.core.impl"})
public final class DiagnosticMonitor {
    @NotNull
    public static final DiagnosticMonitor INSTANCE = new DiagnosticMonitor();
    @NotNull
    private static final ConcurrentHashMap<String, DataSourceDiagnosticRecorder> recorders = new ConcurrentHashMap();
    @NotNull
    private static final Logger logger;

    private DiagnosticMonitor() {
    }

    public final void startRecordingDataSource(@NotNull DasDataSource ds, @NotNull DBIntrospectionContext introspectionContext) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)introspectionContext, (String)"introspectionContext");
        recorders.computeIfAbsent(ds.getUniqueId(), arg_0 -> DiagnosticMonitor.startRecordingDataSource$lambda$1(arg_0 -> DiagnosticMonitor.startRecordingDataSource$lambda$0(ds, introspectionContext, arg_0), arg_0));
    }

    private final DataSourceDiagnosticRecorder initNewRecorder(DasDataSource ds, DBIntrospectionContext introspectionContext) {
        long beginTime = System.currentTimeMillis();
        CharSequence infix = this.formDataSourceAbbreviation(ds);
        Path path = DiagnosticMonitorFiles.INSTANCE.prepareEmptyDiagnosticSessionFilePath(beginTime, infix);
        DataSourceDiagnosticRecorder recorder = new DataSourceDiagnosticRecorder(introspectionContext, path);
        try {
            recorder.makeHeader(ds, beginTime);
            this.showMessageThatRecordingIsStarted(introspectionContext, ds, path);
            return recorder;
        }
        catch (Throwable e) {
            recorder.close();
            throw e;
        }
    }

    private final CharSequence formDataSourceAbbreviation(DasDataSource ds) {
        String string = ds.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String dsName = string;
        StringBuilder b = new StringBuilder();
        int g = 0;
        int n = dsName.length();
        for (int j = 0; j < n; ++j) {
            char c2 = dsName.charAt(j);
            if (Character.isLetterOrDigit(c2)) {
                b.append(c2);
            }
            if (!Character.isUpperCase(c2)) continue;
            ++g;
        }
        int n2 = b.length();
        if (g >= n2 / 2) {
            for (int i2 = 1; i2 < n2; ++i2) {
                b.setCharAt(i2, Character.toLowerCase(b.charAt(i2)));
            }
        }
        if (n2 == 0) {
            b.append(ds.getDbms().getName());
        }
        return b;
    }

    public final boolean isRecordingDataSource(@NotNull String dsId) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        return recorders.containsKey(dsId);
    }

    public final void stopRecordingDataSource(@NotNull DasDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        DataSourceDiagnosticRecorder recorder = recorders.remove(ds.getUniqueId());
        if (recorder != null) {
            recorder.recordFlow("Ending the diagnostic session.");
            recorder.close();
            this.showMessageThatRecordingIsStopped(recorder.getIntrospectionContext(), ds, recorder.getFilePath());
        }
    }

    private final void showMessageThatRecordingIsStarted(DBIntrospectionContext introspectionContext, DasDataSource ds, Path filePath) {
        logger.info("Diagnostic is started for data source " + ds.getName() + ". Log file: " + ((Object)filePath.toAbsolutePath()).toString());
        this.notifyUserAboutRecording(introspectionContext, ds, DBIntrospectionContext.DiagnosticNotificationEventType.DIAGNOSTIC_STARTED, filePath);
    }

    private final void showMessageThatRecordingIsStopped(DBIntrospectionContext introspectionContext, DasDataSource ds, Path filePath) {
        logger.info("Diagnostic is stopped for data source " + ds.getName() + ". Log file: " + ((Object)filePath.toAbsolutePath()).toString());
        this.notifyUserAboutRecording(introspectionContext, ds, DBIntrospectionContext.DiagnosticNotificationEventType.DIAGNOSTIC_STOPPED, filePath);
    }

    private final void notifyUserAboutRecording(DBIntrospectionContext introspectionContext, DasDataSource ds, DBIntrospectionContext.DiagnosticNotificationEventType eventType, Path filePath) {
        String string = ds.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        DBIntrospectionContext.UserNotifier notifier = introspectionContext.getUserNotifier(string);
        notifier.notifyDiagnosticMonitorFile(eventType, filePath);
    }

    @Nullable
    public final DataSourceDiagnosticRecorder getRecorder(@NotNull String dsId) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        return recorders.get(dsId);
    }

    public final void record(@NotNull String dsId, boolean withStack, @NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = recorders.get(dsId);
        if (dataSourceDiagnosticRecorder == null) {
            return;
        }
        DataSourceDiagnosticRecorder recorder = dataSourceDiagnosticRecorder;
        this.recordTo(recorder, withStack, message);
    }

    public static /* synthetic */ void record$default(DiagnosticMonitor diagnosticMonitor, String string, boolean bl, CharSequence charSequence, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        diagnosticMonitor.record(string, bl, charSequence);
    }

    public final void record(@NotNull String dsId, boolean withStack, @NotNull Function0<? extends CharSequence> messageMaker) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        Intrinsics.checkNotNullParameter(messageMaker, (String)"messageMaker");
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = recorders.get(dsId);
        if (dataSourceDiagnosticRecorder == null) {
            return;
        }
        DataSourceDiagnosticRecorder recorder = dataSourceDiagnosticRecorder;
        CharSequence message = (CharSequence)messageMaker.invoke();
        this.recordTo(recorder, withStack, message);
    }

    public static /* synthetic */ void record$default(DiagnosticMonitor diagnosticMonitor, String string, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        diagnosticMonitor.record(string, bl, (Function0<? extends CharSequence>)function0);
    }

    private final void recordTo(DataSourceDiagnosticRecorder recorder, boolean withStack, CharSequence message) {
        CharSequence msg = message;
        if (withStack) {
            StringBuilder b = new StringBuilder(256);
            StringBuilder stringBuilder = b.append(message);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringFun.appendLineIfNo((StringBuilder)stringBuilder);
            DiagnosticMonitorInternals.addStackTraceInto(b);
            msg = b;
        }
        recorder.recordFlow(msg);
    }

    static /* synthetic */ void recordTo$default(DiagnosticMonitor diagnosticMonitor, DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder, boolean bl, CharSequence charSequence, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        diagnosticMonitor.recordTo(dataSourceDiagnosticRecorder, bl, charSequence);
    }

    private static final DataSourceDiagnosticRecorder startRecordingDataSource$lambda$0(DasDataSource $ds, DBIntrospectionContext $introspectionContext, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.initNewRecorder($ds, $introspectionContext);
    }

    private static final DataSourceDiagnosticRecorder startRecordingDataSource$lambda$1(Function1 $tmp0, Object p0) {
        return (DataSourceDiagnosticRecorder)$tmp0.invoke(p0);
    }

    static {
        Logger logger2 = Logger.getInstance(DiagnosticMonitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }
}

