/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasColumniationType;
import com.intellij.database.types.DasScope;
import com.intellij.database.types.DasSimpleScope;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/intellij/database/types/DasRecordTypeBase;", "Lcom/intellij/database/types/DasTableType;", "Lcom/intellij/database/types/DasColumniationType;", "columns", "", "Lcom/intellij/database/model/DasTypedObject;", "<init>", "(Ljava/lang/Iterable;)V", "columnScope", "Lcom/intellij/database/types/DasScope;", "getColumnScope", "getColumnCount", "", "getColumnName", "", "i", "getColumnDasType", "Lcom/intellij/database/types/DasType;", "equals", "", "other", "", "hashCode", "prefix", "getPrefix", "()Ljava/lang/String;", "leftParen", "getLeftParen", "rightParen", "getRightParen", "renderColumn", "name", "type", "getDescription", "toDataType", "Lcom/intellij/database/model/DataType;", "intellij.database.core.impl"})
public abstract class DasRecordTypeBase
implements DasTableType,
DasColumniationType {
    @NotNull
    private final DasScope<DasTypedObject> columnScope;

    public DasRecordTypeBase(@NotNull Iterable<? extends DasTypedObject> columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columnScope = new DasSimpleScope(CollectionsKt.toList(columns), null, 2, null);
    }

    @NotNull
    public DasScope<DasTypedObject> getColumnScope() {
        return this.columnScope;
    }

    public int getColumnCount() {
        return this.columnScope.getAllElements().size();
    }

    @NotNull
    public String getColumnName(int i2) {
        String string = ((DasTypedObject)this.columnScope.getAllElements().get(i2)).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public DasType getColumnDasType(int i2) {
        DasType dasType = ((DasTypedObject)this.columnScope.getAllElements().get(i2)).getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        return dasType;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof DasRecordTypeBase && Intrinsics.areEqual((Object)this.columnScope.getAllElements(), (Object)((DasRecordTypeBase)other).columnScope.getAllElements());
    }

    public int hashCode() {
        return ((Object)this.columnScope.getAllElements()).hashCode();
    }

    @NotNull
    public abstract String getPrefix();

    @NotNull
    public String getLeftParen() {
        return "(";
    }

    @NotNull
    public String getRightParen() {
        return ")";
    }

    @NotNull
    public String renderColumn(@NotNull String name, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return name + " " + type;
    }

    @NotNull
    public String getDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$getDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDescription_u24lambda_u240.append(this.getPrefix());
        List list = this.columnScope.getAllElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllElements(...)");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$getDescription_u24lambda_u240, null, (CharSequence)this.getLeftParen(), (CharSequence)this.getRightParen(), (int)0, null, arg_0 -> DasRecordTypeBase.getDescription$lambda$0$0(this, arg_0), (int)50, null);
        return stringBuilder.toString();
    }

    @NotNull
    public DataType toDataType() {
        StringBuilder stringBuilder;
        StringBuilder $this$toDataType_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toDataType_u24lambda_u240.append(this.getPrefix());
        List list = this.columnScope.getAllElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllElements(...)");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$toDataType_u24lambda_u240, null, (CharSequence)this.getLeftParen(), (CharSequence)this.getRightParen(), (int)0, null, arg_0 -> DasRecordTypeBase.toDataType$lambda$0$0(this, arg_0), (int)50, null);
        String spec = stringBuilder.toString();
        DataType dataType = DataTypeFactory.of(spec);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        return dataType;
    }

    private static final CharSequence getDescription$lambda$0$0(DasRecordTypeBase this$0, DasTypedObject it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = it.getDasType().getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
        return this$0.renderColumn(string, string2);
    }

    private static final CharSequence toDataType$lambda$0$0(DasRecordTypeBase this$0, DasTypedObject it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = it.getDasType().getSpecification();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSpecification(...)");
        return this$0.renderColumn(string, string2);
    }
}

