/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.operation.distance.GeometryLocation;

public class FacetSequence {
    private Geometry geom = null;
    private CoordinateSequence pts;
    private int start;
    private int end;

    public FacetSequence(Geometry geom, CoordinateSequence pts, int start2, int end) {
        this.geom = geom;
        this.pts = pts;
        this.start = start2;
        this.end = end;
    }

    public FacetSequence(CoordinateSequence pts, int start2, int end) {
        this.pts = pts;
        this.start = start2;
        this.end = end;
    }

    public FacetSequence(CoordinateSequence pts, int start2) {
        this.pts = pts;
        this.start = start2;
        this.end = start2 + 1;
    }

    public Envelope getEnvelope() {
        Envelope env = new Envelope();
        for (int i2 = this.start; i2 < this.end; ++i2) {
            env.expandToInclude(this.pts.getX(i2), this.pts.getY(i2));
        }
        return env;
    }

    public int size() {
        return this.end - this.start;
    }

    public Coordinate getCoordinate(int index) {
        return this.pts.getCoordinate(this.start + index);
    }

    public boolean isPoint() {
        return this.end - this.start == 1;
    }

    public double distance(FacetSequence facetSeq) {
        double distance;
        boolean isPoint = this.isPoint();
        boolean isPointOther = facetSeq.isPoint();
        if (isPoint && isPointOther) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            distance = pt.distance(seqPt);
        } else if (isPoint) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            distance = this.computeDistancePointLine(pt, facetSeq, null);
        } else if (isPointOther) {
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            distance = this.computeDistancePointLine(seqPt, this, null);
        } else {
            distance = this.computeDistanceLineLine(facetSeq, null);
        }
        return distance;
    }

    public GeometryLocation[] nearestLocations(FacetSequence facetSeq) {
        boolean isPoint = this.isPoint();
        boolean isPointOther = facetSeq.isPoint();
        GeometryLocation[] locs = new GeometryLocation[2];
        if (isPoint && isPointOther) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            locs[0] = new GeometryLocation(this.geom, this.start, new Coordinate(pt));
            locs[1] = new GeometryLocation(facetSeq.geom, facetSeq.start, new Coordinate(seqPt));
        } else if (isPoint) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            this.computeDistancePointLine(pt, facetSeq, locs);
        } else if (isPointOther) {
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            this.computeDistancePointLine(seqPt, this, locs);
            GeometryLocation tmp = locs[0];
            locs[0] = locs[1];
            locs[1] = tmp;
        } else {
            this.computeDistanceLineLine(facetSeq, locs);
        }
        return locs;
    }

    private double computeDistanceLineLine(FacetSequence facetSeq, GeometryLocation[] locs) {
        double minDistance = Double.MAX_VALUE;
        for (int i2 = this.start; i2 < this.end - 1; ++i2) {
            Coordinate p0 = this.pts.getCoordinate(i2);
            Coordinate p1 = this.pts.getCoordinate(i2 + 1);
            for (int j = facetSeq.start; j < facetSeq.end - 1; ++j) {
                Coordinate q1;
                Coordinate q0 = facetSeq.pts.getCoordinate(j);
                double dist = Distance.segmentToSegment(p0, p1, q0, q1 = facetSeq.pts.getCoordinate(j + 1));
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                if (locs != null) {
                    this.updateNearestLocationsLineLine(i2, p0, p1, facetSeq, j, q0, q1, locs);
                }
                if (!(minDistance <= 0.0)) continue;
                return minDistance;
            }
        }
        return minDistance;
    }

    private void updateNearestLocationsLineLine(int i2, Coordinate p0, Coordinate p1, FacetSequence facetSeq, int j, Coordinate q0, Coordinate q1, GeometryLocation[] locs) {
        LineSegment seg0 = new LineSegment(p0, p1);
        LineSegment seg1 = new LineSegment(q0, q1);
        Coordinate[] closestPt = seg0.closestPoints(seg1);
        locs[0] = new GeometryLocation(this.geom, i2, new Coordinate(closestPt[0]));
        locs[1] = new GeometryLocation(facetSeq.geom, j, new Coordinate(closestPt[1]));
    }

    private double computeDistancePointLine(Coordinate pt, FacetSequence facetSeq, GeometryLocation[] locs) {
        double minDistance = Double.MAX_VALUE;
        for (int i2 = facetSeq.start; i2 < facetSeq.end - 1; ++i2) {
            Coordinate q1;
            Coordinate q0 = facetSeq.pts.getCoordinate(i2);
            double dist = Distance.pointToSegment(pt, q0, q1 = facetSeq.pts.getCoordinate(i2 + 1));
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            if (locs != null) {
                this.updateNearestLocationsPointLine(pt, facetSeq, i2, q0, q1, locs);
            }
            if (!(minDistance <= 0.0)) continue;
            return minDistance;
        }
        return minDistance;
    }

    private void updateNearestLocationsPointLine(Coordinate pt, FacetSequence facetSeq, int i2, Coordinate q0, Coordinate q1, GeometryLocation[] locs) {
        locs[0] = new GeometryLocation(this.geom, this.start, new Coordinate(pt));
        LineSegment seg = new LineSegment(q0, q1);
        Coordinate segClosestPoint = seg.closestPoint(pt);
        locs[1] = new GeometryLocation(facetSeq.geom, i2, new Coordinate(segClosestPoint));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LINESTRING ( ");
        Coordinate p = new Coordinate();
        for (int i2 = this.start; i2 < this.end; ++i2) {
            if (i2 > this.start) {
                buf.append(", ");
            }
            this.pts.getCoordinate(i2, p);
            buf.append(p.x + " " + p.y);
        }
        buf.append(" )");
        return buf.toString();
    }
}

