/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.meta.key.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"highlightDeprecationIfNeeded", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "keyElement", "Lcom/intellij/psi/PsiElement;", "highlightDeprecatedConfigKey", "configKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "psiElement", "intellij.ktor"})
public final class DeprecationHighlightingUtilsKt {
    public static final void highlightDeprecationIfNeeded(@NotNull ProblemsHolder holder, @NotNull PsiElement keyElement) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
        MetaConfigKey metaConfigKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)keyElement);
        if (metaConfigKey == null) {
            return;
        }
        MetaConfigKey configKey = metaConfigKey;
        if (!Intrinsics.areEqual((Object)configKey.getDeprecation(), (Object)MetaConfigKey.Deprecation.NOT_DEPRECATED)) {
            DeprecationHighlightingUtilsKt.highlightDeprecatedConfigKey(holder, configKey, keyElement);
        }
    }

    private static final void highlightDeprecatedConfigKey(ProblemsHolder $this$highlightDeprecatedConfigKey, MetaConfigKey configKey, PsiElement psiElement) {
        String string;
        MetaConfigKey.Deprecation deprecation = configKey.getDeprecation();
        Intrinsics.checkNotNullExpressionValue((Object)deprecation, (String)"getDeprecation(...)");
        MetaConfigKey.Deprecation deprecation2 = deprecation;
        String string2 = deprecation2.getReason().getShortText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortText(...)");
        String reasonShortText = string2;
        if (((CharSequence)reasonShortText).length() > 0) {
            var6_5 = new Object[]{reasonShortText};
            string = KtorStarterBundle.INSTANCE.message("ktor.config.property.deprecated.reason", var6_5);
        } else {
            var6_5 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)configKey.getName(), (String)"getName(...)");
            string = KtorStarterBundle.INSTANCE.message("ktor.config.property.deprecated", var6_5);
        }
        String reason = string;
        ProblemHighlightType problemHighlightType = switch (WhenMappings.$EnumSwitchMapping$0[deprecation2.getLevel().ordinal()]) {
            case 1 -> ProblemHighlightType.GENERIC_ERROR;
            case 2 -> ProblemHighlightType.LIKE_DEPRECATED;
            default -> throw new NoWhenBranchMatchedException();
        };
        $this$highlightDeprecatedConfigKey.registerProblem(psiElement, reason, problemHighlightType, new LocalQuickFix[0]);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetaConfigKey.Deprecation.DeprecationLevel.values().length];
            try {
                nArray[MetaConfigKey.Deprecation.DeprecationLevel.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetaConfigKey.Deprecation.DeprecationLevel.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

