/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.run.task.state;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.configurations.common.property.KtorCommonProperty;
import com.intellij.ktor.configurations.common.utils.PortUtilsKt;
import com.intellij.ktor.run.task.state.KtorServerConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"SERVER_CONFIGURATION_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ktor/run/task/state/KtorServerConfiguration;", "getSERVER_CONFIGURATION_KEY", "()Lcom/intellij/openapi/util/Key;", "getServerConfiguration", "module", "Lcom/intellij/openapi/module/Module;", "javaParams", "Lcom/intellij/execution/configurations/JavaParameters;", "getServerConfigurationFromJavaParams", "getPropertyFromJavaParams", "", "key", "getServerConfigurationFromConfigFile", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorServerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorServerConfiguration.kt\ncom/intellij/ktor/run/task/state/KtorServerConfigurationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class KtorServerConfigurationKt {
    @NotNull
    private static final Key<KtorServerConfiguration> SERVER_CONFIGURATION_KEY;

    @NotNull
    public static final Key<KtorServerConfiguration> getSERVER_CONFIGURATION_KEY() {
        return SERVER_CONFIGURATION_KEY;
    }

    @Nullable
    public static final KtorServerConfiguration getServerConfiguration(@NotNull Module module, @NotNull JavaParameters javaParams) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)javaParams, (String)"javaParams");
        if (!KtorLibraryUtilKt.hasKtorConfiguration(module)) {
            return null;
        }
        KtorServerConfiguration ktorServerConfiguration = KtorServerConfigurationKt.getServerConfigurationFromJavaParams(javaParams);
        if (ktorServerConfiguration == null) {
            ktorServerConfiguration = KtorServerConfigurationKt.getServerConfigurationFromConfigFile(module);
        }
        return ktorServerConfiguration;
    }

    private static final KtorServerConfiguration getServerConfigurationFromJavaParams(JavaParameters javaParams) {
        String port = KtorServerConfigurationKt.getPropertyFromJavaParams(javaParams, "ktor.deployment.port");
        String sslPort = KtorServerConfigurationKt.getPropertyFromJavaParams(javaParams, "ktor.deployment.sslPort");
        return KtorServerConfiguration.Companion.from(port, sslPort);
    }

    private static final String getPropertyFromJavaParams(JavaParameters javaParams, String key) {
        String string;
        String fromVmOptions;
        String string2 = fromVmOptions = javaParams.getVMParametersList().getPropertyValue(key);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final KtorServerConfiguration getServerConfigurationFromConfigFile(Module module) {
        Object v1;
        KtorCommonProperty port;
        block3: {
            Object object;
            Object object22;
            List ports;
            block2: {
                ports = SequencesKt.toList(PortUtilsKt.getPortsFromConfig(module));
                Iterable iterable = ports;
                for (Object object22 : iterable) {
                    KtorCommonProperty it = (KtorCommonProperty)object22;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKey(), (Object)"ktor.deployment.port")) continue;
                    object = object22;
                    break block2;
                }
                object = null;
            }
            port = (KtorCommonProperty)object;
            Iterable iterable = ports;
            object22 = iterable.iterator();
            while (object22.hasNext()) {
                Object e = object22.next();
                KtorCommonProperty it = (KtorCommonProperty)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)"ktor.deployment.sslPort")) continue;
                v1 = e;
                break block3;
            }
            v1 = null;
        }
        KtorCommonProperty sslPort = v1;
        KtorCommonProperty ktorCommonProperty = port;
        KtorCommonProperty ktorCommonProperty2 = sslPort;
        return KtorServerConfiguration.Companion.from(ktorCommonProperty != null ? ktorCommonProperty.getValue() : null, ktorCommonProperty2 != null ? ktorCommonProperty2.getValue() : null);
    }

    static {
        Key key = Key.create((String)"KTOR_SERVER_CONFIGURATION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SERVER_CONFIGURATION_KEY = key;
    }
}

