/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections.platform;

import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ExecChannelConfig;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SftpChannelConfig;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshException;
import com.intellij.ssh.channels.ExecChannel;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.process.SshExecProcess;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileSystem;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileSystemConfigBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlatformSftpFileProvider
extends AbstractOriginatingFileProvider {
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.GET_LAST_MODIFIED, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.RANDOM_ACCESS_READ, Capability.READ_CONTENT, Capability.RENAME, Capability.SET_LAST_MODIFIED_FILE, Capability.URI, Capability.WRITE_CONTENT));
    private final BiFunction<SessionConfig, SftpChannelConfig.SftpCommand, SftpChannel> mySftpChannelFactory;
    private final BiFunction<? super SessionConfig, ? super String, ExecChannel> myExecChannelFactory;

    private static SftpChannel serviceSftpChannelFactory(@NotNull SessionConfig sessionConfig, @Nullable SftpChannelConfig.SftpCommand sftpCommand) {
        if (sessionConfig == null) {
            PlatformSftpFileProvider.$$$reportNull$$$0(0);
        }
        return SshConnectionService.getInstance().failSafeSftp(sessionConfig, new SftpChannelConfig(sftpCommand));
    }

    private static ExecChannel serviceExecChannelFactory(@NotNull SessionConfig sessionConfig, @NotNull String shellCommand) {
        if (sessionConfig == null) {
            PlatformSftpFileProvider.$$$reportNull$$$0(1);
        }
        if (shellCommand == null) {
            PlatformSftpFileProvider.$$$reportNull$$$0(2);
        }
        return SshConnectionService.getInstance().exec(sessionConfig, ExecChannelConfig.Factory.create(shellCommand));
    }

    public PlatformSftpFileProvider() {
        this(PlatformSftpFileProvider::serviceSftpChannelFactory, PlatformSftpFileProvider::serviceExecChannelFactory);
    }

    PlatformSftpFileProvider(BiFunction<SessionConfig, SftpChannelConfig.SftpCommand, SftpChannel> sftpChannelFactory, BiFunction<? super SessionConfig, ? super String, ExecChannel> execChannelFactory) {
        this.mySftpChannelFactory = sftpChannelFactory;
        this.myExecChannelFactory = execChannelFactory;
        this.setFileNameParser((FileNameParser)PlatformSftpFileNameParser.INSTANCE);
    }

    protected FileSystem doCreateFileSystem(@NotNull FileName rootName, @NotNull FileSystemOptions fileSystemOptions) throws FileSystemException {
        SftpChannel sftpChannel;
        PlatformSftpFileSystemConfigBuilder builder;
        RemoteCredentials remoteCredentials;
        if (rootName == null) {
            PlatformSftpFileProvider.$$$reportNull$$$0(3);
        }
        if (fileSystemOptions == null) {
            PlatformSftpFileProvider.$$$reportNull$$$0(4);
        }
        if ((remoteCredentials = (builder = PlatformSftpFileSystemConfigBuilder.getInstance()).getRemoteCredentials(fileSystemOptions)) == null) {
            throw new IllegalStateException("Bug. RemoteCredentials is not set in FileSystemOptions.");
        }
        SessionConfig sessionConfig = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)remoteCredentials).withDisconnectTrigger(builder.getForceDisconnectListenerDispatcher(fileSystemOptions)).buildSessionConfig();
        String workingDirectory = rootName.getPath();
        Boolean userDirIsRoot = PlatformSftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions);
        if (userDirIsRoot == Boolean.TRUE) {
            workingDirectory = null;
        } else {
            String homeFolderOverride = PlatformSftpFileSystemConfigBuilder.getInstance().getHomeFolderOverride(fileSystemOptions);
            if (homeFolderOverride != null) {
                workingDirectory = homeFolderOverride;
            }
        }
        try {
            sftpChannel = this.mySftpChannelFactory.apply(sessionConfig, builder.getSftpCommand(fileSystemOptions));
        }
        catch (SshException err) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)workingDirectory, (Throwable)err);
        }
        return new PlatformSftpFileSystem(rootName, fileSystemOptions, sftpChannel, workingDirectory, (ThrowableNotNullFunction<? super String, String, ? extends IOException>)((ThrowableNotNullFunction)cmd -> this.executeCommandOnRemoteHost(sessionConfig, (String)cmd)));
    }

    private String executeCommandOnRemoteHost(SessionConfig sessionConfig, String command) throws IOException {
        ExecChannel execChannel = this.myExecChannelFactory.apply((SessionConfig)sessionConfig, command);
        SshExecProcess process = new SshExecProcess(execChannel, execChannel.getHasPty());
        try {
            String result = PlatformSftpFileProvider.streamToString(process.getInputStream());
            try {
                process.waitFor(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException err) {
                throw new IOException("Awaiting for exit of `" + command + "` was interrupted", err);
            }
            if (process.exitValue() != 0) {
                throw new IOException("Command `" + command + "` exited with code " + process.exitValue());
            }
            return result;
        }
        catch (IOException | RuntimeException err) {
            try {
                process.destroy();
                execChannel.close();
            }
            catch (RuntimeException err2) {
                err.addSuppressed(err2);
            }
            throw err;
        }
    }

    private static String streamToString(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            PlatformSftpFileProvider.$$$reportNull$$$0(5);
        }
        @NonNls ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream inputStream = stream;){
            int count;
            byte[] buffer = new byte[4096];
            while ((count = stream.read(buffer)) >= 0) {
                baos.write(buffer, 0, count);
            }
        }
        return baos.toString(StandardCharsets.UTF_8);
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystemOptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/connections/platform/PlatformSftpFileProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "serviceSftpChannelFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "serviceExecChannelFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doCreateFileSystem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "streamToString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PlatformSftpFileNameParser
    extends HostFileNameParser {
        private static final PlatformSftpFileNameParser INSTANCE = new PlatformSftpFileNameParser();

        private PlatformSftpFileNameParser() {
            super(22);
        }

        public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
            return this.parseUri(filename, true);
        }

        public FileName parseChildUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
            return this.parseUri(filename, false);
        }

        @NotNull
        private URLFileName parseUri(String filename, boolean fixSeparators) throws FileSystemException {
            StringBuilder name = new StringBuilder();
            HostFileNameParser.Authority auth = this.extractToPath(filename, name);
            UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
            if (fixSeparators) {
                UriParser.fixSeparators((StringBuilder)name);
            }
            FileType fileType = UriParser.normalisePath((StringBuilder)name);
            String path = name.toString();
            return new URLFileName(auth.getScheme(), auth.getHostName(), auth.getPort(), this.getDefaultPort(), path, fileType, null);
        }
    }
}

