/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.microservices.jvm.completion.beans.BeanInjectionCompletionProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringClassAccessInfoProvider;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.completion.SpringBeanInjectionCompletionContributorKt;
import com.intellij.spring.completion.SpringBeanInjectionInsertHandler;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.actions.generate.autowire.AutowireBeanUtilsKt;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.settings.SpringGeneralSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0014J\u0016\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001c\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J8\u0010\u001a\u001a\u00020\u00122\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\nH\u0002J0\u0010\"\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\n0#2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006&"}, d2={"Lcom/intellij/spring/completion/SpringBeanInjectionCompletionProvider;", "Lcom/intellij/microservices/jvm/completion/beans/BeanInjectionCompletionProvider;", "Lcom/intellij/spring/model/SpringBeanPointer;", "<init>", "()V", "isAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "getBeanTypeName", "", "beanToInject", "getLookupElementIcon", "Ljavax/swing/Icon;", "canInjectIntoClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "addCompletionsForBeans", "", "injectionTargetClass", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "isBeanNameMatches", "matcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "beanPointer", "createLookupItems", "candidates", "", "injectionTargetClassPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "createLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "beanName", "getAccessIconAndLocation", "Lkotlin/Pair;", "sourceClass", "targetClass", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringBeanInjectionCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanInjectionCompletionContributor.kt\ncom/intellij/spring/completion/SpringBeanInjectionCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,242:1\n1617#2,9:243\n1869#2:252\n1870#2:254\n1626#2:255\n1761#2,3:256\n1869#2:259\n295#2,2:261\n1870#2:263\n774#2:265\n865#2,2:266\n1#3:253\n1#3:264\n171#4:260\n*S KotlinDebug\n*F\n+ 1 SpringBeanInjectionCompletionContributor.kt\ncom/intellij/spring/completion/SpringBeanInjectionCompletionProvider\n*L\n74#1:243,9\n74#1:252\n74#1:254\n74#1:255\n74#1:256,3\n85#1:259\n93#1:261,2\n85#1:263\n66#1:265\n66#1:266,2\n74#1:253\n86#1:260\n*E\n"})
final class SpringBeanInjectionCompletionProvider
extends BeanInjectionCompletionProvider<SpringBeanPointer<?>> {
    protected boolean isAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SpringGeneralSettings.getInstance((Project)module.getProject()).isSmartCompletionAvailability() && SpringCommonUtils.isSpringConfigured((Module)module);
    }

    @NotNull
    protected String getBeanTypeName(@NotNull SpringBeanPointer<?> beanToInject) {
        Intrinsics.checkNotNullParameter(beanToInject, (String)"beanToInject");
        Object object = beanToInject.getBeanClass();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        return " " + (String)object;
    }

    @Nullable
    protected Icon getLookupElementIcon(@NotNull SpringBeanPointer<?> beanToInject) {
        Intrinsics.checkNotNullParameter(beanToInject, (String)"beanToInject");
        return SpringPresentationProvider.getSpringIcon(beanToInject);
    }

    protected boolean canInjectIntoClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return SpringCommonUtils.isAnnotatedComponent((PsiClass)psiClass);
    }

    protected void addCompletionsForBeans(@NotNull PsiClass injectionTargetClass, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)injectionTargetClass, (String)"injectionTargetClass");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        SmartPsiElementPointer injectionTargetClassPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)injectionTargetClass));
        SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$default(injectionTargetClass, 0, arg_0 -> SpringBeanInjectionCompletionProvider.addCompletionsForBeans$lambda$0(this, injectionTargetClass, injectionTargetClassPointer, result2, arg_0), 2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBeanNameMatches(PrefixMatcher matcher, SpringBeanPointer<?> beanPointer) {
        String p0;
        void $this$any$iv;
        void $this$mapNotNullTo$iv$iv;
        String string = beanPointer.getName();
        if (string == null) {
            return false;
        }
        String beanName = string;
        PsiClass psiClass = beanPointer.getBeanClass();
        String qualifiedName = psiClass != null ? psiClass.getName() : null;
        if (matcher.prefixMatches(beanName)) return true;
        if (qualifiedName != null) {
            if (matcher.prefixMatches(StringsKt.decapitalize((String)qualifiedName))) return true;
        }
        Collection collection = beanPointer.getSpringBean().getSpringQualifiers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSpringQualifiers(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SpringQualifier it = (SpringQualifier)element$iv$iv;
            boolean bl2 = false;
            if (it.getQualifierValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        object = $this$any$iv.iterator();
        do {
            if (!object.hasNext()) return false;
            Object element$iv = object.next();
            p0 = (String)element$iv;
            boolean bl = false;
        } while (!matcher.prefixMatches(p0));
        return true;
    }

    private final void createLookupItems(Collection<? extends SpringBeanPointer<?>> candidates, PsiClass injectionTargetClass, SmartPsiElementPointer<PsiClass> injectionTargetClassPointer, CompletionResultSet result2) {
        ProgressManager.checkCanceled();
        List lookupElements = new ArrayList();
        Iterable $this$forEach$iv = candidates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpringBeanPointer it;
            GlobalSearchScope resolveScope;
            UClass uClass;
            SpringBeanPointer springBeanPointer = (SpringBeanPointer)element$iv;
            boolean bl = false;
            PsiElement $this$toUElementOfType$iv = (PsiElement)injectionTargetClass;
            boolean $i$f$toUElementOfType = false;
            if ((UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class) == null || !AutowireBeanUtilsKt.checkAutowireCandidate(uClass, springBeanPointer)) continue;
            SpringBeanPointer targetSpringBeanPointer = springBeanPointer;
            Intrinsics.checkNotNullExpressionValue((Object)injectionTargetClass.getResolveScope(), (String)"getResolveScope(...)");
            if (!resolveScope.contains(springBeanPointer.getContainingFile().getVirtualFile())) {
                Object v0;
                block5: {
                    Iterable $this$firstOrNull$iv = AutowireBeanUtilsKt.getBaseClassesAndInterfaces(springBeanPointer);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        it = (SpringBeanPointer)element$iv2;
                        boolean bl2 = false;
                        if (!resolveScope.contains(it.getContainingFile().getVirtualFile())) continue;
                        v0 = element$iv2;
                        break block5;
                    }
                    v0 = null;
                }
                targetSpringBeanPointer = v0;
            }
            if (targetSpringBeanPointer == null) continue;
            if (SpringBeanInjectionCompletionProvider.createLookupElement$default(this, injectionTargetClassPointer, targetSpringBeanPointer, null, 4, null) != null) {
                LookupElement it2;
                boolean bl3 = false;
                lookupElements.add(it2);
            }
            for (SpringQualifier qualifier : springBeanPointer.getSpringBean().getSpringQualifiers()) {
                if (this.createLookupElement(injectionTargetClassPointer, targetSpringBeanPointer, qualifier.getQualifierValue()) == null) continue;
                boolean bl4 = false;
                lookupElements.add(it);
            }
        }
        result2.addAllElements((Iterable)lookupElements);
    }

    private final LookupElement createLookupElement(SmartPsiElementPointer<PsiClass> injectionTargetClassPointer, SpringBeanPointer<?> beanToInject, String beanName) {
        if (beanName == null) {
            return null;
        }
        PsiClass psiClass = beanToInject.getBeanClass();
        if (psiClass == null) {
            return null;
        }
        PsiClass beanClassToInject = psiClass;
        SmartPsiElementPointer beanClassPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)beanClassToInject));
        String injectedName = this.getInjectedName(beanName, beanClassPointer);
        SpringBeanInjectionInsertHandler insertHandler = new SpringBeanInjectionInsertHandler(injectionTargetClassPointer, beanToInject, injectedName);
        PsiClass psiClass2 = (PsiClass)injectionTargetClassPointer.dereference();
        if (psiClass2 == null) {
            return null;
        }
        PsiClass beanClassToInjectInto = psiClass2;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)beanClassToInject));
        Pair<Icon, String> pair = this.getAccessIconAndLocation(beanClassToInjectInto, beanClassToInject, module);
        Icon accessIcon = (Icon)pair.component1();
        String tailText = (String)pair.component2();
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)"BeanInjectionObject", (String)injectedName).withPresentableText(injectedName).withItemTextItalic(true).withInsertHandler((InsertHandler)insertHandler).withTailText(tailText).withTypeText(this.getBeanTypeName(beanToInject), accessIcon, true).withIcon(this.getLookupElementIcon(beanToInject)).withPsiElement((PsiElement)beanClassToInject);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withPsiElement(...)");
        return BeanInjectionCompletionProvider.Companion.withLowPriority((LookupElement)lookupElementBuilder);
    }

    static /* synthetic */ LookupElement createLookupElement$default(SpringBeanInjectionCompletionProvider springBeanInjectionCompletionProvider, SmartPsiElementPointer smartPsiElementPointer, SpringBeanPointer springBeanPointer, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = springBeanPointer.getName();
        }
        return springBeanInjectionCompletionProvider.createLookupElement((SmartPsiElementPointer<PsiClass>)smartPsiElementPointer, springBeanPointer, string);
    }

    private final Pair<Icon, String> getAccessIconAndLocation(PsiClass sourceClass, PsiClass targetClass, Module module) {
        Object object;
        Icon accessIcon;
        block3: {
            block2: {
                SpringClassAccessInfoProvider.AccessInfo accessInfo = SpringBeanInjectionCompletionContributorKt.access$getAccessInfo(sourceClass, targetClass, module);
                accessIcon = accessInfo == null || accessInfo.getAccessible() ? null : AllIcons.General.Warning;
                object = accessInfo;
                if (object == null || (object = object.getTargetLocation()) == null) break block2;
                Object it = object;
                boolean bl = false;
                String string = " " + (String)it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        Object tailText = object;
        return new Pair((Object)accessIcon, tailText);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addCompletionsForBeans$lambda$0(SpringBeanInjectionCompletionProvider this$0, PsiClass $injectionTargetClass, SmartPsiElementPointer $injectionTargetClassPointer, CompletionResultSet $result, Collection it) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = it;
        SpringBeanInjectionCompletionProvider springBeanInjectionCompletionProvider = this$0;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpringBeanPointer it2 = (SpringBeanPointer)element$iv$iv;
            boolean bl = false;
            PrefixMatcher prefixMatcher = $result.getPrefixMatcher();
            Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"getPrefixMatcher(...)");
            if (!this$0.isBeanNameMatches(prefixMatcher, it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        springBeanInjectionCompletionProvider.createLookupItems((List)destination$iv$iv, $injectionTargetClass, (SmartPsiElementPointer<PsiClass>)$injectionTargetClassPointer, $result);
        return Unit.INSTANCE;
    }
}

