/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure.logical.dependencies;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ExternalElementsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.model.structure.logical.dependencies.SpringBeanAutowiredInPresentationProvider;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=SpringBeanAutowiredInPresentationProvider.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/spring/model/structure/logical/dependencies/SpringBeanAutowiredInProvider;", "Lcom/intellij/ide/structureView/logical/ExternalElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "<init>", "()V", "isApplicable", "", "parent", "getElements", "", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringBeanAutowiredInProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanAutowiredInProvider.kt\ncom/intellij/spring/model/structure/logical/dependencies/SpringBeanAutowiredInProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class SpringBeanAutowiredInProvider
implements ExternalElementsProvider<SpringBeanLogicalModel, SpringBeanLogicalModel> {
    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return !(parent.getSpringBean() instanceof SpringController) && !(parent.getSpringBean() instanceof SpringConfiguration);
    }

    @NotNull
    public List<SpringBeanLogicalModel> getElements(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (parent.getSpringBean() instanceof SpringController) {
            return CollectionsKt.emptyList();
        }
        PsiType psiType = parent.getSpringBean().getBeanType();
        if (psiType == null) {
            return CollectionsKt.emptyList();
        }
        PsiType beanType = psiType;
        Module module = parent.getSpringBean().getModule();
        if (module == null) {
            SpringBeanLogicalModel springBeanLogicalModel;
            SpringBeanLogicalModel it = springBeanLogicalModel = parent;
            boolean bl = false;
            Object object = it.isValid() ? springBeanLogicalModel : null;
            if (object != null && (object = object.getNavigationElement()) != null) {
                SpringBeanLogicalModel it2 = object;
                boolean bl2 = false;
                module = ModuleUtil.findModuleForPsiElement((PsiElement)it2);
            } else {
                module = null;
            }
        }
        Module module2 = module;
        List result2 = new ArrayList();
        for (CommonSpringBean beanPointer : SpringAutowireUtil.getAutowiredInBeans(beanType, module2, parent.getSpringBean())) {
            PsiElement psiElement = beanPointer.getIdentifyingPsiElement();
            Intrinsics.checkNotNull((Object)beanPointer);
            result2.add(new SpringBeanLogicalModel(psiElement, beanPointer));
        }
        return result2;
    }
}

