/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.refactoring;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;

public class SpringIntroduceBeanIntention
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(SpringIntroduceBeanIntention.class);

    @NotNull
    public String getText() {
        String string = SpringBundle.message("introduce.bean.intention", new Object[0]);
        if (string == null) {
            SpringIntroduceBeanIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            SpringIntroduceBeanIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            SpringIntroduceBeanIntention.$$$reportNull$$$0(2);
        }
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        if (psiFile instanceof JspFile) {
            return false;
        }
        if (!SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
            return false;
        }
        DomSpringBean springBean = SpringBeanCoreUtils.getSpringBeanForCurrentCaretPosition(editor, psiFile);
        return springBean instanceof SpringBean && springBean.getParent() instanceof SpringValueHolder;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            SpringIntroduceBeanIntention.$$$reportNull$$$0(3);
        }
        DomSpringBean springBean = SpringBeanCoreUtils.getSpringBeanForCurrentCaretPosition(editor, psiFile);
        SpringIntroduceBeanIntention.moveToTheTopLevel(project, editor, springBean);
    }

    private static void moveToTheTopLevel(Project project, Editor editor, DomSpringBean springBean) {
        XmlTag tag;
        if (springBean == null) {
            return;
        }
        DomSpringBean topLevelBean = SpringBeanCoreUtils.getTopLevelBean(springBean);
        DomSpringBean newBean = (DomSpringBean)DomUtil.addElementAfter((DomElement)topLevelBean);
        newBean.copyFrom((DomElement)springBean);
        String id = (String)newBean.getId().getValue();
        if (id == null) {
            try {
                XmlAttribute attribute = XmlElementFactory.getInstance((Project)project).createXmlAttribute("id", "");
                tag = newBean.getXmlTag();
                XmlAttribute[] attributes = tag.getAttributes();
                if (attributes.length > 0) {
                    tag.addBefore((PsiElement)attribute, (PsiElement)attributes[0]);
                } else {
                    tag.add((PsiElement)attribute);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        DomElement holder = springBean.getParent();
        assert (holder != null);
        if (holder instanceof SpringValueHolder) {
            ((SpringValueHolder)holder).getRefAttr().setStringValue(id == null ? "" : id);
        } else if (holder instanceof CollectionElements) {
            SpringRef ref = ((CollectionElements)holder).addRef();
            ref.getBean().setStringValue(id == null ? "" : id);
        } else {
            LOG.error("Unexpected parent type: " + String.valueOf(holder));
            return;
        }
        springBean.undefine();
        tag = holder.getXmlTag();
        tag.collapseIfEmpty();
        if (id != null) {
            return;
        }
        SpringBean topLevelBeanCopy = (SpringBean)topLevelBean.createStableCopy();
        SpringBean newBeanCopy = (SpringBean)newBean.createStableCopy();
        SpringValueHolder holderCopy = (SpringValueHolder)holder.createStableCopy();
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        int start = topLevelBeanCopy.getXmlTag().getTextOffset();
        int end = newBeanCopy.getXmlTag().getTextRange().getEndOffset();
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        String text = document.getText();
        int refOffset = holderCopy.getRefAttr().getXmlAttributeValue().getTextOffset();
        int idOffset = newBeanCopy.getId().getXmlAttributeValue().getTextOffset();
        template.addTextSegment(text.substring(start, refOffset));
        String[] names2 = SpringBeanCoreUtils.suggestBeanNames((CommonSpringBean)newBean);
        ConstantNode node = new ConstantNode((Result)null).withLookupStrings(names2);
        template.addVariable("id", (Expression)node, (Expression)node, true);
        template.addTextSegment(text.substring(refOffset, idOffset));
        template.addVariableSegment("id");
        template.addTextSegment(text.substring(idOffset, end));
        document.deleteString(start, end);
        templateManager.startTemplate(editor, template);
    }

    public boolean startInWriteAction() {
        return true;
    }

    static void moveToTheTopLevel(Project project, Editor editor, DomSpringBean springBean, PsiFile psiFile) {
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{psiFile}).withName(SpringBundle.message("move.bean.to.the.top.level", new Object[0])).run(() -> SpringIntroduceBeanIntention.moveToTheTopLevel(project, editor, springBean));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/refactoring/SpringIntroduceBeanIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/refactoring/SpringIntroduceBeanIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

