/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.el.impl.references;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.el.impl.ElBundle;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELFunctionCallExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.references.ELReference;
import com.intellij.javaee.el.util.ELResolveUtil;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.jsp.javaee.web.codeInsight.completion.ELFunctionInsertHandler;
import com.intellij.jsp.javaee.web.el.impl.references.NamespaceELReference;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionELReference
extends ELReference {
    public static final Key<FunctionDescriptor> EL_FUNCTION_DESCRIPTOR = Key.create((String)"el function descriptor");

    public FunctionELReference(ELExpression element) {
        super(element);
    }

    public ResolveResult @NotNull [] resolveInner(Class<? extends PsiElement> targetClass) {
        if (targetClass == PsiClass.class) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                FunctionELReference.$$$reportNull$$$0(0);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        XmlNSDescriptor nsDescriptor = this.getFunctionNsDescriptor();
        if (nsDescriptor instanceof TldDescriptor) {
            FunctionDescriptor functionDescriptor = ((TldDescriptor)nsDescriptor).getFunctionDescriptor(this.getCanonicalText());
            if (functionDescriptor != null) {
                XmlTag tag = functionDescriptor.getTag();
                tag.putUserData(ELResolveUtil.EL_VARS_TYPE, (Object)functionDescriptor.getResultType());
                tag.putUserData(EL_FUNCTION_DESCRIPTOR, (Object)functionDescriptor);
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)tag)};
                if (resolveResultArray == null) {
                    FunctionELReference.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                FunctionELReference.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            FunctionELReference.$$$reportNull$$$0(3);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public Object @NotNull [] getVariants() {
        XmlNSDescriptor functionNsDescriptor = this.getFunctionNsDescriptor();
        if (functionNsDescriptor instanceof TldDescriptor) {
            ArrayList<Object> result = new ArrayList<Object>(10);
            FunctionELReference.addFunctionVariants((TldDescriptor)functionNsDescriptor, "", result);
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                FunctionELReference.$$$reportNull$$$0(4);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            FunctionELReference.$$$reportNull$$$0(5);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    private XmlNSDescriptor getFunctionNsDescriptor() {
        PsiReference[] references;
        ELVariable namespace = ((ELFunctionCallExpression)this.myElement.getParent()).getNamespace();
        for (PsiReference reference : references = namespace.getReferences()) {
            if (!(reference instanceof NamespaceELReference)) continue;
            return ((NamespaceELReference)reference).getNsDescriptor();
        }
        return null;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = ElBundle.message((String)"el.cannot.resolve.function", (Object[])new Object[0]);
        if (string == null) {
            FunctionELReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void addFunctionVariants(TldDescriptor tldDescriptor, String prefix, Collection<Object> result) {
        for (String functionName : tldDescriptor.getFunctionNames()) {
            FunctionDescriptor descriptor = tldDescriptor.getFunctionDescriptor(functionName);
            String qualifiedFunctionName = prefix + functionName;
            LookupElementBuilder variant = LookupElementBuilder.create((Object)descriptor.getTag(), (String)qualifiedFunctionName).bold().withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Function)).withTypeText(descriptor.getFunctionReturnType()).withInsertHandler((InsertHandler)new ELFunctionInsertHandler());
            PsiMethod referencedMethod = descriptor.getReferencedMethod();
            if (referencedMethod != null) {
                String methodSignature = PsiFormatUtil.formatMethod((PsiMethod)referencedMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)256, (int)3);
                variant = variant.withTailText(methodSignature);
            }
            result.add(variant);
        }
    }

    @Nullable
    public static FunctionDescriptor getFunctionDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            FunctionELReference.$$$reportNull$$$0(7);
        }
        return (FunctionDescriptor)tag.getUserData(EL_FUNCTION_DESCRIPTOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/el/impl/references/FunctionELReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/el/impl/references/FunctionELReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7 -> new IllegalArgumentException(string);
        };
    }
}

