/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.codeInsight;

import com.intellij.liquibase.LiquibaseUtilKt;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/liquibase/codeInsight/LiquibaseJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "<init>", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "LiquibaseJsonSchemaProvider", "intellij.liquibase"})
public final class LiquibaseJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object)new LiquibaseJsonSchemaProvider(project));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/liquibase/codeInsight/LiquibaseJsonSchemaProviderFactory$LiquibaseJsonSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "getSchemaFile", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "intellij.liquibase"})
    private static final class LiquibaseJsonSchemaProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project project;

        public LiquibaseJsonSchemaProvider(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".yaml", (boolean)false, (int)2, null)) {
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)".yml", (boolean)false, (int)2, null)) return false;
            }
            if (!LiquibaseUtilKt.isUnderDbChangelogDir(file, this.project)) return false;
            return true;
        }

        @NotNull
        public String getName() {
            String string = LiquibaseResourceBundle.message("liquibase.changelog", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Nullable
        public VirtualFile getSchemaFile() {
            return JsonSchemaProviderFactory.getResourceFile(LiquibaseJsonSchemaProvider.class, (String)"liquibase-schema.json");
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.embeddedSchema;
        }
    }
}

