/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.VtlTypeSystem;
import com.intellij.velocity.java.TypeInferenceUtil;
import com.intellij.velocity.java.VtlJavaUtil;
import com.intellij.velocity.java.reference.VtlPsiReferenceExpression;
import com.intellij.velocity.java.reference.VtlPsiType;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlLiteralExpressionType;
import com.intellij.velocity.psi.VtlVariableType;
import com.intellij.velocity.psi.files.ProviderBuilder;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.template.TemplatesManager;

final class JavaVtlTypeSystem
implements VtlTypeSystem {
    public static final VtlPsiType BOOLEAN_TYPE = new VtlPsiType((PsiType)PsiTypes.booleanType());
    public static final VtlPsiType LONG_TYPE = new VtlPsiType((PsiType)PsiTypes.longType());
    public static final VtlPsiType INT_TYPE = new VtlPsiType((PsiType)PsiTypes.intType());
    public static final VtlPsiType DOUBLE_TYPE = new VtlPsiType((PsiType)PsiTypes.doubleType());
    private static final Object[][] VELOCITY_ITERABLES = new Object[][]{{"java.util.Iterator", 0}, {"java.util.Collection", 0}, {"java.util.Map", 1}, {"java.lang.Iterable", 0}};

    JavaVtlTypeSystem() {
    }

    @Override
    @NotNull
    public VtlReferenceExpression createReferenceElement(@NotNull ASTNode node) {
        if (node == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(0);
        }
        return new VtlPsiReferenceExpression(node);
    }

    @Override
    @NotNull
    public VtlVariableType createTypeFromSignature(@NotNull Project project, @Nullable PsiElement context, @NotNull String signature) {
        if (project == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(2);
        }
        PsiType psiType = JavaPsiFacade.getElementFactory((Project)project).createTypeFromText("java.util.List<java.lang.Integer>", context);
        return new VtlPsiType(psiType);
    }

    @Override
    @NotNull
    public VtlVariableType booleanType() {
        VtlPsiType vtlPsiType = BOOLEAN_TYPE;
        if (vtlPsiType == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(3);
        }
        return vtlPsiType;
    }

    @Override
    @NotNull
    public VtlVariableType intType() {
        VtlPsiType vtlPsiType = INT_TYPE;
        if (vtlPsiType == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(4);
        }
        return vtlPsiType;
    }

    @Override
    @NotNull
    public VtlVariableType doubleType() {
        VtlPsiType vtlPsiType = DOUBLE_TYPE;
        if (vtlPsiType == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(5);
        }
        return vtlPsiType;
    }

    @Override
    @NotNull
    public VtlVariableType longType() {
        VtlPsiType vtlPsiType = LONG_TYPE;
        if (vtlPsiType == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(6);
        }
        return vtlPsiType;
    }

    @Override
    @Nullable
    public VtlVariableType getBoxedType(@Nullable VtlVariableType type, @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(7);
        }
        return VtlPsiType.of(VtlJavaUtil.getBoxedType(VtlPsiType.extract(type), psiElement));
    }

    @Override
    public boolean areTypesConvertible(@NotNull VtlVariableType left, @NotNull VtlVariableType right) {
        if (left == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(8);
        }
        if (right == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(9);
        }
        PsiType leftType = VtlPsiType.extract(left);
        PsiType rightType = VtlPsiType.extract(right);
        if (leftType == null || rightType == null) {
            return false;
        }
        return TypeConversionUtil.areTypesConvertible((PsiType)leftType, (PsiType)rightType);
    }

    @Override
    @NotNull
    public String getPresentableText(@NotNull VtlVariableType type) {
        if (type == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(10);
        }
        String string = VtlJavaUtil.getPresentableText(type);
        if (string == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public VtlVariableType extractTypeFromIterable(@Nullable VtlExpression expr) {
        if (expr == null) {
            return null;
        }
        PsiType type = VtlPsiType.extract(expr.getPsiType());
        if (type instanceof PsiArrayType) {
            return VtlPsiType.of(((PsiArrayType)type).getComponentType());
        }
        for (Object[] iterable : VELOCITY_ITERABLES) {
            String superClass = (String)iterable[0];
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)superClass)) continue;
            PsiType result = PsiUtil.substituteTypeParameter((PsiType)type, (String)superClass, (int)((Integer)iterable[1]), (boolean)false);
            if (result != null) {
                return VtlPsiType.of(result);
            }
            return VtlPsiType.of((PsiType)PsiType.getJavaLangObject((PsiManager)expr.getManager(), (GlobalSearchScope)expr.getResolveScope()));
        }
        return null;
    }

    @Override
    @NotNull
    public VtlVariableType createTypeByFQClassName(@NotNull Project project, @NotNull String className, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(12);
        }
        if (className == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(14);
        }
        VtlVariableType vtlVariableType = VtlPsiType.of((PsiType)JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeByFQClassName(className, scope));
        if (vtlVariableType == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(15);
        }
        return vtlVariableType;
    }

    @Override
    @Nullable
    public VtlVariableType createImplicitVariableType(@NotNull Project project, @NotNull String className, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(16);
        }
        if (className == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(18);
        }
        try {
            PsiTypeCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)project).createTypeCodeFragment(className, null, false);
            fragment.forceResolveScope(scope);
            return VtlPsiType.of(fragment.getType());
        }
        catch (PsiTypeCodeFragment.IncorrectTypeException | IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public Collection<String> inferVariableType(@NotNull VtlImplicitVariable variable) {
        if (variable == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(19);
        }
        Collection<String> collection = TypeInferenceUtil.inferVariableType(variable);
        if (collection == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @Override
    public boolean isNumericType(@NotNull VtlVariableType type) {
        if (type == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(21);
        }
        return TypeConversionUtil.isNumericType((PsiType)VtlPsiType.extract(type));
    }

    @Override
    @NotNull
    public VtlVariableType unboxAndBalanceTypes(@NotNull VtlVariableType left, @NotNull VtlVariableType right) {
        if (left == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(22);
        }
        if (right == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(23);
        }
        return new VtlPsiType(TypeConversionUtil.unboxAndBalanceTypes((PsiType)VtlPsiType.extract(left), (PsiType)VtlPsiType.extract(right)));
    }

    @Override
    public boolean isConvertibleFrom(@NotNull VtlVariableType left, @NotNull VtlVariableType right) {
        if (left == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(24);
        }
        if (right == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(25);
        }
        PsiType rightType = VtlPsiType.extract(right);
        PsiType leftType = VtlPsiType.extract(left);
        if (leftType == null || rightType == null) {
            return false;
        }
        return leftType.isConvertibleFrom(rightType);
    }

    @Override
    @Nullable
    public VtlVariableType inferIndexQualifierType(VtlVariableType type) {
        PsiType qType = VtlPsiType.extract(type);
        if (qType instanceof PsiArrayType) {
            return VtlPsiType.of(((PsiArrayType)qType).getComponentType());
        }
        if (qType instanceof PsiClassType) {
            PsiType mapValue = PsiUtil.substituteTypeParameter((PsiType)qType, (String)"java.util.Map", (int)1, (boolean)false);
            if (mapValue != null) {
                return VtlPsiType.of(mapValue);
            }
            return VtlPsiType.of(PsiUtil.extractIterableTypeParameter((PsiType)qType, (boolean)false));
        }
        return null;
    }

    @Override
    @NotNull
    public LiteralTextEscaper<VtlLiteralExpressionType.VtlStringLiteral> createLiteralEscaper(@NotNull VtlLiteralExpressionType.VtlStringLiteral literal) {
        if (literal == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(26);
        }
        return new StringLiteralEscaper((PsiLanguageInjectionHost)literal);
    }

    @Override
    public void processImplicitVarsProvider(@NotNull VtlFile root, @NotNull Map<String, VtlImplicitVariable> result) {
        Map implicits;
        if (root == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(27);
        }
        if (result == null) {
            JavaVtlTypeSystem.$$$reportNull$$$0(28);
        }
        if ((implicits = (Map)root.getOriginalFile().getViewProvider().getUserData(TemplatesManager.TEMPLATE_IMPLICITS)) != null) {
            for (Map.Entry entry : implicits.entrySet()) {
                String name = (String)entry.getKey();
                VtlImplicitVariable var = ProviderBuilder.getOrCreate(result, root, root, name, name, null);
                var.setPsiType(VtlPsiType.of((PsiType)entry.getValue()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 11, 15, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/java/JavaVtlTypeSystem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 9: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/java/JavaVtlTypeSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "booleanType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "intType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doubleType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "longType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQClassName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "inferVariableType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromSignature";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 15: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "areTypesConvertible";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQClassName";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitVariableType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "inferVariableType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isNumericType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unboxAndBalanceTypes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleFrom";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralEscaper";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitVarsProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 11, 15, 20 -> new IllegalStateException(string);
        };
    }
}

