/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.java.reference;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.SimpleMethodCallLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.AbstractQualifiedReference;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.VelocityIcons;
import com.intellij.velocity.editorActions.VtlDirectiveInsertHandler;
import com.intellij.velocity.java.VelocityNamingUtil;
import com.intellij.velocity.java.VtlJavaUtil;
import com.intellij.velocity.java.VtlVariantsProcessor;
import com.intellij.velocity.java.reference.VtlMethod;
import com.intellij.velocity.java.reference.VtlPsiType;
import com.intellij.velocity.psi.VtlCallable;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlIndexExpression;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlMethodCallExpression;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.VtlVariableType;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlAssignment;
import com.intellij.velocity.psi.directives.VtlMacroCall;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VtlPsiReferenceExpression
extends AbstractQualifiedReference<VtlPsiReferenceExpression>
implements VtlReferenceExpression {
    public VtlPsiReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            VtlPsiReferenceExpression.$$$reportNull$$$0(0);
        }
        super(node);
    }

    protected boolean processVariantsInner(PsiScopeProcessor processor) {
        PsiClass psiClass;
        VtlExpression qualifier = this.getQualifierInner();
        if (qualifier == null) {
            PsiElement parent = this.getParent();
            if (parent instanceof VtlMacroCall) {
                VtlFile containingFile = ((VtlMacroCall)parent).getContainingFile();
                return containingFile.processAllMacrosInScope(processor, ResolveState.initial());
            }
            return this.processUnqualifiedVariants(processor);
        }
        PsiType type = VtlPsiType.extract(qualifier.getPsiType());
        if (type instanceof PsiWildcardType) {
            type = ((PsiWildcardType)type).getExtendsBound();
        }
        if (type instanceof PsiClassType ? (psiClass = PsiUtil.resolveClassInType((PsiType)type)) != null && !psiClass.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this) : type instanceof PsiArrayType && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass("java.util.List", this.getResolveScope())) != null && !psiClass.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this)) {
            return false;
        }
        PsiElement psiElement = qualifier instanceof VtlPsiReferenceExpression ? ((VtlPsiReferenceExpression)qualifier).resolve() : null;
        return psiElement == null || psiElement.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this);
    }

    @Override
    public boolean hasQualifier() {
        return this.getQualifierInner() != null;
    }

    @Override
    public boolean isQualifierResolved() {
        VtlExpression qualifier = this.getQualifierInner();
        return !(qualifier instanceof VtlPsiReferenceExpression) || ((VtlPsiReferenceExpression)qualifier).resolve() != null;
    }

    @Nullable
    private VtlExpression getQualifierInner() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof VtlPsiReferenceExpression || child instanceof VtlIndexExpression) {
                return (VtlExpression)child;
            }
            if (!(child instanceof VtlMethodCallExpression)) continue;
            return ((VtlMethodCallExpression)child).getReferenceExpression();
        }
        return null;
    }

    @Nullable
    public VtlPsiReferenceExpression getParentReferenceExpression() {
        PsiElement parent = this.getParent();
        if (parent instanceof VtlPsiReferenceExpression) {
            return (VtlPsiReferenceExpression)parent;
        }
        return null;
    }

    protected ResolveResult @NotNull [] resolveInner() {
        VtlAssignment assignment;
        VtlVariable var;
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                VtlPsiReferenceExpression.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof VtlAssignment && (var = (assignment = (VtlAssignment)parent).getAssignedVariable(FixedNameVariable.getReferenceScope(this))) != null && assignment.getAssignedVariableElement(FixedNameVariable.getReferenceScope(this)) == this) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)var)};
            if (resolveResultArray == null) {
                VtlPsiReferenceExpression.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        VtlVariantsProcessor<ResolveResult> processor = new VtlVariantsProcessor<ResolveResult>(this, parent, referenceName, false, this.getQualifierClassType()){

            @Override
            protected ResolveResult execute(PsiNamedElement element, boolean error) {
                if (element instanceof BeanPropertyElement) {
                    return new PsiElementResolveResult((PsiElement)((BeanPropertyElement)element).getMethod());
                }
                return new PsiElementResolveResult((PsiElement)element, !error);
            }
        };
        this.processVariantsInner(processor);
        ResolveResult[] resolveResultArray = processor.getVariants(ResolveResult.EMPTY_ARRAY, Character.isLowerCase(referenceName.charAt(0)));
        if (resolveResultArray == null) {
            VtlPsiReferenceExpression.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    @InspectionMessage
    public String getUnresolvedMessage(boolean resolvedWithError) {
        String referenceName = this.getReferenceName();
        PsiElement parent = this.getParent();
        if (parent instanceof VtlMacroCall) {
            String msgKey = resolvedWithError ? "error.wrong.number.of.arguments.for.macro" : "error.cannot.resolve.macro";
            String string = VelocityBundle.message(msgKey, referenceName);
            if (string == null) {
                VtlPsiReferenceExpression.$$$reportNull$$$0(4);
            }
            return string;
        }
        VtlExpression qualifier = this.getQualifierInner();
        if (qualifier == null) {
            String string = VelocityBundle.message("error.cannot.resolve.variable", referenceName);
            if (string == null) {
                VtlPsiReferenceExpression.$$$reportNull$$$0(5);
            }
            return string;
        }
        String typeName = VtlJavaUtil.getPresentableText(qualifier.getPsiType());
        if (!(parent instanceof VtlMethodCallExpression)) {
            String string = VelocityBundle.message("error.cannot.resolve.property", referenceName, typeName);
            if (string == null) {
                VtlPsiReferenceExpression.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (!resolvedWithError) {
            String string = VelocityBundle.message("error.cannot.resolve.method", referenceName, typeName);
            if (string == null) {
                VtlPsiReferenceExpression.$$$reportNull$$$0(7);
            }
            return string;
        }
        String argumentTypes = StringUtil.join((Object[])((VtlMethodCallExpression)parent).getArgumentTypes(), psiType -> VtlJavaUtil.getPresentableText(psiType), (String)", ");
        String string = VelocityBundle.message("error.no.applicable.method", referenceName, typeName, "(" + argumentTypes + ")");
        if (string == null) {
            VtlPsiReferenceExpression.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected VtlPsiReferenceExpression parseReference(String newText) {
        String propertyName;
        if (!(this.getParent() instanceof VtlMethodCallExpression) && (propertyName = VelocityNamingUtil.getPropertyName(newText, this.isFirstCharInLowerCase())) != null) {
            newText = propertyName;
        }
        VtlPsiReferenceExpression vtlPsiReferenceExpression = VtlJavaUtil.createVtlReferenceExpression(newText, this.getProject());
        if (vtlPsiReferenceExpression == null) {
            VtlPsiReferenceExpression.$$$reportNull$$$0(9);
        }
        return vtlPsiReferenceExpression;
    }

    protected PsiElement getSeparator() {
        return this.findChildByType(VtlElementTypes.JAVA_DOT);
    }

    public String toString() {
        return this.getNode().getElementType().toString();
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(VtlElementTypes.IDENTIFIER);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            VtlPsiReferenceExpression.$$$reportNull$$$0(10);
        }
        PsiManagerEx manager = this.getManager();
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement target = result.getElement();
            if (manager.areElementsEquivalent(element, target)) {
                return true;
            }
            if (target instanceof BeanPropertyElement && manager.areElementsEquivalent(element, (PsiElement)((BeanPropertyElement)target).getMethod())) {
                return true;
            }
            if (element instanceof VtlMacro && target instanceof FixedNameVariable) {
                return manager.areElementsEquivalent(((FixedNameVariable)target).getTargetElement(), element);
            }
            if (!(element instanceof VtlImplicitVariable) || !(target instanceof VtlVariable) || target instanceof VtlImplicitVariable || !manager.areElementsEquivalent(element, (PsiElement)VtlImplicitVariable.findImplicitCounterpart((VtlVariable)target))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<LookupElement> getVariants(boolean propertiesOnly, boolean lowerCase) {
        VtlVariantsProcessor<PsiNamedElement> processor = new VtlVariantsProcessor<PsiNamedElement>(this, this.getParent(), propertiesOnly){

            @Override
            protected PsiNamedElement execute(PsiNamedElement element, boolean error) {
                return element;
            }
        };
        this.processVariantsInner(processor);
        return VtlPsiReferenceExpression.convertToLookupElements(processor, ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"{"})).accepts((Object)this.getElement()), lowerCase);
    }

    public static List<LookupElement> convertToLookupElements(VtlVariantsProcessor<PsiNamedElement> processor, boolean macroCallInBraces, boolean lowerCase) {
        Object[] variants = processor.getVariants((PsiNamedElement[])PsiNamedElement.EMPTY_ARRAY, lowerCase);
        return ContainerUtil.map((Object[])variants, element -> {
            PsiType type;
            if (element instanceof PsiMethod) {
                return new SimpleMethodCallLookupElement((PsiMethod)element);
            }
            LookupElementBuilder lookupElement = LookupElementBuilder.create((PsiNamedElement)element);
            if (element instanceof VtlMacro) {
                return lookupElement.withInsertHandler((InsertHandler)new VtlDirectiveInsertHandler(macroCallInBraces, true)).withIcon(VelocityIcons.Sharp);
            }
            if (element instanceof VtlVariable) {
                VtlVariableType type2 = ((VtlVariable)element).getPsiType();
                if (type2 != null) {
                    lookupElement = lookupElement.withTypeText(type2.getPresentableText());
                } else if (element instanceof VtlImplicitVariable) {
                    lookupElement = lookupElement.withTypeText(((VtlImplicitVariable)element).getType());
                }
            } else if (element instanceof BeanPropertyElement && (type = ((BeanPropertyElement)element).getPropertyType()) != null) {
                lookupElement = lookupElement.withTypeText(type.getPresentableText());
            }
            if (element instanceof ItemPresentation) {
                lookupElement = lookupElement.withIcon(((ItemPresentation)element).getIcon(false));
            }
            return lookupElement;
        });
    }

    private boolean isFirstCharInLowerCase() {
        String referenceName = this.getReferenceName();
        return referenceName == null || Character.isLowerCase(referenceName.charAt(0));
    }

    @Override
    public VtlCallable @NotNull [] getCallableCandidates() {
        final String referenceName = this.getReferenceName();
        if (referenceName == null) {
            if (VtlCallable.EMPTY_ARRAY == null) {
                VtlPsiReferenceExpression.$$$reportNull$$$0(11);
            }
            return VtlCallable.EMPTY_ARRAY;
        }
        VtlVariantsProcessor<VtlCallable> processor = new VtlVariantsProcessor<VtlCallable>(this, this.getParent(), false){

            @Override
            protected VtlCallable execute(PsiNamedElement element, boolean error) {
                if (!referenceName.equals(element.getName())) {
                    return null;
                }
                if (element instanceof VtlMacro) {
                    return (VtlMacro)element;
                }
                if (element instanceof PsiMethod) {
                    return new VtlMethod((PsiMethod)element);
                }
                return null;
            }
        };
        this.processVariantsInner(processor);
        VtlCallable[] vtlCallableArray = processor.getVariants(VtlCallable.EMPTY_ARRAY, Character.isLowerCase(referenceName.charAt(0)));
        if (vtlCallableArray == null) {
            VtlPsiReferenceExpression.$$$reportNull$$$0(12);
        }
        return vtlCallableArray;
    }

    @Override
    @Nullable
    public VtlVariableType getPsiType() {
        PsiElement element = this.resolve();
        if (element instanceof VtlVariable) {
            return ((VtlVariable)element).getPsiType();
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiType substitutedType = this.getSubstitutedType(method, method.getReturnType());
            if (substitutedType == null) {
                return null;
            }
            return new VtlPsiType(substitutedType);
        }
        if (element instanceof BeanProperty) {
            BeanProperty beanProperty = (BeanProperty)element;
            return new VtlPsiType(this.getSubstitutedType(beanProperty.getMethod(), beanProperty.getPropertyType()));
        }
        return null;
    }

    public PsiType getSubstitutedType(PsiMethod method, PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return type;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiClassType classType = this.getQualifierClassType();
        if (containingClass != null && classType != null) {
            return TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClassType)classType).substitute(type);
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private PsiClassType getQualifierClassType() {
        PsiType psiType;
        VtlExpression qualifier = this.getQualifierInner();
        if (qualifier == null) return null;
        VtlVariableType vtlVariableType = qualifier.getPsiType();
        if (!(vtlVariableType instanceof VtlPsiType)) return null;
        VtlPsiType vtlPsiType = (VtlPsiType)vtlVariableType;
        try {
            psiType = vtlPsiType.psiType();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(psiType instanceof PsiClassType)) return null;
        return (PsiClassType)psiType;
    }

    @Override
    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            VtlPsiReferenceExpression.$$$reportNull$$$0(13);
        }
        CheckUtil.checkWritable((PsiElement)this);
        PsiElement newReferenceName = this.parseReference(newElementName).getReferenceNameElement();
        this.getNode().replaceChild(this.getReferenceNameElement().getNode(), newReferenceName.getNode());
        VtlPsiReferenceExpression vtlPsiReferenceExpression = this;
        if (vtlPsiReferenceExpression == null) {
            VtlPsiReferenceExpression.$$$reportNull$$$0(14);
        }
        return vtlPsiReferenceExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/java/reference/VtlPsiReferenceExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/java/reference/VtlPsiReferenceExpression";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReference";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallableCandidates";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 14 -> new IllegalStateException(string);
        };
    }
}

