/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.eclipse.importer;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.eclipse.SpringEclipseBundle;
import com.intellij.spring.eclipse.importer.SpringBeansFileParser;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;

@ApiStatus.Internal
public final class SpringBeansConfigImporter {
    private final Module myModule;
    private final List<String> myErrors = new SmartList();

    @VisibleForTesting
    public SpringBeansConfigImporter(Module module) {
        this.myModule = module;
    }

    @VisibleForTesting
    public boolean errorsOccurred() {
        return !this.myErrors.isEmpty();
    }

    @VisibleForTesting
    public String getErrorMessage() {
        return Strings.join(this.myErrors, (String)"\n");
    }

    @VisibleForTesting
    public void perform() {
        SpringBeansFileParser parser;
        VirtualFile contentRoot = this.findContentRoot();
        if (contentRoot == null) {
            this.myErrors.add("Could not find .springBeans");
            return;
        }
        VirtualFile springBeansVirtualFile = contentRoot.findChild(".springBeans");
        assert (springBeansVirtualFile != null);
        try (InputStream inputStream = springBeansVirtualFile.getInputStream();){
            parser = new SpringBeansFileParser(inputStream);
            parser.parse();
        }
        catch (IOException e) {
            this.myErrors.add("I/O error: " + e.getMessage());
            return;
        }
        this.myErrors.addAll(parser.getErrors());
        if (this.errorsOccurred()) {
            return;
        }
        List<SpringBeansFileParser.ConfigSet> configSets = parser.getConfigSets();
        if (configSets.isEmpty()) {
            return;
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)this.myModule);
        if (springFacet == null) {
            springFacet = (SpringFacet)FacetUtil.addFacet((Module)this.myModule, (FacetType)SpringFacet.getSpringFacetType());
        }
        for (SpringBeansFileParser.ConfigSet configSet : configSets) {
            SpringFileSet springFileSet = this.getOrCreateSpringFileSet(springFacet, configSet);
            if (springFileSet == null) continue;
            List<String> profiles = configSet.getProfiles();
            springFileSet.setActiveProfiles(new LinkedHashSet<String>(profiles));
            for (String configPath : configSet.getConfigs()) {
                VirtualFile configFile;
                if (configPath.startsWith("java:")) {
                    configFile = this.resolveJavaConfig(configPath);
                } else {
                    EclipseProjectFinder.LinkedResource linkedResource;
                    configFile = contentRoot.findFileByRelativePath(configPath);
                    if (configFile == null) {
                        configFile = this.resolveConfigFileInDependentModules(configPath);
                    }
                    if (configFile == null && (linkedResource = EclipseProjectFinder.findLinkedResource((String)contentRoot.getPath(), (String)configPath)) != null) {
                        String location = linkedResource.getLocation();
                        springFileSet.addFile(VfsUtilCore.pathToUrl((String)location));
                        continue;
                    }
                }
                if (configFile == null) {
                    this.myErrors.add("Could not find config file '" + configPath + "'");
                    continue;
                }
                springFileSet.addFile(configFile);
            }
        }
        FacetManager.getInstance((Module)this.myModule).facetConfigurationChanged((Facet)springFacet);
    }

    @Nullable
    private SpringFileSet getOrCreateSpringFileSet(SpringFacet springFacet, SpringBeansFileParser.ConfigSet configSet) {
        String importName;
        SpringFileSetService fileSetService = SpringFileSetService.getInstance();
        Set allExistingSets = fileSetService.getAllSets(springFacet);
        SpringFileSet existingFileSet = (SpringFileSet)ContainerUtil.find((Iterable)allExistingSets, arg_0 -> SpringBeansConfigImporter.lambda$getOrCreateSpringFileSet$0(importName = configSet.getName(), arg_0));
        if (existingFileSet == null) {
            return springFacet.addFileSet(fileSetService.getUniqueId((Collection)allExistingSets), importName);
        }
        int answer = Messages.showYesNoCancelDialog((Project)this.myModule.getProject(), (String)SpringEclipseBundle.message("application.context.with.name.already.exists.in.module", importName, this.myModule.getName()), (String)SpringEclipseBundle.message("spring.eclipse.spring.configuration.import", new Object[0]), (String)SpringEclipseBundle.message("spring.eclipse.button.overwrite", new Object[0]), (String)SpringEclipseBundle.message("spring.eclipse.create.copy", new Object[0]), (String)SpringEclipseBundle.message("spring.eclipse.keep.existing", new Object[0]), null);
        if (answer == 2) {
            return null;
        }
        if (answer == 1) {
            return springFacet.addFileSet(fileSetService.getUniqueId((Collection)allExistingSets), fileSetService.getUniqueName("Copy of " + importName, (Collection)allExistingSets));
        }
        for (VirtualFilePointer p : existingFileSet.getXmlFiles()) {
            existingFileSet.removeFile(p);
        }
        for (VirtualFilePointer p : existingFileSet.getCodeConfigurationFiles()) {
            existingFileSet.removeFile(p);
        }
        return existingFileSet;
    }

    @Nullable
    private VirtualFile resolveJavaConfig(String configPath) {
        String fqn = StringUtil.substringAfter((String)configPath, (String)"java:");
        if (fqn == null) {
            return null;
        }
        GlobalSearchScope searchScope = SpringGlobalSearchScopes.runtime((Module)this.myModule, (boolean)false);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myModule.getProject()).findClass(fqn, searchScope);
        return psiClass != null ? psiClass.getContainingFile().getVirtualFile() : null;
    }

    @Nullable
    private VirtualFile resolveConfigFileInDependentModules(String configPath) {
        for (Module module : ModuleRootManager.getInstance((Module)this.myModule).getDependencies()) {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                VirtualFile file = root.findFileByRelativePath(configPath);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    private VirtualFile findContentRoot() {
        VirtualFile[] roots;
        for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)this.myModule).getContentRoots()) {
            VirtualFile springBeansConfigFile = root.findChild(".springBeans");
            if (springBeansConfigFile == null) continue;
            return root;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getOrCreateSpringFileSet$0(String importName, SpringFileSet set) {
        return set.getName().equals(importName);
    }
}

