/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterArgument;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterDatabase;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterLikeView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterMatView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterMatViewColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterRoutine;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterSchema;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterTable;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterTableColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryAlterViewColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateLikeView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateMatView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateMatViewColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateRoutine;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateTable;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateTableColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryCreateViewColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropMatView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropRoutine;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropTable;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropTableColumn;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryDropView;
import com.intellij.database.dialects.bigquery.generator.producers.BigQueryTruncateTable;
import com.intellij.database.dialects.bigquery.model.BigQueryArgument;
import com.intellij.database.dialects.bigquery.model.BigQueryDatabase;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeTable;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeView;
import com.intellij.database.dialects.bigquery.model.BigQueryMatView;
import com.intellij.database.dialects.bigquery.model.BigQueryMatViewColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryRoutine;
import com.intellij.database.dialects.bigquery.model.BigQuerySchema;
import com.intellij.database.dialects.bigquery.model.BigQueryTable;
import com.intellij.database.dialects.bigquery.model.BigQueryTableColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryView;
import com.intellij.database.dialects.bigquery.model.BigQueryViewColumn;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001c\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/bigquery/generator/BigQueryScriptGeneratorHelper;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "<init>", "()V", "supportsCreateIfNotExists", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "()Ljava/util/Set;", "createProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createDropProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "getTableTerm", "", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "createTruncateProducer", "Lcom/intellij/database/dialects/base/generator/producers/TruncateProducer;", "isOptionSupported", "", "option", "Lcom/intellij/database/script/generator/ScriptingOption;", "intellij.database.dialects.bigquery"})
public final class BigQueryScriptGeneratorHelper
extends ScriptGeneratorHelper {
    @NotNull
    public static final BigQueryScriptGeneratorHelper INSTANCE = new BigQueryScriptGeneratorHelper();

    private BigQueryScriptGeneratorHelper() {
        Dbms dbms = Dbms.BIGQUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"BIGQUERY");
        super(dbms);
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateIfNotExists() {
        Object[] objectArray = new ObjectKind[]{ObjectKind.DATABASE, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW};
        return SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof BigQueryTable ? (CreateProducer)new BigQueryCreateTable(context, (BigQueryTable)element) : (basicElement instanceof BigQueryView ? (CreateProducer)new BigQueryCreateLikeView<BigQueryLikeView>(context, (BigQueryLikeView)element) : (basicElement instanceof BigQueryMatView ? (CreateProducer)new BigQueryCreateMatView(context, (BigQueryMatView)element) : (basicElement instanceof BigQueryTableColumn ? (CreateProducer)new BigQueryCreateTableColumn(context, (BigQueryTableColumn)element) : (basicElement instanceof BigQueryViewColumn ? (CreateProducer)new BigQueryCreateViewColumn(context, (BigQueryViewColumn)element) : (basicElement instanceof BigQueryMatViewColumn ? (CreateProducer)new BigQueryCreateMatViewColumn(context, (BigQueryMatViewColumn)element) : (basicElement instanceof BigQueryRoutine ? (CreateProducer)new BigQueryCreateRoutine(context, (BigQueryRoutine)element) : super.createProducerImpl(context, element)))))));
    }

    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof BigQueryTable ? (DropProducer)new BigQueryDropTable(context, (BigQueryTable)element) : (basicElement instanceof BigQueryView ? (DropProducer)new BigQueryDropView(context, (BigQueryView)element) : (basicElement instanceof BigQueryMatView ? (DropProducer)new BigQueryDropMatView(context, (BigQueryMatView)element) : (basicElement instanceof BigQueryTableColumn ? (DropProducer)new BigQueryDropTableColumn(context, (BigQueryTableColumn)element) : (basicElement instanceof BigQueryRoutine ? (DropProducer)new BigQueryDropRoutine(context, (BigQueryRoutine)element) : super.createDropProducerImpl(context, element)))));
    }

    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        BasicElement it = elements.getSourceElement();
        boolean bl = false;
        BasicElement basicElement = it;
        return basicElement instanceof BigQueryTable ? (AlterProducerBase)new BigQueryAlterTable(context, (ElementAlteration<? extends BigQueryTable>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof BigQueryView ? (AlterProducerBase)new BigQueryAlterLikeView(context, BaseProducersKt.cast(elements, (BasicElement)it), null, 4, null) : (basicElement instanceof BigQueryMatView ? (AlterProducerBase)new BigQueryAlterMatView(context, (ElementAlteration<? extends BigQueryMatView>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof BigQueryTableColumn ? (AlterProducerBase)new BigQueryAlterTableColumn(context, (ElementAlteration<? extends BigQueryTableColumn>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof BigQueryViewColumn ? (AlterProducerBase)new BigQueryAlterViewColumn(context, (ElementAlteration<? extends BigQueryViewColumn>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof BigQueryMatViewColumn ? (AlterProducerBase)new BigQueryAlterMatViewColumn(context, (ElementAlteration<? extends BigQueryMatViewColumn>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof BigQueryDatabase ? (AlterProducerBase)new BigQueryAlterDatabase(context, (ElementAlteration<? extends BigQueryDatabase>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof BigQuerySchema ? (AlterProducerBase)new BigQueryAlterSchema(context, (ElementAlteration<? extends BigQuerySchema>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof BigQueryArgument ? (AlterProducerBase)new BigQueryAlterArgument(context, (ElementAlteration<? extends BigQueryArgument>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof BigQueryRoutine ? (AlterProducerBase)new BigQueryAlterRoutine(context, (ElementAlteration<? extends BigQueryRoutine>)BaseProducersKt.cast(elements, (BasicElement)it)) : super.createAlterProducerImpl(context, elements))))))))));
    }

    @NotNull
    public String getTableTerm(@Nullable BasicLikeTable table) {
        ObjectKind objectKind;
        BasicLikeTable basicLikeTable = table;
        Object object = objectKind = basicLikeTable != null ? basicLikeTable.getKind() : null;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? "view" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW) ? "materialized view" : "table");
    }

    @NotNull
    public TruncateProducer<?> createTruncateProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof BigQueryLikeTable ? (TruncateProducer)new BigQueryTruncateTable(context, (BigQueryLikeTable)element) : super.createTruncateProducer(context, element);
    }

    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        ScriptingOption<?> scriptingOption = option;
        return Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.IF_EXISTS) ? true : (Intrinsics.areEqual(scriptingOption, (Object)ScriptingOptionStatic.DROP_CASCADE) ? false : super.isOptionSupported(option));
    }
}

