/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import korlibs.crypto.Cipher;
import korlibs.crypto.CipherModeIV;
import korlibs.crypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0014J \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0014\u00a8\u0006\u000b"}, d2={"Lkorlibs/crypto/CipherModeCBC;", "Lkorlibs/crypto/CipherModeIV;", "()V", "coreDecrypt", "", "pData", "", "cipher", "Lkorlibs/crypto/Cipher;", "ivb", "coreEncrypt", "krypto"})
final class CipherModeCBC
extends CipherModeIV {
    @NotNull
    public static final CipherModeCBC INSTANCE = new CipherModeCBC();

    private CipherModeCBC() {
        super("CBC");
    }

    @Override
    protected void coreEncrypt(@NotNull byte[] pData, @NotNull Cipher cipher, @NotNull byte[] ivb) {
        int n = pData.length + -1;
        int n2 = cipher.getBlockSize();
        if (n2 <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + n2 + '.');
        }
        int n3 = 0;
        int n4 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)n2);
        int n5 = n2;
        if (n3 <= n4) {
            while (true) {
                KryptoToolsKt.arrayxor(pData, n3, ivb);
                cipher.encrypt(pData, n3, cipher.getBlockSize());
                KryptoToolsKt.arraycopy(pData, n3, ivb, 0, cipher.getBlockSize());
                if (n3 == n4) break;
                n3 += n5;
            }
        }
    }

    @Override
    protected void coreDecrypt(@NotNull byte[] pData, @NotNull Cipher cipher, @NotNull byte[] ivb) {
        int blockSize = cipher.getBlockSize();
        byte[] tempBytes = new byte[blockSize];
        int n = pData.length + -1;
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + blockSize + '.');
        }
        int n2 = 0;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)blockSize);
        if (n2 <= n3) {
            while (true) {
                KryptoToolsKt.arraycopy(pData, n2, tempBytes, 0, blockSize);
                cipher.decrypt(pData, n2, blockSize);
                KryptoToolsKt.arrayxor(pData, n2, ivb);
                KryptoToolsKt.arraycopy(tempBytes, 0, ivb, 0, blockSize);
                if (n2 == n3) break;
                n2 += blockSize;
            }
        }
    }
}

