/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.time.interval;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.datetime.Duration;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.core.commons.time.interval.TimeInterval;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/commons/time/interval/DurationInterval;", "Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "timeUnit", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "count", "", "(Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;I)V", "duration", "tickFormatPattern", "", "getTickFormatPattern", "()Ljava/lang/String;", "range", "", "", "start", "end", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "plot-base"})
@SourceDebugExtension(value={"SMAP\nDurationInterval.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DurationInterval.kt\norg/jetbrains/letsPlot/core/commons/time/interval/DurationInterval\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class DurationInterval
implements TimeInterval {
    @NotNull
    private final Duration timeUnit;
    @NotNull
    private final Duration duration;
    @NotNull
    private final String tickFormatPattern;

    public DurationInterval(@NotNull Duration timeUnit, int count2) {
        Intrinsics.checkNotNullParameter((Object)timeUnit, (String)"timeUnit");
        this.timeUnit = timeUnit;
        this.duration = this.timeUnit.mul(count2);
        this.tickFormatPattern = this.duration.compareTo(Duration.Companion.getMINUTE()) < 0 ? "%M:%S" : (this.duration.compareTo(Duration.Companion.getDAY()) < 0 ? "%H:%M" : "%b %e");
        if (!this.duration.isPositive()) {
            boolean bl = false;
            String string = "Duration must be positive.";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public String getTickFormatPattern() {
        return this.tickFormatPattern;
    }

    @Override
    @NotNull
    public List<Double> range(double start2, double end, @Nullable TimeZone tz) {
        double step2 = this.duration.getTotalMillis();
        double atomicStep = this.timeUnit.compareTo(Duration.Companion.getHOUR()) < 0 ? step2 : (double)this.timeUnit.getTotalMillis();
        ArrayList<Double> result2 = new ArrayList<Double>();
        for (double tick = Math.ceil(start2 / atomicStep) * atomicStep; tick <= end; tick += step2) {
            result2.add(tick);
        }
        return result2;
    }
}

