/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.interact.context;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.interact.EventsManager;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.InteractionUtil;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.builder.PlotTile;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.DataSelectionStrategy;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007H\u0016J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/interact/context/PlotTilesInteractionContext;", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "decorationsLayer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "eventsManager", "Lorg/jetbrains/letsPlot/core/interact/EventsManager;", "tiles", "", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotTile;", "dataSelectionStrategy", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/context/DataSelectionStrategy;", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;Lorg/jetbrains/letsPlot/core/interact/EventsManager;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/builder/interact/context/DataSelectionStrategy;)V", "getDecorationsLayer", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "getEventsManager", "()Lorg/jetbrains/letsPlot/core/interact/EventsManager;", "getTiles", "()Ljava/util/List;", "checkSupported", "", "eventSpecs", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSpec;", "clientRectToDataBounds", "clientRect", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "findTarget", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "plotCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotTilesInteractionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotTilesInteractionContext.kt\norg/jetbrains/letsPlot/core/plot/builder/interact/context/PlotTilesInteractionContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class PlotTilesInteractionContext
implements InteractionContext {
    @NotNull
    private final SvgNode decorationsLayer;
    @NotNull
    private final EventsManager eventsManager;
    @NotNull
    private final List<Pair<DoubleRectangle, PlotTile>> tiles;
    @NotNull
    private final DataSelectionStrategy dataSelectionStrategy;

    public PlotTilesInteractionContext(@NotNull SvgNode decorationsLayer, @NotNull EventsManager eventsManager, @NotNull List<Pair<DoubleRectangle, PlotTile>> tiles, @NotNull DataSelectionStrategy dataSelectionStrategy) {
        Intrinsics.checkNotNullParameter((Object)decorationsLayer, (String)"decorationsLayer");
        Intrinsics.checkNotNullParameter((Object)eventsManager, (String)"eventsManager");
        Intrinsics.checkNotNullParameter(tiles, (String)"tiles");
        Intrinsics.checkNotNullParameter((Object)dataSelectionStrategy, (String)"dataSelectionStrategy");
        this.decorationsLayer = decorationsLayer;
        this.eventsManager = eventsManager;
        this.tiles = tiles;
        this.dataSelectionStrategy = dataSelectionStrategy;
    }

    @Override
    @NotNull
    public SvgNode getDecorationsLayer() {
        return this.decorationsLayer;
    }

    @Override
    @NotNull
    public EventsManager getEventsManager() {
        return this.eventsManager;
    }

    @NotNull
    public final List<Pair<DoubleRectangle, PlotTile>> getTiles() {
        return this.tiles;
    }

    @Override
    @Nullable
    public InteractionTarget findTarget(@NotNull DoubleVector plotCoord) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
            Iterable iterable = this.tiles;
            for (Object t : iterable) {
                Pair pair2 = (Pair)t;
                boolean bl = false;
                DoubleRectangle geomBounds = (DoubleRectangle)pair2.component1();
                if (!geomBounds.contains(plotCoord)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Pair pair3 = v0;
        if (pair3 == null) {
            return null;
        }
        Pair target = pair3;
        DoubleRectangle geomBounds = (DoubleRectangle)target.component1();
        PlotTile tile2 = (PlotTile)target.component2();
        return new InteractionTarget(geomBounds, tile2, this){
            @NotNull
            private final DoubleRectangle geomBounds;
            @Nullable
            private final String id;
            final /* synthetic */ DoubleRectangle $geomBounds;
            final /* synthetic */ PlotTile $tile;
            final /* synthetic */ PlotTilesInteractionContext this$0;
            {
                this.$geomBounds = $geomBounds;
                this.$tile = $tile;
                this.this$0 = $receiver;
                this.geomBounds = $geomBounds;
                this.id = $tile.getPlotSpecId();
            }

            @NotNull
            public DoubleRectangle getGeomBounds() {
                return this.geomBounds;
            }

            @Nullable
            public String getId() {
                return this.id;
            }

            @NotNull
            public Pair<DoubleRectangle, Boolean> applyViewport(@NotNull DoubleRectangle screenViewport, @NotNull InteractionContext ctx2) {
                Intrinsics.checkNotNullParameter((Object)screenViewport, (String)"screenViewport");
                Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                Pair<DoubleVector, DoubleVector> pair2 = InteractionUtil.INSTANCE.viewportToTransform(this.$geomBounds, screenViewport);
                DoubleVector scale2 = (DoubleVector)pair2.component1();
                DoubleVector translate2 = (DoubleVector)pair2.component2();
                this.$tile.getTransientState().applyDelta(scale2, translate2, this.this$0);
                return new Pair((Object)this.$tile.getTransientState().getDataBounds(), (Object)this.$tile.getTransientState().isCoordFlip());
            }
        };
    }

    @Override
    @NotNull
    public DoubleRectangle clientRectToDataBounds(@NotNull DoubleRectangle clientRect, @NotNull CoordinateSystem coord) {
        Intrinsics.checkNotNullParameter((Object)clientRect, (String)"clientRect");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        return this.dataSelectionStrategy.clientRectToDataBounds(clientRect, coord);
    }

    @Override
    public void checkSupported(@NotNull List<? extends MouseEventSpec> eventSpecs) {
        Intrinsics.checkNotNullParameter(eventSpecs, (String)"eventSpecs");
        for (MouseEventSpec mouseEventSpec : eventSpecs) {
            Iterator<Pair<DoubleRectangle, PlotTile>> iterator2 = this.tiles.iterator();
            while (iterator2.hasNext()) {
                PlotTile tile2 = (PlotTile)iterator2.next().component2();
                tile2.checkMouseInteractionSupported(mouseEventSpec);
            }
        }
    }
}

