/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.relocated.apache.batik.ext.awt.image.spi.ImageWriter;
import org.jetbrains.relocated.apache.batik.ext.awt.image.spi.ImageWriterParams;
import org.jetbrains.relocated.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.jetbrains.relocated.apache.batik.svggen.DefaultCachedImageHandler;
import org.jetbrains.relocated.apache.batik.svggen.ImageCacher;
import org.jetbrains.relocated.apache.batik.svggen.SVGGraphics2DIOException;

public class CachedImageHandlerJPEGEncoder
extends DefaultCachedImageHandler {
    public static final String CACHED_JPEG_PREFIX = "jpegImage";
    public static final String CACHED_JPEG_SUFFIX = ".jpg";
    protected String refPrefix = "";

    public CachedImageHandlerJPEGEncoder(String imageDir, String urlRoot) throws SVGGraphics2DIOException {
        this.refPrefix = urlRoot + "/";
        this.setImageCacher(new ImageCacher.External(imageDir, CACHED_JPEG_PREFIX, CACHED_JPEG_SUFFIX));
    }

    @Override
    public void encodeImage(BufferedImage buf, OutputStream os) throws IOException {
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/jpeg");
        ImageWriterParams params = new ImageWriterParams();
        params.setJPEGQuality(1.0f, false);
        writer.writeImage(buf, os, params);
    }

    @Override
    public int getBufferedImageType() {
        return 1;
    }

    @Override
    public String getRefPrefix() {
        return this.refPrefix;
    }
}

