/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.datasource;

import com.intellij.persistence.database.DataSourcePropertyWithPrefixDataInfo;
import com.intellij.persistence.database.DbPropertySearchInfo;
import com.intellij.persistence.database.config.impl.CollectingDataSourceConfigProvider;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.datasource.QsDbPropertySearchInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/quarkus/config/datasource/QsConfigProvider;", "Lcom/intellij/persistence/database/config/impl/CollectingDataSourceConfigProvider;", "<init>", "()V", "toSearchInfo", "Lcom/intellij/persistence/database/DbPropertySearchInfo;", "key", "", "propertyInfo", "Lcom/intellij/persistence/database/DataSourcePropertyWithPrefixDataInfo;", "intellij.quarkus"})
public abstract class QsConfigProvider
extends CollectingDataSourceConfigProvider {
    @NotNull
    protected DbPropertySearchInfo toSearchInfo(@NotNull String key, @NotNull DataSourcePropertyWithPrefixDataInfo propertyInfo) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)propertyInfo, (String)"propertyInfo");
        String prefix = propertyInfo.getKeyPrefixInfo().getPrefix();
        String trimmedPrefix = QsConfigUtils.INSTANCE.trimProfile(prefix);
        String fullKey = StringsKt.removeSuffix((String)trimmedPrefix, (CharSequence)".") + "." + key;
        String databaseName = propertyInfo.getKeyPrefixInfo().getDatabaseName();
        String profile = QsConfigUtils.INSTANCE.getProfile(prefix);
        if (databaseName == null) {
            return new QsDbPropertySearchInfo(fullKey, null, profile, 2, null);
        }
        String configurationKey = StringsKt.replace$default((String)fullKey, (String)("." + databaseName), (String)"", (boolean)false, (int)4, null);
        return new QsDbPropertySearchInfo(fullKey, configurationKey, profile);
    }
}

