/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui;

import com.intellij.kubernetes.ui.FilePositionHyperlinkInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\"\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"extractSubdirectoryFileHyperlinks", "", "Lcom/intellij/kubernetes/ui/FilePositionHyperlinkInfo;", "text", "", "genericFileNameAndPositionPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getGenericFileNameAndPositionPattern$annotations", "()V", "intellij.clouds.kubernetes"})
public final class HelmConsoleUtilKt {
    private static final Pattern genericFileNameAndPositionPattern = Pattern.compile("[^\\/\\w\\.\\+\\-](((([\\w\\.\\+\\-]+)\\/)*([\\w\\.\\+\\-]+\\.[\\w]+))(:((\\d+)(:(\\d+))?))?)[^\\/\\w\\.\\+\\-]");

    @NotNull
    public static final Collection<FilePositionHyperlinkInfo> extractSubdirectoryFileHyperlinks(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List result = new ArrayList();
        Matcher templateFileMatcher = genericFileNameAndPositionPattern.matcher(text);
        while (templateFileMatcher.find()) {
            MatchResult matchResult = templateFileMatcher.toMatchResult();
            String path = matchResult.group(2);
            Object object = matchResult.group(8);
            Integer row = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? Integer.valueOf((Integer)object - 1) : null;
            Object object2 = matchResult.group(10);
            Integer col = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? Integer.valueOf((Integer)object2 - 1) : null;
            int startPosition = matchResult.start(1);
            int endPosition = matchResult.end(1);
            Intrinsics.checkNotNull((Object)path);
            result.add(new FilePositionHyperlinkInfo(path, row, col, startPosition, endPosition - startPosition));
        }
        return result;
    }

    private static /* synthetic */ void getGenericFileNameAndPositionPattern$annotations() {
    }
}

