/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.convertcontentstoattribute;

import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBBox;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import com.sixrr.xrp.utils.XMLRefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class ConvertContentsToAttributeDialog
extends BaseRefactoringDialog {
    private final JLabel wrappingTagNameLabel = new JLabel();
    private final JTextField wrappingTagNameField;
    private final JCheckBox trimTextBox;
    private final XmlTag tag;

    ConvertContentsToAttributeDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.tag = tag;
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle(RefactorXBundle.message("dialog.title.convert.tag.contents.to.attribute", new Object[0]));
        this.wrappingTagNameLabel.setText(RefactorXBundle.message("label.text.name.for.attribute", new Object[0]));
        this.wrappingTagNameField = new JTextField("");
        this.trimTextBox = new JCheckBox(RefactorXBundle.message("checkbox.trim.contents", new Object[0]));
        this.trimTextBox.setSelected(true);
        Document document = this.wrappingTagNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.ConvertContentsToAttribute";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.wrappingTagNameField;
    }

    public String getAttributeName() {
        return this.wrappingTagNameField.getText().trim();
    }

    public boolean getTrimContents() {
        return this.trimTextBox.isSelected();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        TitledBorder border = IdeBorderFactory.createTitledBorder((String)RefactorXBundle.message("border.title.convert.contents.of.tag.0", tagName));
        panel.add((Component)this.wrappingTagNameLabel, "North");
        JBBox box = JBBox.createVerticalBox();
        panel.setBorder(border);
        this.wrappingTagNameField.setEditable(true);
        box.add((Component)this.wrappingTagNameField);
        box.add((Component)this.trimTextBox);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        return XMLRefactoringUtil.attributeNameIsValid(this.getAttributeName()) && this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String attributeName = this.getAttributeName();
        if (this.getTrimContents()) {
            return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy> \n\t\t<xsl:attribute name = \"" + attributeName + "\">\n\t\t\t<xsl:value-of select=\"normalize-space(.)\"/>\n\t\t</xsl:attribute>\n\t</xsl:copy>\n</xsl:template>";
        }
        return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy> \n\t\t<xsl:attribute name = \"" + attributeName + "\">\n\t\t\t<xsl:value-of select=\".\"/>\n\t\t</xsl:attribute>\n\t</xsl:copy>\n</xsl:template>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.convertContentsToAttribute";
    }
}

