/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.gateway.utils;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.microservices.url.Authority;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.cloud.gateway.SpringCloudGatewayConstants;
import com.intellij.spring.boot.cloud.gateway.endpoints.SpringCloudGatewayUrlTargetInfo;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.UCallExpressionSearchParams;
import com.intellij.spring.mvc.utils.SpringMvcUrlUtils;
import com.intellij.uast.UastModificationTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;

public final class SpringCloudGatewayUtil {
    private static final Collection<String> PATH_METHOD_NAME_AS_COLLECTION = List.of("path");

    public static boolean hasSpringCloudGatewayLibrary(@NotNull Project project) {
        if (project == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(0);
        }
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.cloud.gateway.route.RouteLocator");
    }

    public static boolean hasSpringCloudGatewayLibrary(@NotNull Module module) {
        if (module == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(1);
        }
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.springframework.cloud.gateway.route.RouteLocator");
    }

    public static Set<SpringBeanPointer<?>> getRouteLocators(@NotNull Module module) {
        if (module == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(2);
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(SpringCloudGatewayUtil.getRouteLocatorBeans(module), (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)module.getProject()), UastModificationTracker.getInstance((Project)module.getProject())}));
    }

    public static Set<SpringBeanPointer<?>> getRouteLocatorBeans(@NotNull Module module) {
        if (module == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(3);
        }
        return SpringCloudGatewayUtil.getRouteLocatorBeans(module, SpringManager.getInstance((Project)module.getProject()).getAllModels(module));
    }

    private static Set<SpringBeanPointer<?>> getRouteLocatorBeans(@NotNull Module module, @NotNull Collection<SpringModel> models) {
        if (module == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(4);
        }
        if (models == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(5);
        }
        return SpringCloudGatewayUtil.getRouteLocatorBeans(module, models, "org.springframework.cloud.gateway.route.RouteLocator");
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> getRouteLocatorBeans(@NotNull Module module, @NotNull Collection<SpringModel> models, String ... routeLocatorClasses) {
        if (module == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(6);
        }
        if (models == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(7);
        }
        HashSet pointers = new HashSet();
        for (String routerFunctionClass : routeLocatorClasses) {
            PsiClass routerFunction = SpringCommonUtils.findLibraryClass((Module)module, (String)routerFunctionClass);
            if (routerFunction == null) continue;
            for (SpringModel model : models) {
                pointers.addAll(SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)routerFunction).withInheritors()));
            }
        }
        HashSet hashSet = pointers;
        if (hashSet == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public static Set<SpringCloudGatewayUrlTargetInfo> getRouteLocatorPaths(@NotNull Module module, @NotNull SpringBeanPointer<?> routeLocator) {
        PsiElement definition;
        if (module == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(9);
        }
        if (routeLocator == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(10);
        }
        if ((definition = routeLocator.getPsiElement()) == null || !definition.isValid()) {
            Set<SpringCloudGatewayUrlTargetInfo> set = Collections.emptySet();
            if (set == null) {
                SpringCloudGatewayUtil.$$$reportNull$$$0(11);
            }
            return set;
        }
        HashSet<SpringCloudGatewayUrlTargetInfo> paths = new HashSet<SpringCloudGatewayUrlTargetInfo>();
        List authorityList = SpringMvcUrlUtils.getAuthoritiesByModule((Module)module);
        for (UCallExpression uCallExpression : SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.cloud.gateway.route.builder.PredicateSpec", (String)"path"), (LocalSearchScope)new LocalSearchScope(definition))) {
            paths.addAll(SpringCloudGatewayUtil.findPaths(uCallExpression, authorityList));
        }
        HashSet<SpringCloudGatewayUrlTargetInfo> hashSet = paths;
        if (hashSet == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    private static Set<SpringCloudGatewayUrlTargetInfo> findPaths(@NotNull UCallExpression pathExpression, @NotNull List<Authority> authorityList) {
        if (pathExpression == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(13);
        }
        if (authorityList == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(14);
        }
        if (pathExpression.isMethodNameOneOf(PATH_METHOD_NAME_AS_COLLECTION)) {
            Set<SpringCloudGatewayUrlTargetInfo> set = pathExpression.getValueArguments().stream().map(expression -> {
                String urlPath = UastUtils.evaluateString((UExpression)expression);
                return urlPath != null ? SpringCloudGatewayUrlTargetInfo.create(urlPath, expression.getSourcePsi(), SpringCloudGatewayUtil.getMethods(expression), authorityList) : null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            if (set == null) {
                SpringCloudGatewayUtil.$$$reportNull$$$0(15);
            }
            return set;
        }
        Set<SpringCloudGatewayUrlTargetInfo> set = Collections.emptySet();
        if (set == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(16);
        }
        return set;
    }

    private static Set<String> getMethods(@NotNull UExpression expression) {
        UCallExpression uCallExpression;
        if (expression == null) {
            SpringCloudGatewayUtil.$$$reportNull$$$0(17);
        }
        if ((uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class)) == null) {
            return Collections.emptySet();
        }
        UQualifiedReferenceExpression outermostQualified = UastUtils.getOutermostQualified((UExpression)uCallExpression);
        if (outermostQualified == null) {
            return Collections.emptySet();
        }
        HashSet<String> methods = new HashSet<String>();
        for (UCallExpression callExpression : SpringFunctionalSearchersUtils.collectCallExpressionsInChain((UExpression)outermostQualified, (UCallExpressionPattern[])new UCallExpressionPattern[]{SpringCloudGatewayConstants.METHOD_NAME_PATTERN})) {
            for (UExpression uExpression : callExpression.getValueArguments()) {
                if (uExpression instanceof UReferenceExpression) {
                    String resolvedName = ((UReferenceExpression)uExpression).getResolvedName();
                    if (resolvedName == null) continue;
                    methods.add(resolvedName);
                    continue;
                }
                String evaluateString = UastUtils.evaluateString((UExpression)uExpression);
                if (evaluateString == null) continue;
                methods.add(evaluateString);
            }
        }
        return methods;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 12, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/cloud/gateway/utils/SpringCloudGatewayUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routeLocator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authorityList";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/cloud/gateway/utils/SpringCloudGatewayUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRouteLocatorBeans";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRouteLocatorPaths";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasSpringCloudGatewayLibrary";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRouteLocators";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRouteLocatorBeans";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRouteLocatorPaths";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findPaths";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11, 12, 15, 16 -> new IllegalStateException(string);
        };
    }
}

