/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.kubernetes.api.settings.KubeConfig;
import com.intellij.kubernetes.api.settings.KubernetesApiProjectSettings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.net.URL;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/KubernetesConfigFileSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "<init>", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "KubernetesConfigFileSchemaProvider", "KubernetesConfigFileSchemaProviderService", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesConfigFileSchemaProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesConfigFileSchemaProviderFactory.kt\ncom/intellij/kubernetes/KubernetesConfigFileSchemaProviderFactory\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,58:1\n30#2,2:59\n*S KotlinDebug\n*F\n+ 1 KubernetesConfigFileSchemaProviderFactory.kt\ncom/intellij/kubernetes/KubernetesConfigFileSchemaProviderFactory\n*L\n23#1:59,2\n*E\n"})
public final class KubernetesConfigFileSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<KubernetesConfigFileSchemaProviderService> serviceClass$iv = KubernetesConfigFileSchemaProviderService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((KubernetesConfigFileSchemaProviderService)object).getProviders();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\r\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/KubernetesConfigFileSchemaProviderFactory$KubernetesConfigFileSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getSchemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAvailable", "", "file", "getName", "", "Lorg/jetbrains/annotations/Nls;", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "intellij.clouds.kubernetes.backend"})
    private static final class KubernetesConfigFileSchemaProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project project;

        public KubernetesConfigFileSchemaProvider(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public VirtualFile getSchemaFile() {
            URL uRL = this.getClass().getClassLoader().getResource("api-spec/common/kubeconfig-schema.json");
            Intrinsics.checkNotNull((Object)uRL);
            URL resourceUrl = uRL;
            String string = VfsUtilCore.convertFromUrl((URL)resourceUrl);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertFromUrl(...)");
            String vfsUrl = string;
            VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(vfsUrl);
            Intrinsics.checkNotNull((Object)virtualFile);
            return virtualFile;
        }

        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return KubeConfig.isKubeConfig((VirtualFile)file, (Project)this.project);
        }

        @NotNull
        public String getName() {
            String string = KubernetesBundle.message((String)"Kubernetes.ConfigFileJsonSchemaProvider.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.schema;
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/KubernetesConfigFileSchemaProviderFactory$KubernetesConfigFileSchemaProviderService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "intellij.clouds.kubernetes.backend"})
    private static final class KubernetesConfigFileSchemaProviderService {
        @NotNull
        private final Project project;

        public KubernetesConfigFileSchemaProviderService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.project = project;
            this.project.getMessageBus().connect(coroutineScope).subscribe(KubernetesApiProjectSettings.TOPIC, (Object)new KubernetesApiProjectSettings.Listener(){

                public void onKubeConfigPathChanged(Set<? extends VirtualFile> oldFiles, Set<? extends VirtualFile> newFiles) {
                    Intrinsics.checkNotNullParameter(oldFiles, (String)"oldFiles");
                    Intrinsics.checkNotNullParameter(newFiles, (String)"newFiles");
                    MessageBus messageBus = project.getMessageBus();
                    Topic topic = JsonSchemaVfsListener.JSON_DEPS_CHANGED;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"JSON_DEPS_CHANGED");
                    ((Runnable)messageBus.syncPublisher(topic)).run();
                }
            });
        }

        @NotNull
        public final List<JsonSchemaFileProvider> getProviders() {
            return CollectionsKt.listOf((Object)new KubernetesConfigFileSchemaProvider(this.project));
        }
    }
}

