/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.tgz;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.TempCopyArchiveHandler;
import com.intellij.util.ArrayUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0014J\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/helm/tgz/TgzHandler;", "Lcom/intellij/openapi/vfs/impl/TempCopyArchiveHandler;", "path", "", "<init>", "(Ljava/lang/String;)V", "createEntriesMap", "", "Lcom/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo;", "contentsToByteArray", "", "relativePath", "getTempDir", "readContentsFromStream", "inputStream", "Ljava/io/InputStream;", "TarEntryInfo", "intellij.clouds.kubernetes.backend"})
public final class TgzHandler
extends TempCopyArchiveHandler {
    public TgzHandler(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() {
        HashMap map2 = new HashMap();
        Closeable closeable = (Closeable)new TarArchiveInputStream((InputStream)new GZIPInputStream(Files.newInputStream(this.getPath(), new OpenOption[0])));
        Throwable throwable = null;
        try {
            TarArchiveInputStream stream = (TarArchiveInputStream)closeable;
            boolean bl = false;
            while (stream.getNextEntry() != null) {
                TarArchiveEntry te;
                if (te.isDirectory()) {
                    this.processEntry(map2, te.getName(), null);
                    continue;
                }
                this.processEntry(map2, te.getName(), (arg_0, arg_1) -> TgzHandler.createEntriesMap$lambda$0$0(te, stream, arg_0, arg_1));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path path = this.getTempCopy(() -> TgzHandler.contentsToByteArray$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getTempCopy(...)");
        Path copy = path;
        Closeable closeable = Files.newInputStream(copy, new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            byte[] byArray = this.readContentsFromStream(relativePath, stream);
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    protected String getTempDir() {
        return "kubernetes/helm/tgz";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] readContentsFromStream(@NotNull String relativePath, @NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Object object = this.getEntryInfo(relativePath);
        TarEntryInfo tarEntryInfo = object instanceof TarEntryInfo ? (TarEntryInfo)((Object)object) : null;
        if (tarEntryInfo == null) {
            throw new FileNotFoundException(this.getPath() + " : " + relativePath);
        }
        TarEntryInfo info = tarEntryInfo;
        Closeable closeable = new BufferedInputStream(inputStream);
        object = null;
        try {
            BufferedInputStream stream = (BufferedInputStream)closeable;
            boolean bl = false;
            long offset = info.getOffset();
            long skipped = stream.skip(offset);
            if (skipped == offset) {
                long length = info.length;
                byte[] byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)length));
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"loadBytes(...)");
                byte[] byArray2 = byArray;
                return byArray2;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_BYTE_ARRAY, (String)"EMPTY_BYTE_ARRAY");
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    private static final ArchiveHandler.EntryInfo createEntriesMap$lambda$0$0(TarArchiveEntry $te, TarArchiveInputStream $stream, ArchiveHandler.EntryInfo parent, String name) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new TarEntryInfo(parent, name, $te.getSize(), $te.getModTime().getTime(), $stream.getBytesRead());
    }

    private static final InputStream contentsToByteArray$lambda$0(TgzHandler this$0) {
        return new GZIPInputStream(Files.newInputStream(this$0.getPath(), new OpenOption[0]));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/helm/tgz/TgzHandler$TarEntryInfo;", "Lcom/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo;", "parent", "shortName", "", "length", "", "timestamp", "offset", "<init>", "(Lcom/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo;Ljava/lang/CharSequence;JJJ)V", "getOffset", "()J", "intellij.clouds.kubernetes.backend"})
    private static final class TarEntryInfo
    extends ArchiveHandler.EntryInfo {
        private final long offset;

        public TarEntryInfo(@NotNull ArchiveHandler.EntryInfo parent, @NotNull CharSequence shortName, long length, long timestamp, long offset) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
            super(shortName, false, length, timestamp, parent);
            this.offset = offset;
        }

        public final long getOffset() {
            return this.offset;
        }
    }
}

