/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.jetbrains.performancePlugin.commands.CodeAnalysisStateListener;
import com.jetbrains.performancePlugin.commands.WaitForFinishedCodeAnalysisKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u000e\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J&\u0010\u000f\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener;", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "daemonStarting", "", "fileEditors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "daemonCanceled", "reason", "", "daemonFinished", "daemonFinishedOrCancelled", "isCancelled", "", "traceId", "Ljava/util/UUID;", "printFileEditors", "status", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nWaitForFinishedCodeAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,501:1\n30#2,2:502\n30#2,2:504\n1563#3:506\n1634#3,3:507\n1285#3,2:510\n1299#3,4:512\n*S KotlinDebug\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener\n*L\n400#1:502,2\n427#1:504,2\n433#1:506\n433#1:507,3\n424#1:510,2\n424#1:512,4\n*E\n"})
public final class WaitForFinishedCodeAnalysisListener
implements DaemonCodeAnalyzer.DaemonListener {
    @NotNull
    private final Project project;

    public WaitForFinishedCodeAnalysisListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        if (!ApplicationManagerEx.isInIntegrationTest()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        CodeAnalysisStateListener.Companion.getLOG().info("Daemon starting with " + fileEditors.size() + " unfiltered editors: " + CollectionsKt.joinToString$default((Iterable)fileEditors, (CharSequence)"\n", null, null, (int)0, null, WaitForFinishedCodeAnalysisListener::daemonStarting$lambda$0, (int)30, null));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<CodeAnalysisStateListener> serviceClass$iv = CodeAnalysisStateListener.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((CodeAnalysisStateListener)object).registerDaemonStarted(WaitForFinishedCodeAnalysisKt.access$getWorthy(fileEditors));
    }

    public void daemonCanceled(@NotNull String reason, @NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        UUID traceId = UUID.randomUUID();
        CodeAnalysisStateListener.Companion.getLOG().info("Daemon canceled by the reason of '" + reason + "', traceId = " + traceId);
        Intrinsics.checkNotNull((Object)traceId);
        this.daemonFinishedOrCancelled(fileEditors, true, traceId);
    }

    public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        UUID traceId = UUID.randomUUID();
        CodeAnalysisStateListener.Companion.getLOG().info("Daemon finished, traceId = " + traceId);
        Intrinsics.checkNotNull((Object)traceId);
        this.daemonFinishedOrCancelled(fileEditors, false, traceId);
    }

    private final void daemonFinishedOrCancelled(Collection<? extends FileEditor> fileEditors, boolean isCancelled, UUID traceId) {
        String status = isCancelled ? "cancelled" : "stopped";
        this.printFileEditors(fileEditors, status, traceId);
        List worthy = WaitForFinishedCodeAnalysisKt.access$getWorthy(fileEditors);
        if (worthy.isEmpty()) {
            return;
        }
        Map highlightedEditors = (Map)ActionsKt.runReadAction(() -> WaitForFinishedCodeAnalysisListener.daemonFinishedOrCancelled$lambda$0(this, worthy, isCancelled));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<CodeAnalysisStateListener> serviceClass$iv = CodeAnalysisStateListener.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((CodeAnalysisStateListener)object).registerDaemonFinishedOrCancelled$intellij_performanceTesting(highlightedEditors, status, traceId);
    }

    /*
     * WARNING - void declaration
     */
    public final void printFileEditors(@NotNull Collection<? extends FileEditor> fileEditors, @NotNull String status, @NotNull UUID traceId) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        try {
            void $this$mapTo$iv$iv;
            CodeAnalysisStateListener.Companion.getLOG().info("Daemon " + status + " with " + fileEditors.size() + " unfiltered editors, traceId = " + traceId);
            Iterable $this$map$iv = fileEditors;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void fileEditor;
                FileEditor fileEditor2 = (FileEditor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)fileEditor));
            }
            String editorsMessage = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            CodeAnalysisStateListener.Companion.getLOG().info("Editors to finish\n" + editorsMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final CharSequence daemonStarting$lambda$0(FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return WaitForFinishedCodeAnalysisKt.access$getDescription(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map daemonFinishedOrCancelled$lambda$0(WaitForFinishedCodeAnalysisListener this$0, List $worthy, boolean $isCancelled) {
        void $this$associateWithTo$iv$iv;
        boolean isFinishedInDumbMode = DumbService.Companion.isDumb(this$0.project);
        Iterable $this$associateWith$iv = $worthy;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            TextEditor textEditor = (TextEditor)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            CodeAnalysisStateListener.HighlightedEditor highlightedEditor = CodeAnalysisStateListener.HighlightedEditor.Companion.create((TextEditor)it, this$0.project, $isCancelled, isFinishedInDumbMode);
            map.put(t, highlightedEditor);
        }
        return destination$iv$iv;
    }
}

